/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.s3;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import thredds.inventory.MFile;
import thredds.inventory.MFileProvider;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.s3.CdmS3Client;
import ucar.unidata.io.s3.CdmS3Uri;
import ucar.unidata.io.s3.S3RandomAccessFile;

public class MFileS3
implements MFile {
    private static final Logger logger = LoggerFactory.getLogger(MFileS3.class);
    private final Supplier<HeadObjectResponse> headObjectResponse;
    private final CdmS3Uri cdmS3Uri;
    private final String key;
    private final String delimiter;
    private long length;
    private long lastMod;
    private Boolean exists;
    private Object auxInfo;

    public MFileS3(String s3Uri) throws IOException {
        this(s3Uri, -1L, -1L);
    }

    public MFileS3(CdmS3Uri s3Uri) {
        this(s3Uri, -1L, -1L);
    }

    public MFileS3(String s3Uri, long len, long lm) throws IOException {
        try {
            this.cdmS3Uri = new CdmS3Uri(s3Uri);
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to create a CdmS3Uri from: " + s3Uri, e);
        }
        this.key = this.getKey();
        this.delimiter = this.getDelimiter();
        this.length = len;
        this.lastMod = lm;
        this.headObjectResponse = () -> this.getHeadObjectResponse();
    }

    public MFileS3(CdmS3Uri s3Uri, long len, long lm) {
        this.cdmS3Uri = s3Uri;
        this.key = this.getKey();
        this.delimiter = this.getDelimiter();
        this.length = len;
        this.lastMod = lm;
        this.headObjectResponse = () -> this.getHeadObjectResponse();
    }

    @Nullable
    private String getKey() {
        return this.cdmS3Uri.getKey().isPresent() ? this.cdmS3Uri.getKey().get() : null;
    }

    @Nullable
    private String getDelimiter() {
        return this.cdmS3Uri.getDelimiter().isPresent() ? this.cdmS3Uri.getDelimiter().get() : null;
    }

    @Nullable
    private HeadObjectResponse getHeadObjectResponse() {
        HeadObjectResponse response = null;
        S3Client client = this.getClient();
        if (client != null) {
            HeadObjectRequest.Builder headObjectRequestBuilder = HeadObjectRequest.builder().bucket(this.cdmS3Uri.getBucket());
            if (this.key != null) {
                headObjectRequestBuilder.key(this.key);
            }
            response = client.headObject((HeadObjectRequest)headObjectRequestBuilder.build());
        }
        return response;
    }

    @Nullable
    private HeadBucketResponse getHeadBucketResponse() {
        HeadBucketResponse response = null;
        S3Client client = this.getClient();
        if (client != null) {
            HeadBucketRequest headBucketRequest = (HeadBucketRequest)HeadBucketRequest.builder().bucket(this.cdmS3Uri.getBucket()).build();
            response = client.headBucket(headBucketRequest);
        }
        return response;
    }

    @Nullable
    private S3Client getClient() {
        S3Client client = null;
        try {
            client = CdmS3Client.acquire(this.cdmS3Uri);
        }
        catch (IOException ioe) {
            logger.error("Could not create a CdmS3Client for {}", (Object)this.cdmS3Uri, (Object)ioe);
        }
        return client;
    }

    public long getLastModified() {
        return this.lastMod < 0L ? this.updateLastModified() : this.lastMod;
    }

    public long updateLastModified() {
        this.lastMod = this.headObjectResponse.get().lastModified().toEpochMilli();
        return this.lastMod;
    }

    public long getLength() {
        return this.length < 0L ? this.updateLength() : this.length;
    }

    public long updateLength() {
        this.length = this.headObjectResponse.get().contentLength();
        return this.length;
    }

    public boolean isDirectory() {
        boolean isDirectory = false;
        if (this.delimiter != null) {
            if (this.key != null && this.key.endsWith(this.delimiter)) {
                isDirectory = true;
            } else if (this.key == null) {
                isDirectory = true;
            }
        }
        return isDirectory;
    }

    public String getPath() {
        return this.cdmS3Uri.toString();
    }

    public String getName() {
        String name = this.key;
        if (this.key == null) {
            name = "";
        } else if (this.delimiter != null) {
            int lastDelimiter;
            if (this.key.endsWith(this.delimiter)) {
                name = name.substring(0, name.length() - this.delimiter.length());
            }
            if ((lastDelimiter = name.lastIndexOf(this.delimiter)) >= 0 && (name = name.substring(lastDelimiter)).startsWith(this.delimiter)) {
                name = name.substring(this.delimiter.length());
            }
        }
        return name;
    }

    @Nullable
    public MFile getParent() throws IOException {
        MFileS3 parentMfile = null;
        if (this.delimiter != null) {
            int childLoc;
            String currentName;
            String currentUri = this.getPath();
            String frag = "";
            int chop = currentUri.lastIndexOf("#");
            if (chop > 0) {
                frag = currentUri.substring(chop);
                currentUri = currentUri.substring(0, chop);
            }
            if (currentUri.endsWith(this.delimiter)) {
                currentUri = currentUri.substring(0, currentUri.length() - this.delimiter.length());
            }
            if ((currentName = this.getName()) != null && !currentName.isEmpty() && (childLoc = currentUri.lastIndexOf(currentName)) > 0) {
                String parentUri = currentUri.substring(0, childLoc);
                parentMfile = new MFileS3(parentUri + frag);
            }
        }
        return parentMfile;
    }

    public int compareTo(MFile o) {
        return this.getPath().compareTo(o.getPath());
    }

    @Nullable
    public Object getAuxInfo() {
        return this.auxInfo;
    }

    public void setAuxInfo(Object auxInfo) {
        this.auxInfo = auxInfo;
    }

    public int hashCode() {
        return Objects.hash(this.cdmS3Uri, this.key, this.delimiter, this.auxInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MFileS3)) {
            return false;
        }
        MFileS3 mFileS3 = (MFileS3)o;
        return this.cdmS3Uri.equals(mFileS3.cdmS3Uri) && Objects.equals(this.key, mFileS3.key) && Objects.equals(this.delimiter, mFileS3.delimiter) && Objects.equals(this.auxInfo, mFileS3.auxInfo);
    }

    public boolean exists() {
        if (this.exists == null) {
            this.updateExists();
        }
        return this.exists;
    }

    private void updateExists() {
        this.exists = this.isDirectory() ? Boolean.valueOf(this.directoryExists()) : Boolean.valueOf(this.key == null ? this.bucketExists() : this.objectExists());
    }

    private boolean directoryExists() {
        S3Client client = this.getClient();
        if (client == null) {
            return false;
        }
        try {
            ListObjectsV2Response listObjects = client.listObjectsV2((ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.cdmS3Uri.getBucket()).prefix(this.key).build());
            return listObjects.sdkHttpResponse().isSuccessful() && !listObjects.contents().isEmpty();
        }
        catch (NoSuchBucketException e) {
            return false;
        }
    }

    private boolean bucketExists() {
        try {
            HeadBucketResponse response = this.getHeadBucketResponse();
            return response != null && response.sdkHttpResponse().isSuccessful();
        }
        catch (NoSuchBucketException e) {
            return false;
        }
    }

    private boolean objectExists() {
        try {
            HeadObjectResponse response = this.headObjectResponse.get();
            return response != null && response.sdkHttpResponse().isSuccessful();
        }
        catch (NoSuchKeyException e) {
            return false;
        }
    }

    public ResponseInputStream<GetObjectResponse> getInputStream() {
        S3Client client = this.getClient();
        if (client == null) {
            return null;
        }
        GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.cdmS3Uri.getBucket()).key(this.key).build();
        return client.getObject(getObjectRequest);
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        try (ResponseInputStream<GetObjectResponse> responseInputStream = this.getInputStream();){
            IO.copy(responseInputStream, (OutputStream)outputStream);
        }
    }

    public void writeToStream(OutputStream outputStream, long offset, long maxBytes) throws IOException {
        S3RandomAccessFile.Provider provider = new S3RandomAccessFile.Provider();
        try (RandomAccessFile randomAccessFile = provider.open(this.cdmS3Uri.toString());){
            IO.copyRafB((RandomAccessFile)randomAccessFile, (long)offset, (long)maxBytes, (OutputStream)outputStream);
        }
    }

    @Nullable
    public MFileS3 getChild(String newFilename) {
        String existingKey = this.cdmS3Uri.getKey().orElse("");
        boolean addDelimiter = this.delimiter != null && !existingKey.endsWith(this.delimiter) && !existingKey.isEmpty();
        String newKey = addDelimiter ? existingKey + this.delimiter + newFilename : existingKey + newFilename;
        try {
            return new MFileS3(this.cdmS3Uri.resolveNewKey(newKey));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String relativize(MFile other) {
        if (!(other instanceof MFileS3)) {
            throw new IllegalArgumentException("Cannot relativize " + other + " against " + this);
        }
        MFileS3 otherS3 = (MFileS3)other;
        if (this.getDelimiter() != null && this.getDelimiter().equals("/") && this.getDelimiter().equals(otherS3.getDelimiter()) && this.cdmS3Uri.getBucket().equals(otherS3.cdmS3Uri.getBucket())) {
            String key = this.getKey() == null ? "/" : "/" + this.getKey();
            String otherKey = otherS3.getKey() == null ? "/" : "/" + otherS3.getKey();
            return Paths.get(key, new String[0]).relativize(Paths.get(otherKey, new String[0])).toString();
        }
        return "";
    }

    public static class Provider
    implements MFileProvider {
        private static String protocol = "cdms3";

        public String getProtocol() {
            return protocol;
        }

        @Nonnull
        public MFile create(String location) throws IOException {
            try {
                return new MFileS3(location);
            }
            catch (IOException ioe) {
                throw new IOException("Error creating MFileS3 for " + location, ioe);
            }
        }
    }
}

