/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.s3;

import com.google.re2j.Pattern;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.CollectionSpecParserAbstract;
import thredds.inventory.CollectionSpecParserProvider;

public class CollectionSpecParserS3
extends CollectionSpecParserAbstract {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String protocol = "cdms3";

    private CollectionSpecParserS3(String spec, String rootDir, String filterAndDateMark, String delimiter, String fragment, Formatter errlog) {
        super(spec, rootDir, filterAndDateMark, delimiter, fragment, errlog);
    }

    public static CollectionSpecParserS3 create(String collectionSpec, Formatter errlog) {
        String delimiter = CollectionSpecParserS3.getDelimiter(collectionSpec);
        String fragment = CollectionSpecParserS3.getFragment(collectionSpec);
        String rootDir = CollectionSpecParserS3.getRootDirForS3(collectionSpec, delimiter);
        String filterAndDateMark = CollectionSpecParserS3.getFilterAndDateMarkStringForS3(collectionSpec, delimiter);
        return new CollectionSpecParserS3(collectionSpec, rootDir, filterAndDateMark, delimiter, fragment, errlog);
    }

    public static CollectionSpecParserS3 create(String rootDir, String regExp, Formatter errlog) {
        String delimiter = CollectionSpecParserS3.getDelimiter(rootDir);
        String fragment = CollectionSpecParserS3.getFragment(rootDir);
        return new CollectionSpecParserS3(rootDir + delimiter + regExp, rootDir, regExp, delimiter, fragment, errlog);
    }

    public String getFilePath(String filename) {
        if (!this.rootDir.contains("?")) {
            return this.rootDir + "?" + filename;
        }
        return this.rootDir.endsWith(this.delimiter) ? this.rootDir + filename : this.rootDir + this.delimiter + filename;
    }

    private static String getRootDirForS3(String spec, String delimiter) {
        String[] hashSegments = spec.split("#");
        String specWithoutFragments = Arrays.stream(hashSegments).filter(s -> !s.contains("=")).collect(Collectors.joining(""));
        String bucket = specWithoutFragments.split(Pattern.quote((String)"?"))[0];
        String key = specWithoutFragments.contains("?") ? specWithoutFragments.split(Pattern.quote((String)"?"))[1] : "";
        String prefix = CollectionSpecParserS3.getRootDir((String)key, (String)"", (String)delimiter);
        return prefix.isEmpty() ? bucket : bucket + "?" + prefix + delimiter;
    }

    private static String getDelimiter(String spec) {
        if (!spec.toLowerCase(Locale.ROOT).contains("delimiter=")) {
            return "";
        }
        return spec.toLowerCase(Locale.ROOT).split("delimiter=")[1].substring(0, 1);
    }

    private static String getFragment(String spec) {
        String[] hashSegments = spec.split("#");
        String fragment = Arrays.stream(hashSegments).filter(s -> s.contains("=")).collect(Collectors.joining(""));
        return fragment.isEmpty() ? "" : "#" + fragment;
    }

    private static String getFilterAndDateMarkStringForS3(String spec, String delimiter) {
        if (!spec.contains("?")) {
            return null;
        }
        if (delimiter.isEmpty() && spec.contains("**")) {
            throw new IllegalArgumentException("Must set a delimiter in order to use pattern '**' in spec: " + spec);
        }
        String keyAndFragments = spec.split(Pattern.quote((String)"?"))[1];
        String[] hashSegments = keyAndFragments.split("#");
        List nonFragments = Arrays.stream(hashSegments).filter(segment -> !segment.contains("=")).collect(Collectors.toList());
        String key = String.join((CharSequence)"#", nonFragments);
        return CollectionSpecParserS3.getFilterAndDateMark((String)key, (String)delimiter);
    }

    public static class Provider
    implements CollectionSpecParserProvider {
        public String getProtocol() {
            return CollectionSpecParserS3.protocol;
        }

        public CollectionSpecParserAbstract create(String spec, Formatter errlog) {
            return CollectionSpecParserS3.create(spec, errlog);
        }

        public CollectionSpecParserAbstract create(String rootDir, String regEx, Formatter errlog) {
            return CollectionSpecParserS3.create(rootDir, regEx, errlog);
        }
    }
}

