/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util.test;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysStreamLogger {
    protected static Logger sysOutLogger = LoggerFactory.getLogger((String)"SYSOUT");
    protected static Logger sysErrLogger = LoggerFactory.getLogger((String)"SYSERR");
    public static final PrintStream sysout = System.out;
    public static final PrintStream syserr = System.err;
    protected static final String LINE_SEPERATOR = System.getProperty("line.separator");

    public static void bindSystemStreams() {
        System.setOut(new PrintStream(new LoggingOutputStream(sysOutLogger, false), true));
        System.setErr(new PrintStream(new LoggingOutputStream(sysErrLogger, true), true));
    }

    public static void unbindSystemStreams() {
        System.setOut(sysout);
        System.setErr(syserr);
    }

    protected static class LoggingOutputStream
    extends OutputStream {
        protected Logger log;
        protected boolean isError;
        protected boolean hasBeenClosed = false;
        protected byte[] buf;
        protected int count;
        protected int bufLength;
        public static final int DEFAULT_BUFFER_LENGTH = 2048;

        protected LoggingOutputStream() {
        }

        public LoggingOutputStream(Logger log, boolean isError) throws IllegalArgumentException {
            if (log == null) {
                throw new IllegalArgumentException("log == null");
            }
            this.isError = isError;
            this.log = log;
            this.bufLength = 2048;
            this.buf = new byte[2048];
            this.count = 0;
        }

        @Override
        public void close() {
            this.flush();
            this.hasBeenClosed = true;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.hasBeenClosed) {
                throw new IOException("The stream has been closed.");
            }
            if (b == 0) {
                return;
            }
            if (this.count == this.bufLength) {
                int newBufLength = this.bufLength + 2048;
                byte[] newBuf = new byte[newBufLength];
                System.arraycopy(this.buf, 0, newBuf, 0, this.bufLength);
                this.buf = newBuf;
                this.bufLength = newBufLength;
            }
            this.buf[this.count] = (byte)b;
            ++this.count;
        }

        @Override
        public void flush() {
            if (this.count == 0) {
                return;
            }
            if (this.count == LINE_SEPERATOR.length() && (char)this.buf[0] == LINE_SEPERATOR.charAt(0) && (this.count == 1 || this.count == 2 && (char)this.buf[1] == LINE_SEPERATOR.charAt(1))) {
                this.reset();
                return;
            }
            byte[] theBytes = new byte[this.count];
            System.arraycopy(this.buf, 0, theBytes, 0, this.count);
            if (this.isError) {
                this.log.error(new String(theBytes));
            } else {
                this.log.info(new String(theBytes));
            }
            this.reset();
        }

        protected void reset() {
            this.count = 0;
        }
    }
}

