/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util.test;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.write.Ncdump;
import ucar.unidata.util.test.Diff;
import ucar.unidata.util.test.SysStreamLogger;
import ucar.unidata.util.test.TestDir;

public abstract class UnitTestCommon {
    public static boolean LOGSTDIO = System.getProperty("intellij") == null;
    public static final boolean DEBUG = false;
    public static final Charset UTF8 = StandardCharsets.UTF_8;
    protected static final int[] OKCODES = new int[]{200, 404};
    protected static final Logger log = LoggerFactory.getLogger(UnitTestCommon.class);
    static final String[] DEFAULTSUBDIRS = new String[]{"httpservices", "cdm", "opendap", "dap4"};
    static final Set<NetcdfDataset.Enhance> ENHANCEMENT = EnumSet.of(NetcdfDataset.Enhance.CoordSystems);
    protected static String threddsroot = null;
    protected static String threddsServer = null;
    protected boolean prop_ascii = true;
    protected boolean prop_diff = true;
    protected boolean prop_baseline = false;
    protected boolean prop_visual = false;
    protected boolean prop_debug = false;
    protected boolean prop_generate = true;
    protected String prop_controls = null;
    protected boolean prop_display = false;
    protected String title = "Testing";
    protected String name = "testcommon";
    public static final String DRIVELETTERS;

    static String locateThreddsRoot() {
        String workspace = System.getenv("WORKSPACE");
        System.err.println("WORKSPACE=" + (workspace == null ? "null" : workspace));
        System.err.flush();
        String userdir = System.getProperty("user.dir");
        String path = workspace != null ? workspace : userdir;
        path = path.replace('\\', '/');
        assert (path != null);
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        for (File prefix = new File(path); prefix != null; prefix = prefix.getParentFile()) {
            String[] subdirs;
            int found = 0;
            block3: for (String dirname : subdirs = prefix.list()) {
                for (String want : DEFAULTSUBDIRS) {
                    if (!dirname.equals(want)) continue;
                    ++found;
                    continue block3;
                }
            }
            if (found != DEFAULTSUBDIRS.length) continue;
            try {
                String root = prefix.getCanonicalPath();
                root = root.replace('\\', '/');
                return root;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static String rebuildpath(String[] pieces, int last) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i <= last; ++i) {
            buf.append("/");
            buf.append(pieces[i]);
        }
        return buf.toString();
    }

    public static void clearDir(File dir, boolean clearsubdirs) {
        if (!dir.exists()) {
            return;
        }
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                if (!clearsubdirs) continue;
                UnitTestCommon.clearDir(f, true);
                f.delete();
                continue;
            }
            f.delete();
        }
    }

    public UnitTestCommon() {
        this("Testing");
    }

    public UnitTestCommon(String name) {
        this.title = name;
        this.setSystemProperties();
    }

    protected void setSystemProperties() {
        if (System.getProperty("nodiff") != null) {
            this.prop_diff = false;
        }
        if (System.getProperty("baseline") != null) {
            this.prop_baseline = true;
        }
        if (System.getProperty("nogenerate") != null) {
            this.prop_generate = false;
        }
        if (System.getProperty("debug") != null) {
            this.prop_debug = true;
        }
        if (System.getProperty("visual") != null) {
            this.prop_visual = true;
        }
        if (System.getProperty("ascii") != null) {
            this.prop_ascii = true;
        }
        if (System.getProperty("utf8") != null) {
            this.prop_ascii = false;
        }
        if (System.getProperty("hasdisplay") != null) {
            this.prop_display = true;
        }
        if (this.prop_baseline && this.prop_diff) {
            this.prop_diff = false;
        }
        this.prop_controls = System.getProperty("controls", "");
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getThreddsroot() {
        return threddsroot;
    }

    public String getName() {
        return this.name;
    }

    public String getResourceDir() {
        throw new UnsupportedOperationException();
    }

    public void visual(String header, String captured) {
        this.visual(header, captured, '-');
    }

    public void visual(String header, String captured, char marker) {
        if (!captured.endsWith("\n")) {
            captured = captured + "\n";
        }
        System.err.println("Testing " + this.getName() + ": " + header + ":");
        StringBuilder sep = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            sep.append(marker);
        }
        System.err.println(sep.toString());
        System.err.println("Testing " + this.title + ": " + header + ":");
        System.err.println("===============");
        System.err.println(captured);
        System.err.println(sep.toString());
        System.err.println("===============");
    }

    public static String compare(String tag, String baseline, String testresult) {
        if (testresult.trim().length() == 0) {
            return ">>>> EMPTY TEST RESULT";
        }
        try {
            Diff diff = new Diff(tag);
            StringWriter sw = new StringWriter();
            boolean pass = !diff.doDiff(baseline, testresult, (Writer)sw);
            return pass ? null : sw.toString();
        }
        catch (Exception e) {
            System.err.println("UnitTest: Diff failure: " + e);
            return null;
        }
    }

    public static boolean same(String tag, String baseline, String testresult) {
        String result = UnitTestCommon.compare(tag, baseline, testresult);
        if (result == null) {
            System.err.println("Files are Identical");
            return true;
        }
        System.err.println(result);
        return false;
    }

    public static boolean similar(String tag, String baseline, String testresult, Modifier mbaseline, Modifier mtest) {
        String testresultmod;
        String baselinemod = mbaseline.modify(baseline);
        String result = UnitTestCommon.compare(tag, baselinemod, testresultmod = mtest.modify(testresult));
        if (result == null) {
            System.err.println("Files are Similar");
            return true;
        }
        System.err.println(result);
        return false;
    }

    protected boolean checkServer(String candidate) {
        boolean bl;
        block9: {
            if (candidate == null) {
                return false;
            }
            System.err.print("Checking for sourceurl: " + candidate);
            HTTPMethod method = HTTPFactory.Get((String)candidate);
            try {
                method.execute();
                String s = method.getResponseAsString();
                System.err.println(" ; found");
                bl = true;
                if (method == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (method != null) {
                        try {
                            method.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ie) {
                    System.err.println(" ; fail");
                    return false;
                }
            }
            method.close();
        }
        return bl;
    }

    protected void bindstd() {
        if (LOGSTDIO) {
            SysStreamLogger.bindSystemStreams();
        }
    }

    protected void unbindstd() {
        if (LOGSTDIO) {
            SysStreamLogger.unbindSystemStreams();
        }
    }

    public static void writefile(String path, String content) throws IOException {
        File f = new File(path);
        if (f.exists()) {
            f.delete();
        }
        FileWriter out = new FileWriter(f);
        out.write(content);
        out.close();
    }

    public static void writefile(String path, byte[] content) throws IOException {
        File f = new File(path);
        if (f.exists()) {
            f.delete();
        }
        FileOutputStream out = new FileOutputStream(f);
        out.write(content);
        out.close();
    }

    public static String readfile(String filename) throws IOException {
        StringBuilder buf = new StringBuilder();
        Path file = Paths.get(filename, new String[0]);
        try (BufferedReader rdr = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            String line;
            while ((line = rdr.readLine()) != null) {
                if (line.startsWith("#")) continue;
                buf.append(line + "\n");
            }
            String string = buf.toString();
            return string;
        }
    }

    public static byte[] readbinaryfile(String filename) throws IOException {
        FileInputStream stream = new FileInputStream(filename);
        byte[] result = UnitTestCommon.readbinaryfile(stream);
        stream.close();
        return result;
    }

    public static byte[] readbinaryfile(InputStream stream) throws IOException {
        int cnt;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] tmp = new byte[65536];
        while ((cnt = stream.read(tmp)) > 0) {
            bytes.write(tmp, 0, cnt);
        }
        return bytes.toByteArray();
    }

    public static NetcdfDataset openDataset(String url) throws IOException {
        DatasetUrl durl = DatasetUrl.findDatasetUrl((String)url);
        return NetcdfDataset.acquireDataset(null, (DatasetUrl)durl, ENHANCEMENT, (int)-1, null, null);
    }

    public static String shortenFileName(String text, String filename) {
        String fixed = filename.replace('\\', '/');
        String shortname = filename;
        if (fixed.lastIndexOf(47) >= 0) {
            shortname = filename.substring(fixed.lastIndexOf(47) + 1, filename.length());
        }
        text = text.replaceAll(filename, shortname);
        return text;
    }

    public static void tag(String t) {
        System.err.println(t);
        System.err.flush();
    }

    public static String canonjoin2(String prefix, String suffix) {
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        StringBuilder result = new StringBuilder(prefix);
        if (!prefix.endsWith("/")) {
            result.append("/");
        }
        result.append(suffix.startsWith("/") ? suffix.substring(1) : suffix);
        return result.toString();
    }

    public static String canonjoin(String ... pieces) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < pieces.length; ++i) {
            String piece = pieces[i];
            if (piece == null) continue;
            piece = UnitTestCommon.canonicalpath(piece);
            if (i == 0) {
                buf.append(piece);
                continue;
            }
            if (!piece.startsWith("/")) {
                buf.append("/");
            }
            buf.append(piece);
        }
        return buf.toString();
    }

    public static String canonicalpath(String path) {
        if (path == null) {
            return null;
        }
        path = path.trim();
        if ((path = path.replace('\\', '/')).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (UnitTestCommon.hasDriveLetter(path)) {
            path = path.substring(0, 1).toLowerCase() + path.substring(1);
        }
        return path;
    }

    public static boolean hasDriveLetter(String path) {
        if (path != null && path.length() >= 2) {
            return DRIVELETTERS.indexOf(path.charAt(0)) >= 0 && path.charAt(1) == ':';
        }
        return false;
    }

    public static String extractDatasetname(String urlorpath, String suffix) {
        try {
            URI x = new URI(urlorpath);
            StringBuilder path = new StringBuilder(x.getPath());
            int index = path.lastIndexOf("/");
            if (index < 0) {
                index = 0;
            }
            if (index > 0) {
                path.delete(0, index + 1);
            }
            if (suffix != null) {
                path.append('.');
                path.append(suffix);
            }
            return path.toString();
        }
        catch (URISyntaxException e) {
            assert (false);
            return null;
        }
    }

    protected static String ncdumpmetadata(NetcdfFile ncfile, String datasetname) throws Exception {
        StringWriter sw = new StringWriter();
        StringBuilder args = new StringBuilder("-strict");
        if (datasetname != null) {
            args.append(" -datasetname ");
            args.append(datasetname);
        }
        try {
            Ncdump.ncdump((NetcdfFile)ncfile, (String)args.toString(), (Writer)sw, null);
        }
        catch (IOException ioe) {
            throw new Exception("NcdumpW failed", ioe);
        }
        sw.close();
        return sw.toString();
    }

    protected static String ncdumpdata(NetcdfFile ncfile, String datasetname) throws Exception {
        StringBuilder args = new StringBuilder("-strict -vall");
        if (datasetname != null) {
            args.append(" -datasetname ");
            args.append(datasetname);
        }
        StringWriter sw = new StringWriter();
        try {
            Ncdump.ncdump((NetcdfFile)ncfile, (String)args.toString(), (Writer)sw, null);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new Exception("NCdumpW failed", ioe);
        }
        sw.close();
        return sw.toString();
    }

    public static String[] propertiesToArgs(String prefix, String ... options) {
        if (options == null || options.length == 0) {
            throw new IllegalArgumentException("No options specified");
        }
        if (prefix == null) {
            prefix = "--";
        }
        ArrayList<String> args = new ArrayList<String>();
        Set<String> defined = System.getProperties().stringPropertyNames();
        for (String key : options) {
            if (!defined.contains(key)) continue;
            String value = System.getProperty(key);
            args.add(prefix + key);
            if (value == null) continue;
            args.add(value);
        }
        return args.toArray(new String[args.size()]);
    }

    protected static boolean check(int code) {
        return UnitTestCommon.check(code, OKCODES);
    }

    protected static boolean check(int code, int[] ok) {
        for (int okcode : ok) {
            if (okcode != code) continue;
            return true;
        }
        return false;
    }

    static {
        threddsroot = UnitTestCommon.locateThreddsRoot();
        assert (threddsroot != null) : "Cannot locate /thredds parent dir";
        threddsServer = TestDir.remoteTestServer;
        DRIVELETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ" + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase();
    }

    public static class ModSuppress
    implements Modifier {
        protected List<Pattern> patterns = new ArrayList<Pattern>();

        public void suppress(String attributename) {
            String re = String.format("<Attribute[ ]+name=\"%s\".*</Attribute>[^\n]\n", attributename);
            Pattern pattern = Pattern.compile((String)re);
            this.patterns.add(pattern);
        }

        @Override
        public String modify(String text) {
            StringBuilder result = new StringBuilder(text);
            for (Pattern p : this.patterns) {
                Matcher m;
                while ((m = p.matcher((CharSequence)result.toString())).matches()) {
                    int pos0 = m.start();
                    int pos1 = m.end();
                    result.delete(pos0, pos1);
                }
            }
            return result.toString();
        }
    }

    public static class ModDelete
    implements Modifier {
        protected Pattern pattern = null;

        public ModDelete(String regexp) {
            this.pattern = Pattern.compile((String)regexp);
        }

        @Override
        public String modify(String text) {
            String[] lines = text.split("[\n]");
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                Matcher m = this.pattern.matcher((CharSequence)line);
                if (!m.matches()) continue;
                result.append(line);
                result.append("\n");
            }
            return result.toString();
        }
    }

    public static interface Modifier {
        public String modify(String var1);
    }
}

