/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.builder.CatalogBuilder;
import ucar.unidata.util.StringUtil2;
import ucar.unidata.util.test.TestDir;

public class ClientCatalogUtil {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static String dataDir = TestDir.cdmLocalTestDataDir + "thredds/catalog/";

    public static String makeUrlFromFragment(String catFrag) {
        return "file:" + TestDir.cdmLocalTestDataDir + "thredds/catalog/" + catFrag;
    }

    public static Catalog open(String urlString) throws IOException {
        urlString = !urlString.startsWith("http:") && !urlString.startsWith("file:") ? ClientCatalogUtil.makeUrlFromFragment(urlString) : StringUtil2.replace((String)urlString, (String)"\\", (String)"/");
        logger.debug("Open {}", (Object)urlString);
        CatalogBuilder builder = new CatalogBuilder();
        Catalog cat = builder.buildFromLocation(urlString, null);
        if (builder.hasFatalError()) {
            logger.error(builder.getErrorMessage());
            assert (false);
            return null;
        }
        String mess = builder.getErrorMessage();
        if (mess.length() > 0) {
            logger.debug("Parse messages: {}", (Object)builder.getErrorMessage());
        }
        return cat;
    }

    public static String makeFilepath(String catalogName) {
        return ClientCatalogUtil.makeFilepath() + catalogName;
    }

    public static String makeFilepath() {
        return "file:" + dataDir;
    }
}

