/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util.test;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import org.jdom2.Element;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.internal.util.CompareNetcdf2;
import ucar.nc2.write.NcmlWriter;

public class CompareNcml {
    private final TemporaryFolder tempFolder;
    private final boolean showFiles;
    private final boolean compareData;
    private final DatasetUrl durl;

    public CompareNcml(TemporaryFolder tempFolder, DatasetUrl durl, boolean compareData, boolean showFiles) throws IOException {
        this.tempFolder = tempFolder;
        this.durl = durl;
        this.compareData = compareData;
        this.showFiles = showFiles;
        this.compareNcML(true, true, true);
        this.compareNcML(true, false, false);
        this.compareNcML(false, true, false);
        this.compareNcML(false, false, true);
        this.compareNcML(false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareNcML(boolean useRecords, boolean explicit, boolean openDataset) throws IOException {
        String ncmlOut;
        Object org;
        String iospMessage;
        block10: {
            if (this.compareData) {
                useRecords = false;
            }
            if (this.showFiles) {
                System.out.println("-----------");
                System.out.println("  input filename= " + this.durl.getTrueurl());
            }
            iospMessage = useRecords ? "AddRecordStructure" : null;
            org = openDataset ? NetcdfDatasets.openDataset((DatasetUrl)this.durl, null, (int)-1, null, (Object)iospMessage) : NetcdfDatasets.acquireFile(null, null, (DatasetUrl)this.durl, (int)-1, null, (Object)iospMessage);
            ncmlOut = this.tempFolder.newFile().getAbsolutePath();
            if (this.showFiles) {
                System.out.println(" output filename= " + ncmlOut);
            }
            try {
                NcmlWriter ncmlWriter = new NcmlWriter();
                Element netcdfElement = explicit ? ncmlWriter.makeExplicitNetcdfElement((NetcdfFile)org, null) : ncmlWriter.makeNetcdfElement((NetcdfFile)org, null);
                ncmlWriter.writeToFile(netcdfElement, new File(ncmlOut));
            }
            catch (IOException ioe) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)ioe.getMessage());
            }
        }
        DatasetUrl durlcopy = DatasetUrl.findDatasetUrl((String)ncmlOut);
        Object copy = openDataset ? NetcdfDatasets.openDataset((DatasetUrl)durlcopy, null, (int)-1, null, (Object)iospMessage) : NetcdfDatasets.acquireFile(null, null, (DatasetUrl)durlcopy, (int)-1, null, (Object)iospMessage);
        try {
            Formatter f = new Formatter();
            CompareNetcdf2 mind = new CompareNetcdf2(f, false, false, this.compareData);
            boolean ok = mind.compare((NetcdfFile)org, (NetcdfFile)copy, (CompareNetcdf2.ObjFilter)new CompareNetcdf2.Netcdf4ObjectFilter());
            if (!ok) {
                System.out.printf("--Compare %s, useRecords=%s explicit=%s openDataset=%s compareData=%s %n", this.durl.getTrueurl(), useRecords, explicit, openDataset, this.compareData);
                System.out.printf("  %s%n", f);
            } else {
                System.out.printf("--Compare %s is OK (useRecords=%s explicit=%s openDataset=%s compareData=%s)%n", this.durl.getTrueurl(), useRecords, explicit, openDataset, this.compareData);
            }
            Assert.assertTrue((String)this.durl.getTrueurl(), (boolean)ok);
        }
        finally {
            org.close();
            copy.close();
        }
    }
}

