/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util.test;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Variable;
import ucar.nc2.internal.util.AliasTranslator;
import ucar.unidata.io.RandomAccessFile;

public class TestDir {
    private static final Logger logger;
    private static final String testdataDirPropName = "unidata.testdata.path";
    private static String testdataDir;
    public static String cdmUnitTestDir;
    public static String cdmLocalTestDataDir;
    public static String cdmTestDataDir;
    private static String remoteTestServerPropName;
    public static String remoteTestServer;
    public static String dap2TestServerPropName;
    public static String dap2TestServer;
    public static String dap4TestServerPropName;
    public static String dap4TestServer;
    private static int max_size;
    static final String[] DEFAULTSUBDIRS;

    public static NetcdfFile open(String filename) throws IOException {
        logger.debug("**** Open {}", (Object)filename);
        NetcdfFile ncfile = NetcdfFiles.open((String)filename, null);
        logger.debug("open {}", (Object)ncfile);
        return ncfile;
    }

    public static NetcdfFile openFileLocal(String filename) throws IOException {
        return TestDir.open(cdmLocalTestDataDir + filename);
    }

    public static long checkLeaks() {
        if (RandomAccessFile.getOpenFiles().size() > 0) {
            logger.debug("RandomAccessFile still open:");
            for (String filename : RandomAccessFile.getOpenFiles()) {
                logger.debug("  open= {}", (Object)filename);
            }
        } else {
            logger.debug("RandomAccessFile: no leaks");
        }
        logger.debug("RandomAccessFile: count open={}, max={}", (Object)RandomAccessFile.getOpenFileCount(), (Object)RandomAccessFile.getMaxOpenFileCount());
        return RandomAccessFile.getOpenFiles().size();
    }

    public static FileFilter FileFilterSkipSuffix(String suffixes) {
        return new FileFilterNoWant(suffixes);
    }

    public static int actOnAll(String dirName, FileFilter ff, Act act) throws IOException {
        return TestDir.actOnAll(dirName, ff, act, true);
    }

    public static int actOnAll(String dirName, FileFilter ff, Act act, boolean recurse) throws IOException {
        int count = 0;
        logger.debug("---------------Reading directory {}", (Object)dirName);
        File allDir = new File(dirName);
        File[] allFiles = allDir.listFiles();
        if (null == allFiles) {
            logger.debug("---------------INVALID {}", (Object)dirName);
            throw new FileNotFoundException("Cant open " + dirName);
        }
        List<File> flist = Arrays.asList(allFiles);
        Collections.sort(flist);
        for (File f : flist) {
            String name = f.getAbsolutePath();
            if (f.isDirectory() || ff != null && !ff.accept(f) || name.endsWith(".exclude")) continue;
            name = name.replace("\\", "/");
            logger.debug("----acting on file {}", (Object)name);
            count += act.doAct(name);
        }
        if (!recurse) {
            return count;
        }
        for (File f : allFiles) {
            if (!f.isDirectory() || f.getName().equals("exclude") || f.getName().equals("problem")) continue;
            count += TestDir.actOnAll(f.getAbsolutePath(), ff, act);
        }
        return count;
    }

    public static int actOnAllParameterized(String dirName, FileFilter ff, Collection<Object[]> filenames) throws IOException {
        return TestDir.actOnAll(dirName, ff, new ListAction(filenames), true);
    }

    public static int actOnAllParameterized(String dirName, FileFilter ff, Collection<Object[]> filenames, boolean recurse) throws IOException {
        return TestDir.actOnAll(dirName, ff, new ListAction(filenames), recurse);
    }

    public static void readAll(String filename) throws IOException {
        ReadAllVariables act = new ReadAllVariables();
        act.doAct(filename);
    }

    static Section makeSubset(Variable v) {
        int[] shape = v.getShape();
        shape[0] = 1;
        Section s = new Section(shape);
        long size = s.computeSize();
        shape[0] = (int)Math.max(1L, (long)max_size / size);
        return new Section(shape);
    }

    public static int readAllData(NetcdfFile ncfile) throws IOException {
        logger.debug("------Reading ncfile {}", (Object)ncfile.getLocation());
        try {
            for (Variable v : ncfile.getVariables()) {
                if (v.getSize() > (long)max_size) {
                    Section s = TestDir.makeSubset(v);
                    logger.debug("  Try to read variable {} size={} section={}", new Object[]{v.getNameAndDimensions(), v.getSize(), s});
                    v.read(s);
                    continue;
                }
                logger.debug("  Try to read variable {} size={}", (Object)v.getNameAndDimensions(), (Object)v.getSize());
                v.read();
            }
            return 1;
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
    }

    public static String locateThreddsRoot() {
        String workspace = System.getenv("WORKSPACE");
        System.err.println("WORKSPACE=" + (workspace == null ? "null" : workspace));
        System.err.flush();
        String userdir = System.getProperty("user.dir");
        String path = workspace != null ? workspace : userdir;
        path = path.replace('\\', '/');
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        for (File prefix = new File(path); prefix != null; prefix = prefix.getParentFile()) {
            int found = 0;
            String[] subdirs = prefix.list();
            assert (subdirs != null);
            block3: for (String dirname : subdirs) {
                for (String want : DEFAULTSUBDIRS) {
                    if (!dirname.equals(want)) continue;
                    ++found;
                    continue block3;
                }
            }
            if (found != DEFAULTSUBDIRS.length) continue;
            try {
                String root = prefix.getCanonicalPath();
                root = root.replace('\\', '/');
                return root;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        String d4ts;
        String dts;
        String rts;
        File file;
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        cdmLocalTestDataDir = "../cdm-core/src/test/data/";
        cdmTestDataDir = "../cdm-test/src/test/data/";
        remoteTestServerPropName = "remotetestserver";
        remoteTestServer = "localhost:8081";
        dap2TestServerPropName = "dts";
        dap2TestServer = "localhost:8080";
        dap4TestServerPropName = "d4ts";
        dap4TestServer = "localhost:8080";
        testdataDir = System.getProperty(testdataDirPropName);
        if (testdataDir == null) {
            testdataDir = "/share/testdata/";
            logger.warn("No '{}' property found; using default value '{}'.", (Object)testdataDirPropName, (Object)testdataDir);
        }
        if (!(testdataDir = testdataDir.replace('\\', '/')).endsWith("/")) {
            testdataDir = testdataDir + "/";
        }
        if (!(file = new File(cdmUnitTestDir = testdataDir + "cdmUnitTest/")).exists() || !file.isDirectory()) {
            logger.warn("cdmUnitTest directory does not exist: {}", (Object)file.getAbsolutePath());
        }
        if ((rts = System.getProperty(remoteTestServerPropName)) != null && rts.length() > 0) {
            remoteTestServer = rts;
        }
        if ((dts = System.getProperty(dap2TestServerPropName)) != null && dts.length() > 0) {
            dap2TestServer = dts;
        }
        if ((d4ts = System.getProperty(dap4TestServerPropName)) != null && d4ts.length() > 0) {
            dap4TestServer = d4ts;
        }
        AliasTranslator.addAlias((String)"${cdmUnitTest}", (String)cdmUnitTestDir);
        max_size = 10000000;
        DEFAULTSUBDIRS = new String[]{"httpservices", "cdm", "opendap"};
    }

    private static class ReadAllVariables
    implements Act {
        private ReadAllVariables() {
        }

        @Override
        public int doAct(String filename) throws IOException {
            try (NetcdfFile ncfile = NetcdfFiles.open((String)filename);){
                int n = TestDir.readAllData(ncfile);
                return n;
            }
        }
    }

    private static class ListAction
    implements Act {
        Collection<Object[]> filenames;

        ListAction(Collection<Object[]> filenames) {
            this.filenames = filenames;
        }

        @Override
        public int doAct(String filename) {
            this.filenames.add(new Object[]{filename});
            return 0;
        }
    }

    private static class FileFilterNoWant
    implements FileFilter {
        String[] suffixes;

        FileFilterNoWant(String suffixes) {
            this.suffixes = suffixes.split(" ");
        }

        @Override
        public boolean accept(File file) {
            for (String s : this.suffixes) {
                if (!file.getPath().endsWith(s)) continue;
                return false;
            }
            return true;
        }
    }

    public static class FileFilterFromSuffixes
    implements FileFilter {
        String[] suffixes;

        public FileFilterFromSuffixes(String suffixes) {
            this.suffixes = suffixes.split(" ");
        }

        @Override
        public boolean accept(File file) {
            for (String s : this.suffixes) {
                if (!file.getPath().endsWith(s)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Act {
        public int doAct(String var1) throws IOException;
    }
}

