/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util.test;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;

public class TestFileDirUtils {
    private TestFileDirUtils() {
    }

    public static File addDirectory(File parentDir, String dirName) {
        return TestFileDirUtils.addDirectory(parentDir, dirName, -1L);
    }

    public static File addDirectory(File parentDir, String dirName, long lastModTime) {
        Assert.assertTrue((String)("Parent file does not exist <" + parentDir.getPath() + ">."), (boolean)parentDir.exists());
        Assert.assertTrue((String)("Parent file not a directory <" + parentDir.getPath() + ">."), (boolean)parentDir.isDirectory());
        File newDir = new File(parentDir, dirName);
        Assert.assertFalse((String)("New directory already exists [" + newDir.getPath() + "]."), (boolean)newDir.exists());
        Assert.assertTrue((String)("Failed to create the new directory [" + newDir.getAbsolutePath() + "]."), (boolean)newDir.mkdirs());
        if (lastModTime > 0L) {
            Assert.assertTrue((String)("Failed to set lastModified time on directory [" + newDir.getPath() + "]."), (boolean)newDir.setLastModified(lastModTime));
        }
        return newDir;
    }

    public static File addFile(File parentDir, String fileName) {
        return TestFileDirUtils.addFile(parentDir, fileName, -1L);
    }

    public static File addFile(File parentDir, String fileName, long lastModTime) {
        Assert.assertTrue((String)("Parent file does not exist <" + parentDir.getPath() + ">."), (boolean)parentDir.exists());
        Assert.assertTrue((String)("Parent file not a directory <" + parentDir.getPath() + ">."), (boolean)parentDir.isDirectory());
        File newFile = new File(parentDir, fileName);
        Assert.assertFalse((String)("New file [" + newFile.getAbsolutePath() + "] already exists."), (boolean)newFile.exists());
        Assert.assertEquals((String)("Multiple levels not allowed in file name <" + fileName + ">."), (Object)newFile.getParentFile(), (Object)parentDir);
        try {
            Assert.assertTrue((String)("Failed to create new file [" + newFile.getAbsolutePath() + "]."), (boolean)newFile.createNewFile());
        }
        catch (IOException e) {
            Assert.fail((String)("Failed to create new file <" + newFile.getAbsolutePath() + ">: " + e.getMessage()));
        }
        if (lastModTime > 0L) {
            Assert.assertTrue((String)("Failed to set lastModified time on file [" + newFile.getPath() + "]."), (boolean)newFile.setLastModified(lastModTime));
        }
        return newFile;
    }
}

