/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util.test;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.unidata.util.test.UtilsMa2Test;

public class UtilsTestStructureArray {
    public void testArrayStructure(ArrayStructure as) {
        block2: {
            try {
                this.testArrayStructureByRecno(as);
                this.testArrayStructureByIterator(as);
                this.testArrayStructureByMemberArray(as);
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private double testArrayStructureByMemberArray(ArrayStructure as) throws IOException {
        List members = as.getMembers();
        for (StructureMembers.Member m : members) {
            Array memberArray = as.extractMemberArray(m);
            assert (memberArray.getElementType() == m.getDataType().getPrimitiveClassType());
            if (m.getDataType().isNumeric()) {
                double sum = 0.0;
                while (memberArray.hasNext()) {
                    sum += memberArray.nextDouble();
                }
                return sum;
            }
            if (!m.getDataType().isString()) continue;
            while (memberArray.hasNext()) {
                System.out.println(" " + memberArray.next());
            }
        }
        return 0.0;
    }

    private void testArrayStructureByIterator(ArrayStructure as) throws IOException {
        try (StructureDataIterator si = as.getStructureDataIterator();){
            while (si.hasNext()) {
                StructureData sdata = si.next();
                List members = sdata.getMembers();
                for (StructureMembers.Member m : members) {
                    Array sdataArray = sdata.getArray(m);
                    assert (sdataArray.getElementType() == m.getDataType().getPrimitiveClassType());
                }
                this.testStructureData(sdata);
            }
        }
    }

    private void testArrayStructureByRecno(ArrayStructure as) {
        int recno = 0;
        while ((long)recno < as.getSize()) {
            Object o = as.getObject(recno);
            assert (o instanceof StructureData);
            StructureData sdata = as.getStructureData(recno);
            assert (o == sdata);
            List members = sdata.getMembers();
            for (StructureMembers.Member m : members) {
                Array sdataArray = sdata.getArray(m);
                assert (sdataArray.getElementType() == m.getDataType().getPrimitiveClassType()) : sdataArray.getElementType() + " != " + m.getDataType().getPrimitiveClassType();
                Array sdataArray2 = sdata.getArray(m.getName());
                UtilsMa2Test.testEquals(sdataArray, sdataArray2);
                Array a = as.getArray(recno, m);
                assert (a.getElementType() == m.getDataType().getPrimitiveClassType());
                UtilsMa2Test.testEquals(sdataArray, a);
                this.testGetArrayByType(as, recno, m, a);
            }
            this.testStructureData(sdata);
            ++recno;
        }
    }

    private void testGetArrayByType(ArrayStructure as, int recno, StructureMembers.Member m, Array a) {
        DataType dtype = m.getDataType();
        Object[] data = null;
        if (dtype == DataType.DOUBLE) {
            assert (a.getElementType() == Double.TYPE);
            data = as.getJavaArrayDouble(recno, m);
        } else if (dtype == DataType.FLOAT) {
            assert (a.getElementType() == Float.TYPE);
            data = as.getJavaArrayFloat(recno, m);
        } else if (dtype.getPrimitiveClassType() == Long.TYPE) {
            assert (a.getElementType() == Long.TYPE);
            data = as.getJavaArrayLong(recno, m);
        } else if (dtype.getPrimitiveClassType() == Integer.TYPE) {
            assert (a.getElementType() == Integer.TYPE);
            data = as.getJavaArrayInt(recno, m);
        } else if (dtype.getPrimitiveClassType() == Short.TYPE) {
            assert (a.getElementType() == Short.TYPE);
            data = as.getJavaArrayShort(recno, m);
        } else if (dtype.getPrimitiveClassType() == Byte.TYPE) {
            assert (a.getElementType() == Byte.TYPE);
            data = as.getJavaArrayByte(recno, m);
        } else if (dtype == DataType.CHAR) {
            assert (a.getElementType() == Character.TYPE);
            data = as.getJavaArrayChar(recno, m);
        } else if (dtype == DataType.STRING) {
            assert (a.getElementType() == String.class);
            data = as.getJavaArrayString(recno, m);
        } else if (dtype == DataType.STRUCTURE) {
            assert (a.getElementType() == StructureData.class);
            ArrayStructure nested = as.getArrayStructure(recno, m);
            this.testArrayStructure(nested);
        }
        if (data != null) {
            UtilsMa2Test.testJarrayEquals(data, a.getStorage(), m.getSize());
        }
    }

    private void testStructureData(StructureData sdata) {
        List members = sdata.getMembers();
        for (StructureMembers.Member m : members) {
            Array sdataArray = sdata.getArray(m);
            assert (sdataArray.getElementType() == m.getDataType().getPrimitiveClassType());
            Array sdataArray2 = sdata.getArray(m.getName());
            UtilsMa2Test.testEquals(sdataArray, sdataArray2);
            this.testGetArrayByType(sdata, m, sdataArray);
        }
    }

    private void testGetArrayByType(StructureData sdata, StructureMembers.Member m, Array a) {
        DataType dtype = m.getDataType();
        Object[] data = null;
        if (dtype == DataType.DOUBLE) {
            assert (a.getElementType() == Double.TYPE);
            data = sdata.getJavaArrayDouble(m);
        } else if (dtype == DataType.FLOAT) {
            assert (a.getElementType() == Float.TYPE);
            data = sdata.getJavaArrayFloat(m);
        } else if (dtype.getPrimitiveClassType() == Long.TYPE) {
            assert (a.getElementType() == Long.TYPE);
            data = sdata.getJavaArrayLong(m);
        } else if (dtype.getPrimitiveClassType() == Integer.TYPE) {
            assert (a.getElementType() == Integer.TYPE);
            data = sdata.getJavaArrayInt(m);
        } else if (dtype.getPrimitiveClassType() == Short.TYPE) {
            assert (a.getElementType() == Short.TYPE);
            data = sdata.getJavaArrayShort(m);
        } else if (dtype.getPrimitiveClassType() == Byte.TYPE) {
            assert (a.getElementType() == Byte.TYPE);
            data = sdata.getJavaArrayByte(m);
        } else if (dtype == DataType.CHAR) {
            assert (a.getElementType() == Character.TYPE);
            data = sdata.getJavaArrayChar(m);
        } else if (dtype == DataType.STRING) {
            assert (a.getElementType() == String.class);
            data = sdata.getJavaArrayString(m);
        } else if (dtype == DataType.STRUCTURE) {
            assert (a.getElementType() == StructureData.class);
            ArrayStructure nested = sdata.getArrayStructure(m);
            this.testArrayStructure(nested);
        }
        if (data != null) {
            UtilsMa2Test.testJarrayEquals(data, a.getStorage(), m.getSize());
        }
    }
}

