/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.zarr;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.filter.Filter;
import ucar.nc2.iosp.zarr.ZArray;
import ucar.nc2.iosp.zarr.ZarrFormatException;
import ucar.nc2.iosp.zarr.ZarrIosp;
import ucar.nc2.iosp.zarr.ZarrUtils;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.zarr.RandomAccessDirectory;
import ucar.unidata.io.zarr.RandomAccessDirectoryItem;

public class ZarrHeader {
    private final RandomAccessDirectory rootRaf;
    private final Group.Builder rootGroup;
    private final String rootLocation;
    private static ObjectMapper objectMapper = new ObjectMapper();

    public ZarrHeader(RandomAccessDirectory raf, Group.Builder rootGroup) {
        this.rootRaf = raf;
        this.rootGroup = rootGroup;
        this.rootLocation = ZarrUtils.trimLocation(this.rootRaf.getLocation());
    }

    public void read() throws IOException {
        List<RandomAccessDirectoryItem> items = this.rootRaf.getFilesInPath(this.rootLocation);
        DelayedVarMaker delayedVarMaker = new DelayedVarMaker();
        List<Attribute> grp_attrs = null;
        for (RandomAccessDirectoryItem item : items) {
            String filepath = ZarrUtils.trimLocation(item.getLocation());
            if (filepath.endsWith(".zattrs")) {
                List<Attribute> attrs = this.makeAttributes(item);
                if (delayedVarMaker.myAttrs(item)) {
                    delayedVarMaker.setAttrs(attrs);
                    continue;
                }
                delayedVarMaker.makeVar();
                grp_attrs = attrs;
                continue;
            }
            if (filepath.endsWith(".zgroup")) {
                delayedVarMaker.makeVar();
                this.makeGroup(item, grp_attrs);
                grp_attrs = null;
                continue;
            }
            if (filepath.endsWith(".zarray")) {
                delayedVarMaker.makeVar();
                delayedVarMaker.setVar(item);
                continue;
            }
            delayedVarMaker.processItem(item);
        }
        delayedVarMaker.makeVar();
    }

    private void makeGroup(RandomAccessDirectoryItem item, List<Attribute> attrs) {
        Group.Builder group = Group.builder();
        String location = ZarrUtils.trimLocation(item.getLocation());
        if (location.equals(this.rootLocation + '/' + ".zgroup")) {
            group = this.rootGroup;
        }
        group.setName(ZarrUtils.getObjectNameFromPath(location));
        if (attrs != null) {
            group.addAttributes(attrs);
        }
        if (group != this.rootGroup) {
            try {
                Group.Builder parentGroup = this.findGroup(location);
                group.setParentGroup(parentGroup);
                parentGroup.addGroup(group);
            }
            catch (ZarrFormatException ex) {
                ZarrIosp.logger.error(ex.getMessage());
            }
        }
    }

    private void makeVariable(RandomAccessDirectoryItem item, long dataOffset, ZArray zarray, Map<Integer, Long> initializedChunks, List<Attribute> attrs) throws ZarrFormatException {
        Variable.Builder var = Variable.builder();
        String location = ZarrUtils.trimLocation(item.getLocation());
        var.setName(ZarrUtils.getObjectNameFromPath(location));
        var.setDataType(zarray.getDataType());
        int[] shape = zarray.getShape();
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        for (int d = 0; d < shape.length; ++d) {
            Dimension.Builder dim = Dimension.builder((String)String.format("dim%d", d), (int)shape[d]);
            dim.setIsVariableLength(false);
            dim.setIsUnlimited(false);
            dim.setIsShared(false);
            dims.add(dim.build());
        }
        var.addDimensions(dims);
        int[] chunks = zarray.getChunks();
        if (shape.length != chunks.length) {
            throw new ZarrFormatException();
        }
        VInfo vinfo = new VInfo(chunks, zarray.getFillValue(), zarray.getCompressor(), zarray.getByteOrder(), zarray.getOrder(), zarray.getSeparator(), zarray.getFilters(), dataOffset, initializedChunks);
        var.setSPobject((Object)vinfo);
        if (attrs != null) {
            var.addAttributes(attrs);
        }
        Group.Builder parentGroup = this.findGroup(location);
        parentGroup.addVariable(var);
    }

    private List<Attribute> makeAttributes(RandomAccessDirectoryItem item) {
        ArrayList<Attribute> arrayList;
        block8: {
            RandomAccessFile raf = item.getOrOpenRaf();
            try {
                raf.seek(0L);
                Map attrMap = (Map)objectMapper.readValue((DataInput)raf, HashMap.class);
                ArrayList<Attribute> attrs = new ArrayList<Attribute>();
                attrMap.keySet().forEach(key -> {
                    Attribute.Builder attr = Attribute.builder((String)key);
                    Object val = attrMap.get(key);
                    if (val instanceof Collection) {
                        attr.setValues(Arrays.asList(((Collection)val).toArray()), false);
                    } else if (val instanceof Number) {
                        attr.setNumericValue((Number)val, false);
                    } else {
                        attr.setStringValue((String)val);
                    }
                    attrs.add(attr.build());
                });
                arrayList = attrs;
                if (raf == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (raf != null) {
                        try {
                            raf.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    ZarrIosp.logger.error(new ZarrFormatException().getMessage());
                    return null;
                }
            }
            raf.close();
        }
        return arrayList;
    }

    private static int getChunkIndex(RandomAccessDirectoryItem item, ZArray zarray) {
        String fileName = ZarrUtils.getDataFileName(item.getLocation());
        if (fileName.isEmpty()) {
            return -1;
        }
        int nDims = zarray.getShape().length;
        String pattern = String.format("([0-9]+%c){%d}[0-9]+", Character.valueOf(zarray.getSeparator().charAt(0)), nDims - 1);
        if (!fileName.matches(pattern)) {
            return -1;
        }
        String[] dims = fileName.split(String.format("\\%c", Character.valueOf(zarray.getSeparator().charAt(0))));
        int[] subs = Arrays.stream(dims).mapToInt(dim -> Integer.parseInt(dim)).toArray();
        int[] nChunks = new int[nDims];
        int[] shape = zarray.getShape();
        int[] chunkSize = zarray.getChunks();
        for (int i = 0; i < nDims; ++i) {
            nChunks[i] = (int)Math.ceil(shape[i] / chunkSize[i]);
        }
        return ZarrUtils.subscriptsToIndex(subs, nChunks);
    }

    private Group.Builder findGroup(String location) throws ZarrFormatException {
        String groupName = ZarrUtils.getParentGroupNameFromPath(location, this.rootLocation);
        return (Group.Builder)this.rootGroup.findGroupNested(groupName).orElseThrow(ZarrFormatException::new);
    }

    class VInfo {
        private final int[] chunks;
        private final Object fillValue;
        private final Filter compressor;
        private final ByteOrder byteOrder;
        private final ZArray.Order order;
        private final String separator;
        private final List<Filter> filters;
        private final long offset;
        private final Map<Integer, Long> initializedChunks;

        VInfo(int[] chunks, Object fillValue, Filter compressor, ByteOrder byteOrder, ZArray.Order order, String separator, List<Filter> filters, long offset, Map<Integer, Long> initializedChunks) {
            this.chunks = chunks;
            this.fillValue = fillValue;
            this.byteOrder = byteOrder;
            this.compressor = compressor;
            this.order = order;
            this.separator = separator;
            this.filters = filters;
            this.offset = offset;
            this.initializedChunks = initializedChunks;
        }

        public int[] getChunks() {
            return this.chunks;
        }

        public Object getFillValue() {
            return this.fillValue;
        }

        public Filter getCompressor() {
            return this.compressor;
        }

        public ByteOrder getByteOrder() {
            return this.byteOrder;
        }

        public ZArray.Order getOrder() {
            return this.order;
        }

        public String getSeparator() {
            return this.separator;
        }

        public List<Filter> getFilters() {
            return this.filters;
        }

        public long getOffset() {
            return this.offset;
        }

        public Map<Integer, Long> getInitializedChunks() {
            return this.initializedChunks;
        }
    }

    private class DelayedVarMaker {
        private RandomAccessDirectoryItem var;
        private ZArray zarray;
        private Map<Integer, Long> initializedChunks;
        private List<Attribute> attrs;
        private long dataOffset;

        private DelayedVarMaker() {
        }

        void setAttrs(List<Attribute> attrs) {
            this.attrs = attrs;
        }

        void setVar(RandomAccessDirectoryItem var) {
            this.var = var;
            this.attrs = null;
            this.initializedChunks = new HashMap<Integer, Long>();
            this.dataOffset = -1L;
            if (var != null) {
                try {
                    RandomAccessFile raf = var.getOrOpenRaf();
                    raf.seek(0L);
                    this.zarray = (ZArray)objectMapper.readValue((DataInput)raf, ZArray.class);
                }
                catch (IOException | ClassCastException ex) {
                    ZarrIosp.logger.error(new ZarrFormatException(ex.getMessage()).getMessage());
                    this.var = null;
                }
            }
        }

        boolean myAttrs(RandomAccessDirectoryItem attrs) {
            if (this.var == null || attrs == null) {
                return false;
            }
            String attrPath = ZarrUtils.trimLocation(attrs.getLocation());
            String varPath = ZarrUtils.trimLocation(this.var.getLocation());
            return ZarrUtils.getObjectNameFromPath(attrPath).equals(ZarrUtils.getObjectNameFromPath(varPath));
        }

        void processItem(RandomAccessDirectoryItem item) {
            if (this.var == null) {
                return;
            }
            int index = ZarrHeader.getChunkIndex(item, this.zarray);
            if (index < 0) {
                ZarrIosp.logger.error(new ZarrFormatException().getMessage());
                this.var = null;
            }
            this.initializedChunks.put(index, item.length());
            if (this.dataOffset < 0L) {
                this.dataOffset = item.startIndex();
            }
        }

        void makeVar() {
            if (this.var == null) {
                return;
            }
            try {
                ZarrHeader.this.makeVariable(this.var, this.dataOffset, this.zarray, this.initializedChunks, this.attrs);
            }
            catch (ZarrFormatException ex) {
                ZarrIosp.logger.error(ex.getMessage());
            }
            this.var = null;
        }
    }
}

