/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.zarr;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import ucar.ma2.DataType;
import ucar.nc2.filter.Filter;
import ucar.nc2.filter.Filters;
import ucar.nc2.filter.UnknownFilterException;
import ucar.nc2.iosp.zarr.ZarrFormatException;

@JsonDeserialize(using=ZArrayDeserializer.class)
public class ZArray {
    private static Map<String, DataType> dTypeMap = new HashMap<String, DataType>();
    private static final Set<String> VALID_SEPARATORS;
    public static final String DEFAULT_SEPARATOR = ".";
    private final int[] shape;
    private final int[] chunks;
    private final Object fillValue;
    private final DataType datatype;
    private final String dtype;
    private final Filter compressor;
    private final ByteOrder byteOrder;
    private final Order order;
    private final List<Filter> filters;
    private final String separator;

    public ZArray(int[] shape, int[] chunks, Object fill_value, String dtype, Filter compressor, String order, List<Filter> filters, String separator) throws ZarrFormatException {
        this.shape = shape;
        this.chunks = chunks;
        this.fillValue = fill_value;
        this.dtype = dtype;
        this.datatype = ZArray.parseDataType(this.dtype);
        this.byteOrder = ZArray.parseByteOrder(this.dtype);
        this.compressor = compressor;
        this.filters = filters;
        this.order = ZArray.parseOrder(order);
        this.separator = ZArray.validateSeparator(separator);
    }

    public int[] getShape() {
        return this.shape;
    }

    public int[] getChunks() {
        return this.chunks;
    }

    public Filter getCompressor() {
        return this.compressor;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public Object getFillValue() {
        return this.fillValue;
    }

    public Order getOrder() {
        return this.order;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getDtype() {
        return this.dtype;
    }

    public DataType getDataType() {
        return this.datatype;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    private static DataType parseDataType(String dtype) throws ZarrFormatException {
        dtype = dtype.replace(">", "");
        dtype = dtype.replace("<", "");
        DataType dataType = dTypeMap.get(dtype = dtype.replace("|", ""));
        if (dataType == null) {
            throw new ZarrFormatException("dtype", dtype);
        }
        return dataType;
    }

    private static ByteOrder parseByteOrder(String dtype) throws ZarrFormatException {
        if (dtype.startsWith(">")) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (dtype.startsWith("<")) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        if (dtype.startsWith("|")) {
            return ByteOrder.nativeOrder();
        }
        throw new ZarrFormatException("dtype", dtype);
    }

    private static Order parseOrder(String order) throws ZarrFormatException {
        try {
            return Order.valueOf(order);
        }
        catch (IllegalArgumentException ex) {
            throw new ZarrFormatException("order", order);
        }
    }

    private static String validateSeparator(String separator) throws ZarrFormatException {
        if (!VALID_SEPARATORS.contains(separator)) {
            throw new ZarrFormatException("dimension_separator", separator);
        }
        return separator;
    }

    static {
        dTypeMap.put("b1", DataType.BOOLEAN);
        dTypeMap.put("i1", DataType.BYTE);
        dTypeMap.put("S1", DataType.CHAR);
        dTypeMap.put("U1", DataType.CHAR);
        dTypeMap.put("O1", DataType.OBJECT);
        dTypeMap.put("u1", DataType.UBYTE);
        dTypeMap.put("i2", DataType.SHORT);
        dTypeMap.put("u2", DataType.USHORT);
        dTypeMap.put("i4", DataType.INT);
        dTypeMap.put("f4", DataType.FLOAT);
        dTypeMap.put("S4", DataType.STRING);
        dTypeMap.put("U4", DataType.STRING);
        dTypeMap.put("u4", DataType.UINT);
        dTypeMap.put("i8", DataType.LONG);
        dTypeMap.put("f8", DataType.DOUBLE);
        dTypeMap.put("u8", DataType.ULONG);
        VALID_SEPARATORS = Stream.of(DEFAULT_SEPARATOR, "/").collect(Collectors.toCollection(HashSet::new));
    }

    static class ZArrayDeserializer
    extends StdDeserializer<ZArray> {
        protected ZArrayDeserializer() {
            super(ZArray.class);
        }

        public ZArray deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            ObjectCodec codec = p.getCodec();
            TreeNode root = codec.readTree(p);
            int[] shape = StreamSupport.stream(((ArrayNode)root.path("shape")).spliterator(), false).mapToInt(JsonNode::asInt).toArray();
            int[] chunks = StreamSupport.stream(((ArrayNode)root.path("chunks")).spliterator(), false).mapToInt(JsonNode::asInt).toArray();
            String dtype = ((JsonNode)root.path("dtype")).asText();
            JsonNode fillValueNode = (JsonNode)root.path("fill_value");
            Object fill = fillValueNode.isLong() ? Long.valueOf(fillValueNode.longValue()) : (fillValueNode.isFloat() ? Float.valueOf(fillValueNode.floatValue()) : (fillValueNode.isNumber() ? Double.valueOf(fillValueNode.asDouble()) : fillValueNode.asText("")));
            String order = ((JsonNode)root.path("order")).asText();
            TreeNode dim_sep = root.path("dimension_separator");
            String delimiter = dim_sep.isMissingNode() ? ZArray.DEFAULT_SEPARATOR : ((JsonNode)dim_sep).asText();
            try {
                Map compBean = (Map)codec.readValue(root.path("compressor").traverse(codec), HashMap.class);
                Filter compressor = Filters.getFilterByName((Map)compBean);
                ArrayList<Filter> filters = new ArrayList<Filter>();
                Map[] filtersBean = (Map[])codec.readValue(root.path("filters").traverse(codec), HashMap[].class);
                if (filtersBean != null) {
                    for (Map bean : filtersBean) {
                        filters.add(Filters.getFilterByName((Map)bean));
                    }
                }
                return new ZArray(shape, chunks, fill, dtype, compressor, order, filters, delimiter);
            }
            catch (UnknownFilterException | ZarrFormatException ex) {
                throw new IOException(ex.getMessage(), ex.getCause());
            }
        }
    }

    public static enum Order {
        C,
        F;

    }
}

