/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.zarr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.filesystem.MFileOS;
import thredds.inventory.MFile;
import thredds.inventory.MFileProvider;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;

public class MFileZip
implements MFile {
    private static final Logger logger = LoggerFactory.getLogger(MFileZip.class);
    private final ZipFile root;
    private final Path rootPath;
    private final Path relativePath;
    private Object auxInfo;
    private final List<ZipEntry> leafEntries;
    private ZipEntry entry;

    public MFileZip(ZipFile file) throws IOException {
        if (file == null) {
            throw new IOException("Could not create MFile: ZipFile is null");
        }
        this.root = file;
        this.rootPath = Paths.get(file.getName(), new String[0]);
        this.relativePath = Paths.get(File.separator, new String[0]);
        this.leafEntries = this.getEntries();
    }

    public MFileZip(String filename) throws IOException {
        int split = filename.indexOf(".zip");
        if (split < 0) {
            throw new IOException(filename + " is not a zip file");
        }
        String location = filename.substring(0, split + ".zip".length());
        filename = filename.substring(split + ".zip".length());
        this.root = new ZipFile(location);
        this.rootPath = Paths.get(location, new String[0]);
        this.relativePath = filename.isEmpty() ? Paths.get(File.separator, new String[0]) : Paths.get(filename, new String[0]);
        this.leafEntries = this.getEntries();
    }

    private List<ZipEntry> getEntries() {
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        try {
            ZipInputStream zipIn = new ZipInputStream(new FileInputStream(this.root.getName()));
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                Path entryPath = Paths.get(File.separator + entry.getName(), new String[0]);
                if (!entryPath.startsWith(this.relativePath) || entryPath.equals(this.relativePath)) {
                    if (entryPath.equals(this.relativePath)) {
                        this.entry = entry;
                    }
                    zipIn.closeEntry();
                    entry = zipIn.getNextEntry();
                    continue;
                }
                if (!entry.isDirectory()) {
                    entries.add(entry);
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
            zipIn.close();
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage(), (Throwable)ioe);
        }
        return entries;
    }

    public long getLastModified() {
        return this.entry == null ? this.rootPath.toFile().lastModified() : this.entry.getLastModifiedTime().toMillis();
    }

    public long getLength() {
        return this.entry == null ? this.rootPath.toFile().length() : this.entry.getSize();
    }

    public boolean isDirectory() {
        return this.leafEntries.size() > 1;
    }

    public boolean isZipFile() {
        return true;
    }

    public boolean isReadable() {
        return Files.isReadable(this.rootPath);
    }

    public String getPath() {
        return this.rootPath.toString() + this.relativePath.toString();
    }

    public String getName() {
        return this.relativePath.toString();
    }

    public MFile getParent() {
        return MFileOS.getExistingFile((String)Paths.get(this.root.getName(), new String[0]).getParent().toString());
    }

    public int compareTo(MFile o) {
        return this.getPath().compareTo(o.getPath());
    }

    public Object getAuxInfo() {
        return this.auxInfo;
    }

    public void setAuxInfo(Object info) {
        this.auxInfo = info;
    }

    public boolean exists() {
        return Files.exists(Paths.get(this.root.getName(), new String[0]), new LinkOption[0]);
    }

    public InputStream getInputStream() {
        throw new UnsupportedOperationException("MFileZip::getInputStream not implemented");
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        IO.copyFile((File)this.rootPath.toFile(), (OutputStream)outputStream);
    }

    public void writeToStream(OutputStream outputStream, long offset, long maxBytes) throws IOException {
        try (RandomAccessFile randomAccessFile = RandomAccessFile.acquire((String)this.rootPath.toString());){
            IO.copyRafB((RandomAccessFile)randomAccessFile, (long)offset, (long)maxBytes, (OutputStream)outputStream);
        }
    }

    public MFileZip getChild(String newFilename) {
        throw new UnsupportedOperationException("MFileZip::getChild not implemented. Filename: " + this.getName());
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public Path getRelativePath() {
        return this.relativePath;
    }

    public List<ZipEntry> getLeafEntries() {
        return this.leafEntries;
    }

    public static class Provider
    implements MFileProvider {
        protected static final String ext = ".zip";

        public String getProtocol() {
            return null;
        }

        public boolean canProvide(String location) {
            return location != null && location.toLowerCase(Locale.ROOT).contains(ext);
        }

        @Nonnull
        public MFile create(String location) throws IOException {
            return new MFileZip(location);
        }
    }
}

