/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.zarr;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ucar.ma2.Section;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.filter.Filter;
import ucar.nc2.iosp.LayoutBB;
import ucar.nc2.iosp.LayoutBBTiled;
import ucar.nc2.iosp.zarr.ZArray;
import ucar.nc2.iosp.zarr.ZarrHeader;
import ucar.nc2.iosp.zarr.ZarrUtils;
import ucar.unidata.io.RandomAccessFile;

public class ZarrLayoutBB
implements LayoutBB {
    private LayoutBBTiled delegate;
    private RandomAccessFile raf;
    private ByteOrder byteOrder;
    private final long varOffset;
    private final Section want;
    private int[] chunkSize;
    private int elemSize;
    private int[] nChunks;
    private int totalNChunks;
    private boolean F_order = false;
    private Map<Integer, Long> initializedChunks;
    private Filter compressor;
    private List<Filter> filters;

    public ZarrLayoutBB(Variable v2, Section wantSection, RandomAccessFile raf) {
        this.raf = raf;
        ZarrHeader.VInfo vinfo = (ZarrHeader.VInfo)v2.getSPobject();
        this.byteOrder = vinfo.getByteOrder();
        this.varOffset = vinfo.getOffset();
        this.compressor = vinfo.getCompressor();
        this.filters = vinfo.getFilters();
        this.chunkSize = vinfo.getChunks();
        int ndims = this.chunkSize.length;
        this.initializedChunks = vinfo.getInitializedChunks();
        this.nChunks = new int[ndims];
        this.totalNChunks = 1;
        for (int i = 0; i < ndims; ++i) {
            Dimension dim = v2.getDimension(i);
            this.nChunks[i] = (int)Math.ceil(dim.getLength() / this.chunkSize[i]);
            this.totalNChunks *= this.nChunks[i];
        }
        if (vinfo.getOrder() == ZArray.Order.F) {
            this.F_order = true;
            List ranges = wantSection.getRanges();
            ArrayList transpose = new ArrayList();
            int[] temp = new int[ndims];
            for (int i = 0; i < ndims; ++i) {
                transpose.add(ranges.get(ndims - i - 1));
                temp[i] = this.chunkSize[ndims - i - 1];
            }
            this.want = new Section(transpose);
            this.chunkSize = temp;
        } else {
            this.want = wantSection;
        }
        this.elemSize = v2.getDataType().getSize();
        DataChunkIterator iter = new DataChunkIterator();
        this.delegate = new LayoutBBTiled((LayoutBBTiled.DataChunkIterator)iter, this.chunkSize, this.elemSize, this.want);
    }

    public long getTotalNelems() {
        return this.delegate.getTotalNelems();
    }

    public int getElemSize() {
        return this.delegate.getElemSize();
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public LayoutBB.Chunk next() {
        return this.delegate.next();
    }

    private class DataChunk
    implements LayoutBBTiled.DataChunk {
        private int[] offset;
        private long rafOffset;
        private int chunkNum;

        DataChunk(int[] index, int chunkNum, long rafOffset) {
            this.rafOffset = rafOffset;
            this.offset = new int[index.length];
            for (int i = 0; i < index.length; ++i) {
                int j = ZarrLayoutBB.this.F_order ? index.length - i - 1 : i;
                this.offset[i] = index[j] * ZarrLayoutBB.this.chunkSize[i];
            }
            this.chunkNum = chunkNum;
        }

        public int[] getOffset() {
            return this.offset;
        }

        public ByteBuffer getByteBuffer() throws IOException {
            long dataLength = ZarrLayoutBB.this.initializedChunks.getOrDefault(this.chunkNum, 0L);
            if (dataLength == 0L) {
                ByteBuffer result = ByteBuffer.wrap(new byte[0]);
                result.order(ZarrLayoutBB.this.byteOrder);
                return result;
            }
            byte[] data = new byte[(int)dataLength];
            ZarrLayoutBB.this.raf.seek(this.rafOffset);
            ZarrLayoutBB.this.raf.readFully(data);
            data = ZarrLayoutBB.this.compressor.decode(data);
            for (int i = ZarrLayoutBB.this.filters.size() - 1; i >= 0; --i) {
                data = ((Filter)ZarrLayoutBB.this.filters.get(i)).decode(data);
            }
            ByteBuffer result = ByteBuffer.wrap(data);
            result.order(ZarrLayoutBB.this.byteOrder);
            return result;
        }
    }

    private class DataChunkIterator
    implements LayoutBBTiled.DataChunkIterator {
        private int[] currChunk;
        private int chunkNum;
        private long currOffset;

        DataChunkIterator() {
            this.currChunk = new int[ZarrLayoutBB.this.chunkSize.length];
            this.chunkNum = 0;
            this.currOffset = ZarrLayoutBB.this.varOffset;
        }

        public boolean hasNext() {
            return this.chunkNum < ZarrLayoutBB.this.totalNChunks;
        }

        public LayoutBBTiled.DataChunk next() {
            DataChunk chunk = new DataChunk(this.currChunk, this.chunkNum, this.currOffset);
            this.incrementChunk();
            return chunk;
        }

        private void incrementChunk() {
            int i;
            for (i = this.currChunk.length - 1; this.currChunk[i] + 1 >= ZarrLayoutBB.this.nChunks[i] && i > 0; --i) {
                this.currChunk[i] = 0;
            }
            int n = i;
            this.currChunk[n] = this.currChunk[n] + 1;
            this.currOffset += ZarrLayoutBB.this.initializedChunks.getOrDefault(this.chunkNum, 0L).longValue();
            this.chunkNum = ZarrUtils.subscriptsToIndex(this.currChunk, ZarrLayoutBB.this.nChunks);
        }
    }
}

