/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter2;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.write.Nc4ChunkingStrategyGrib;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.Parameter;

public class CFGridWriter {
    private static final Logger log = LoggerFactory.getLogger(CFGridWriter.class);

    public static void makeFile(String location, ucar.nc2.dt.GridDataset gds, List<String> gridList, LatLonRect llbb, CalendarDateRange range) throws IOException, InvalidRangeException {
        CFGridWriter writer = new CFGridWriter();
        writer.makeFile(location, gds, gridList, llbb, range, false, 1, 1, 1);
    }

    public static void makeFileVersioned(String location, ucar.nc2.dt.GridDataset gds, List<String> gridList, LatLonRect llbb, CalendarDateRange dateRange, NetcdfFileWriter.Version version) throws IOException, InvalidRangeException {
        CFGridWriter writer = new CFGridWriter();
        writer.makeOrTestSize(location, gds, gridList, llbb, 1, null, dateRange, 1, false, false, version);
    }

    public long makeGridFileSizeEstimate(ucar.nc2.dt.GridDataset gds, List<String> gridList, LatLonRect llbb, int horizStride, Range zRange, CalendarDateRange dateRange, int stride_time, boolean addLatLon) throws IOException, InvalidRangeException {
        return this.makeOrTestSize(null, gds, gridList, llbb, horizStride, zRange, dateRange, stride_time, addLatLon, true, NetcdfFileWriter.Version.netcdf3);
    }

    public long makeGridFileSizeEstimate(ucar.nc2.dt.GridDataset gds, List<String> gridList, ProjectionRect projBB, int horizStride, Range zRange, CalendarDateRange dateRange, int stride_time, boolean addLatLon) throws IOException, InvalidRangeException {
        return this.makeOrTestSize(null, gds, gridList, projBB, horizStride, zRange, dateRange, stride_time, addLatLon, true, NetcdfFileWriter.Version.netcdf3);
    }

    public void makeFile(String location, ucar.nc2.dt.GridDataset gds, List<String> gridList, LatLonRect llbb, CalendarDateRange range, boolean addLatLon, int horizStride, int stride_z, int stride_time) throws IOException, InvalidRangeException {
        this.makeFile(location, gds, gridList, llbb, horizStride, null, range, stride_time, addLatLon, NetcdfFileWriter.Version.netcdf3);
    }

    public long makeFile(String location, ucar.nc2.dt.GridDataset gds, List<String> gridList, LatLonRect llbb, int horizStride, Range zRange, CalendarDateRange dateRange, int stride_time, boolean addLatLon) throws IOException, InvalidRangeException {
        return this.makeOrTestSize(location, gds, gridList, llbb, horizStride, zRange, dateRange, stride_time, addLatLon, false, NetcdfFileWriter.Version.netcdf3);
    }

    public long makeFile(String location, ucar.nc2.dt.GridDataset gds, List<String> gridList, LatLonRect llbb, int horizStride, Range zRange, CalendarDateRange dateRange, int stride_time, boolean addLatLon, NetcdfFileWriter.Version version) throws IOException, InvalidRangeException {
        return this.makeOrTestSize(location, gds, gridList, llbb, horizStride, zRange, dateRange, stride_time, addLatLon, false, version);
    }

    public long makeFile(String location, ucar.nc2.dt.GridDataset gds, List<String> gridList, ProjectionRect llbb, int horizStride, Range zRange, CalendarDateRange dateRange, int stride_time, boolean addLatLon) throws IOException, InvalidRangeException {
        return this.makeOrTestSize(location, gds, gridList, llbb, horizStride, zRange, dateRange, stride_time, addLatLon, false, NetcdfFileWriter.Version.netcdf3);
    }

    public long makeFile(String location, ucar.nc2.dt.GridDataset gds, List<String> gridList, ProjectionRect llbb, int horizStride, Range zRange, CalendarDateRange dateRange, int stride_time, boolean addLatLon, NetcdfFileWriter.Version version) throws IOException, InvalidRangeException {
        return this.makeOrTestSize(location, gds, gridList, llbb, horizStride, zRange, dateRange, stride_time, addLatLon, false, version);
    }

    private long makeOrTestSize(String location, ucar.nc2.dt.GridDataset gds, List<String> gridList, LatLonRect llbb, int horizStride, Range zRange, CalendarDateRange dateRange, int stride_time, boolean addLatLon, boolean testSizeOnly, NetcdfFileWriter.Version version) throws IOException, InvalidRangeException {
        NetcdfDataset ncd = (NetcdfDataset)gds.getNetcdfFile();
        LatLonRect llrect = new LatLonRect();
        ArrayList<Variable> varList = new ArrayList<Variable>();
        ArrayList<String> varNameList = new ArrayList<String>();
        ArrayList<CoordinateAxis> axisList = new ArrayList<CoordinateAxis>();
        long total_size = 0L;
        for (String gridName : gridList) {
            ProjectionImpl proj;
            if (varNameList.contains(gridName)) continue;
            varNameList.add(gridName);
            GridDatatype grid = gds.findGridDatatype(gridName);
            GridCoordSystem gcsOrg = grid.getCoordinateSystem();
            CoordinateAxis1DTime timeAxis = gcsOrg.getTimeAxis1D();
            CoordinateAxis1D vertAxis = gcsOrg.getVerticalAxis();
            boolean global = gcsOrg.isGlobalLon();
            Range timeRange = this.makeTimeRange(dateRange, timeAxis, stride_time);
            Range zRangeUse = this.makeVerticalRange(zRange, vertAxis);
            if (null != timeRange || zRangeUse != null || llbb != null || horizStride > 1) {
                grid = grid.makeSubset(timeRange, zRangeUse, llbb, 1, horizStride, horizStride);
            }
            VariableDS gridV = grid.getVariable();
            varList.add(gridV);
            total_size += gridV.getSize() * (long)gridV.getElementSize();
            GridCoordSystem gcs = grid.getCoordinateSystem();
            llrect = gcs.getLatLonBoundingBox();
            this.addCoordinateAxis(gcs, varNameList, varList, axisList);
            this.addCoordinateTransform(gcs, ncd, varNameList, varList);
            total_size += this.processTransformationVars(varList, varNameList, ncd, gds, grid, timeRange, zRangeUse, llbb, 1, horizStride, horizStride, axisList);
            if (!addLatLon || null == (proj = gcs.getProjection()) || proj instanceof LatLonProjection) continue;
            this.addLatLon2D(ncd, varList, proj, gcs.getXHorizAxis(), gcs.getYHorizAxis());
            addLatLon = false;
        }
        if (testSizeOnly) {
            return total_size;
        }
        boolean isLargeFile = this.isLargeFile(total_size);
        Nc4ChunkingStrategyGrib chunking = null;
        if (version == NetcdfFileWriter.Version.netcdf4) {
            chunking = new Nc4ChunkingStrategyGrib(5, true);
        }
        NetcdfFileWriter writer = NetcdfFileWriter.createNew(version, location, chunking);
        this.writeGlobalAttributes(writer, gds);
        FileWriter2 fileWriter = new FileWriter2(writer);
        for (Variable v : varList) {
            fileWriter.addVariable(v);
        }
        this.addCFAnnotations(writer, gds, gridList, ncd, axisList, addLatLon);
        writer.create();
        fileWriter.copyVarData(varList, null, null);
        this.updateGeospatialRanges(writer, llrect);
        writer.close();
        return 0L;
    }

    private long makeOrTestSize(String location, ucar.nc2.dt.GridDataset gds, List<String> gridList, ProjectionRect llbb, int horizStride, Range zRange, CalendarDateRange dateRange, int stride_time, boolean addLatLon, boolean testSizeOnly, NetcdfFileWriter.Version version) throws IOException, InvalidRangeException {
        NetcdfDataset ncd = (NetcdfDataset)gds.getNetcdfFile();
        ArrayList<Variable> varList = new ArrayList<Variable>();
        ArrayList<String> varNameList = new ArrayList<String>();
        ArrayList<CoordinateAxis> axisList = new ArrayList<CoordinateAxis>();
        LatLonRect llrec = new LatLonRect();
        long total_size = 0L;
        for (String gridName : gridList) {
            ProjectionImpl proj;
            CoordinateAxis1D yAxis;
            double[] yCoords;
            if (varNameList.contains(gridName)) continue;
            varNameList.add(gridName);
            GeoGrid grid = (GeoGrid)gds.findGridDatatype(gridName);
            GridCoordSystem gcsOrg = grid.getCoordinateSystem();
            CoordinateAxis1DTime timeAxis = gcsOrg.getTimeAxis1D();
            CoordinateAxis1D vertAxis = gcsOrg.getVerticalAxis();
            Range timeRange = this.makeTimeRange(dateRange, timeAxis, stride_time);
            if (gcsOrg.getXHorizAxis().getRank() > 1 || gcsOrg.getYHorizAxis().getRank() > 1) {
                throw new IllegalArgumentException("Coordinate systems with 2D horizontal axis are not supported");
            }
            CoordinateAxis1D xAxis = (CoordinateAxis1D)gcsOrg.getXHorizAxis();
            double[] xCoords = xAxis.getCoordValues();
            ProjectionRect fullBB = new ProjectionRect(xCoords[0], (yCoords = (yAxis = (CoordinateAxis1D)gcsOrg.getYHorizAxis()).getCoordValues())[0], xCoords[xCoords.length - 1], yCoords[yCoords.length - 1]);
            if (!llbb.intersects(fullBB)) {
                throw new InvalidRangeException("BBOX must intersect grid BBOX, minx=" + xCoords[0] + ", miny=" + yCoords[0] + ", maxx=" + xCoords[xCoords.length - 1] + ", maxy=" + yCoords[yCoords.length - 1]);
            }
            ProjectionRect.intersect(fullBB, llbb, llbb);
            ProjectionPoint lowerLeft = llbb.getLowerLeftPoint();
            ProjectionPoint upperRigth = llbb.getUpperRightPoint();
            double minx = lowerLeft.getX();
            double miny = lowerLeft.getY();
            double maxx = upperRigth.getX();
            double maxy = upperRigth.getY();
            int minyCoord = yAxis.findCoordElement(miny);
            int maxyCoord = yAxis.findCoordElement(maxy);
            int minxCoord = xAxis.findCoordElement(minx);
            int maxxCoord = xAxis.findCoordElement(maxx);
            Range y_range = new Range(minyCoord, maxyCoord, horizStride);
            Range x_range = new Range(minxCoord, maxxCoord, horizStride);
            Range zRangeUse = this.makeVerticalRange(zRange, vertAxis);
            if (null != timeRange || zRangeUse != null || llbb != null || horizStride > 1) {
                grid = grid.subset(timeRange, zRangeUse, y_range, x_range);
            }
            VariableDS gridV = grid.getVariable();
            varList.add(gridV);
            total_size += gridV.getSize() * (long)gridV.getElementSize();
            GridCoordSystem gcs = grid.getCoordinateSystem();
            llrec = gcs.getLatLonBoundingBox();
            this.addCoordinateAxis(gcs, varNameList, varList, axisList);
            this.addCoordinateTransform(gcs, ncd, varNameList, varList);
            total_size += this.processTransformationVars(varList, varNameList, ncd, gds, (GridDatatype)grid, timeRange, zRangeUse, y_range, x_range, 1, horizStride, horizStride);
            if (!addLatLon || null == (proj = gcs.getProjection()) || proj instanceof LatLonProjection) continue;
            this.addLatLon2D(ncd, varList, proj, gcs.getXHorizAxis(), gcs.getYHorizAxis());
            addLatLon = false;
        }
        if (testSizeOnly) {
            return total_size;
        }
        boolean isLargeFile = this.isLargeFile(total_size);
        Nc4ChunkingStrategyGrib chunking = null;
        if (version == NetcdfFileWriter.Version.netcdf4) {
            chunking = new Nc4ChunkingStrategyGrib(5, true);
        }
        NetcdfFileWriter writer = NetcdfFileWriter.createNew(version, location, chunking);
        writer.setLargeFile(isLargeFile);
        this.writeGlobalAttributes(writer, gds);
        FileWriter2 fileWriter = new FileWriter2(writer);
        for (Variable v : varList) {
            fileWriter.addVariable(v);
        }
        this.addCFAnnotations(writer, gds, gridList, ncd, axisList, addLatLon);
        writer.create();
        fileWriter.copyVarData(varList, null, null);
        writer.close();
        return 0L;
    }

    private void updateGeospatialRanges(NetcdfFileWriter writer, LatLonRect llRect) throws IOException {
        Attribute from;
        writer.flush();
        if (writer.findGlobalAttribute("geospatial_lat_min") != null) {
            from = writer.findGlobalAttribute("geospatial_lat_min");
            this.updateAttribute(writer, from, "geospatial_lat_min", llRect.getLatMin());
        }
        if (writer.findGlobalAttribute("geospatial_lat_max") != null) {
            from = writer.findGlobalAttribute("@geospatial_lat_max");
            this.updateAttribute(writer, from, "geospatial_lat_max", llRect.getLatMax());
        }
        if (writer.findGlobalAttribute("geospatial_lon_min") != null) {
            from = writer.findGlobalAttribute("@geospatial_lon_min");
            this.updateAttribute(writer, from, "geospatial_lon_min", llRect.getLonMin());
        }
        if (writer.findGlobalAttribute("geospatial_lon_max") != null) {
            from = writer.findGlobalAttribute("geospatial_lon_max");
            this.updateAttribute(writer, from, "geospatial_lon_max", llRect.getLonMax());
        }
    }

    private void updateAttribute(NetcdfFileWriter writer, Attribute from, String attName, double value) throws IOException {
        if (from.getDataType() == DataType.FLOAT) {
            writer.updateAttribute(null, new Attribute(attName, Float.valueOf((float)value)));
        } else {
            writer.updateAttribute(null, new Attribute(attName, value));
        }
    }

    private void convertProjectionCTV(NetcdfDataset ds, Variable ctv) {
        Attribute att = ctv.findAttribute("_CoordinateTransformType");
        if (null != att && att.getStringValue().equals("Projection")) {
            double scalef;
            Attribute east = ctv.findAttribute("false_easting");
            Attribute north = ctv.findAttribute("false_northing");
            if ((null != east || null != north) && (scalef = AbstractCoordTransBuilder.getFalseEastingScaleFactor(ds, ctv)) != 1.0) {
                this.convertAttribute(ctv, east, scalef);
                this.convertAttribute(ctv, north, scalef);
            }
        }
    }

    private void convertAttribute(Variable ctv, Attribute att, double scalef) {
        if (att == null) {
            return;
        }
        double val = scalef * att.getNumericValue().doubleValue();
        ctv.addAttribute(new Attribute(att.getShortName(), val));
    }

    private void addLatLon2D(NetcdfFile ncfile, List<Variable> varList, Projection proj, CoordinateAxis xaxis, CoordinateAxis yaxis) throws IOException {
        double[] xData = (double[])xaxis.read().get1DJavaArray(Double.TYPE);
        double[] yData = (double[])yaxis.read().get1DJavaArray(Double.TYPE);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        dims.add(yaxis.getDimension(0));
        dims.add(xaxis.getDimension(0));
        Variable latVar = new Variable(ncfile, null, null, "lat");
        latVar.setDataType(DataType.DOUBLE);
        latVar.setDimensions(dims);
        latVar.addAttribute(new Attribute("units", "degrees_north"));
        latVar.addAttribute(new Attribute("long_name", "latitude coordinate"));
        latVar.addAttribute(new Attribute("standard_name", "latitude"));
        latVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        Variable lonVar = new Variable(ncfile, null, null, "lon");
        lonVar.setDataType(DataType.DOUBLE);
        lonVar.setDimensions(dims);
        lonVar.addAttribute(new Attribute("units", "degrees_east"));
        lonVar.addAttribute(new Attribute("long_name", "longitude coordinate"));
        lonVar.addAttribute(new Attribute("standard_name", "longitude"));
        lonVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        int nx = xData.length;
        int ny = yData.length;
        ProjectionPointImpl projPoint = new ProjectionPointImpl();
        LatLonPointImpl latlonPoint = new LatLonPointImpl();
        double[] latData = new double[nx * ny];
        double[] lonData = new double[nx * ny];
        for (int i = 0; i < ny; ++i) {
            for (int j = 0; j < nx; ++j) {
                projPoint.setLocation(xData[j], yData[i]);
                proj.projToLatLon(projPoint, latlonPoint);
                latData[i * nx + j] = latlonPoint.getLatitude();
                lonData[i * nx + j] = latlonPoint.getLongitude();
            }
        }
        Array latDataArray = Array.factory(DataType.DOUBLE, new int[]{ny, nx}, (Object)latData);
        latVar.setCachedData(latDataArray, false);
        Array lonDataArray = Array.factory(DataType.DOUBLE, new int[]{ny, nx}, (Object)lonData);
        lonVar.setCachedData(lonDataArray, false);
        varList.add(latVar);
        varList.add(lonVar);
    }

    private Range makeVerticalRange(Range zRange, CoordinateAxis1D vertAxis) throws InvalidRangeException {
        return zRange != null && vertAxis != null && vertAxis.getSize() > 1L ? zRange : null;
    }

    private Range makeTimeRange(CalendarDateRange dateRange, CoordinateAxis1DTime timeAxis, int stride_time) throws InvalidRangeException {
        Range timeRange = null;
        if (dateRange != null && timeAxis != null) {
            int startIndex = timeAxis.findTimeIndexFromCalendarDate(dateRange.getStart());
            int endIndex = timeAxis.findTimeIndexFromCalendarDate(dateRange.getEnd());
            if (startIndex < 0) {
                throw new InvalidRangeException("start time=" + dateRange.getStart() + " must be >= " + timeAxis.getCalendarDate(0));
            }
            if (endIndex < 0) {
                throw new InvalidRangeException("end time=" + dateRange.getEnd() + " must be >= " + timeAxis.getCalendarDate(0));
            }
            if (stride_time <= 1) {
                stride_time = 1;
            }
            timeRange = new Range(startIndex, endIndex, stride_time);
        }
        return timeRange;
    }

    private void addCoordinateAxis(GridCoordSystem gcs, List<String> varNameList, List<Variable> varList, List<CoordinateAxis> axisList) {
        for (CoordinateAxis axis : gcs.getCoordinateAxes()) {
            if (varNameList.contains(axis.getFullName())) continue;
            varNameList.add(axis.getFullName());
            varList.add(axis);
            axisList.add(axis);
        }
    }

    private void addCoordinateTransform(GridCoordSystem gcs, NetcdfFile ncd, List<String> varNameList, List<Variable> varList) {
        for (CoordinateTransform ct : gcs.getCoordinateTransforms()) {
            Variable v = ncd.findVariable(ct.getName());
            if (varNameList.contains(ct.getName()) || null == v) continue;
            varNameList.add(ct.getName());
            varList.add(v);
        }
    }

    private long processTransformationVars(ArrayList<Variable> varList, ArrayList<String> varNameList, NetcdfDataset ncd, ucar.nc2.dt.GridDataset gds, GridDatatype grid, Range timeRange, Range zRangeUse, LatLonRect llbb, int z_stride, int y_stride, int x_stride, List<CoordinateAxis> axisList) throws InvalidRangeException {
        List<Object> yxRanges = new ArrayList<Object>(2);
        if (llbb == null) {
            yxRanges.add(null);
            yxRanges.add(null);
        } else {
            yxRanges = grid.getCoordinateSystem().getRangesFromLatLonRect(llbb);
        }
        return this.processTransformationVars(varList, varNameList, ncd, gds, grid, timeRange, zRangeUse, (Range)yxRanges.get(0), (Range)yxRanges.get(1), z_stride, y_stride, x_stride);
    }

    private long processTransformationVars(ArrayList<Variable> varList, ArrayList<String> varNameList, NetcdfDataset ncd, ucar.nc2.dt.GridDataset gds, GridDatatype grid, Range timeRange, Range zRangeUse, Range yRange, Range xRange, int z_stride, int y_stride, int x_stride) throws InvalidRangeException {
        long varsSize = 0L;
        List<CoordinateTransform> cctt = grid.getCoordinateSystem().getCoordinateTransforms();
        for (CoordinateTransform ct : cctt) {
            Parameter param = ct.findParameterIgnoreCase("formula_terms");
            if (param == null) continue;
            String[] varStrings = param.getStringValue().split(" ");
            for (int i = 1; i < varStrings.length; i += 2) {
                Variable paramVar = ncd.findVariable(varStrings[i].trim());
                if (varNameList.contains(varStrings[i]) || null == paramVar) continue;
                if (gds.findGridDatatype(paramVar.getFullName()) != null) {
                    if (null != timeRange || zRangeUse != null || x_stride > 1 && y_stride > 1 || yRange != null || xRange != null) {
                        GridDatatype complementaryGrid = gds.findGridDatatype(paramVar.getFullName());
                        complementaryGrid = complementaryGrid.makeSubset(null, null, timeRange, zRangeUse, yRange, xRange);
                        paramVar = complementaryGrid.getVariable();
                    }
                } else if (zRangeUse != null && paramVar.getRank() == 1) {
                    ArrayList<Range> ranges = new ArrayList<Range>();
                    ranges.add(zRangeUse);
                    paramVar = paramVar.section(ranges);
                }
                varNameList.add(paramVar.getFullName());
                varsSize += paramVar.getSize() * (long)paramVar.getElementSize();
                varList.add(paramVar);
            }
        }
        return varsSize;
    }

    private boolean isLargeFile(long total_size) {
        boolean isLargeFile = false;
        long maxSize = 2000000000L;
        if (total_size > maxSize) {
            log.info("Request size = {} Mbytes", (Object)(total_size / 1000L / 1000L));
            isLargeFile = true;
        }
        return isLargeFile;
    }

    private void writeGlobalAttributes(NetcdfFileWriter writer, ucar.nc2.dt.GridDataset gds) {
        for (Attribute att : gds.getGlobalAttributes()) {
            if (att.getShortName().equals("file_format") || att.getShortName().equals("_CoordSysBuilder")) continue;
            writer.addGroupAttribute(null, att);
        }
        Attribute att = gds.findGlobalAttributeIgnoreCase("Conventions");
        if (att == null || !att.getStringValue().startsWith("CF-")) {
            writer.addGroupAttribute(null, new Attribute("Conventions", "CF-1.0"));
        }
        writer.addGroupAttribute(null, new Attribute("History", "Translated to CF-1.0 Conventions by Netcdf-Java CDM (CFGridWriter)\nOriginal Dataset = " + gds.getLocationURI() + "; Translation Date = " + CalendarDate.present()));
    }

    private void addCFAnnotations(NetcdfFileWriter writer, ucar.nc2.dt.GridDataset gds, List<String> gridList, NetcdfDataset ncd, List<CoordinateAxis> axisList, boolean addLatLon) {
        for (String gridName : gridList) {
            GridDatatype grid = gds.findGridDatatype(gridName);
            Variable newV = writer.findVariable(gridName);
            if (newV == null) {
                log.warn("NetcdfCFWriter cant find " + gridName + " in gds " + gds.getLocationURI());
                continue;
            }
            StringBuilder sbuff = new StringBuilder();
            GridCoordSystem gcs = grid.getCoordinateSystem();
            for (Variable variable : gcs.getCoordinateAxes()) {
                sbuff.append(variable.getFullName()).append(" ");
            }
            if (addLatLon) {
                sbuff.append("lat lon");
            }
            newV.addAttribute(new Attribute("coordinates", sbuff.toString()));
            for (CoordinateTransform coordinateTransform : gcs.getCoordinateTransforms()) {
                Variable v = ncd.findVariable(coordinateTransform.getName());
                if (coordinateTransform.getTransformType() != TransformType.Projection) continue;
                newV.addAttribute(new Attribute("grid_mapping", v.getFullName()));
            }
        }
        for (CoordinateAxis axis : axisList) {
            Variable newV = writer.findVariable(axis.getFullNameEscaped());
            if ((axis.getAxisType() == AxisType.Height || axis.getAxisType() == AxisType.Pressure || axis.getAxisType() == AxisType.GeoZ) && null != axis.getPositive()) {
                newV.addAttribute(new Attribute("positive", axis.getPositive()));
            }
            if (axis.getAxisType() == AxisType.Lat) {
                newV.addAttribute(new Attribute("units", "degrees_north"));
                newV.addAttribute(new Attribute("standard_name", "latitude"));
            }
            if (axis.getAxisType() == AxisType.Lon) {
                newV.addAttribute(new Attribute("units", "degrees_east"));
                newV.addAttribute(new Attribute("standard_name", "longitude"));
            }
            if (axis.getAxisType() == AxisType.GeoX) {
                newV.addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
            }
            if (axis.getAxisType() != AxisType.GeoY) continue;
            newV.addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
        }
        ArrayList<Variable> ctvList = new ArrayList<Variable>();
        for (GridDataset.Gridset gridSet : gds.getGridsets()) {
            Variable v;
            GridCoordSystem gcs = gridSet.getGeoCoordSystem();
            ProjectionCT pct = gcs.getProjectionCT();
            if (pct == null || (v = writer.findVariable(pct.getName())) == null || ctvList.contains(v)) continue;
            this.convertProjectionCTV((NetcdfDataset)gds.getNetcdfFile(), v);
            ctvList.add(v);
        }
    }

    public static void test1() throws IOException, InvalidRangeException, ParseException {
        String fileIn = "C:/data/ncmodels/NAM_CONUS_80km_20051206_0000.nc";
        String fileOut = "C:/temp/cf3.nc";
        GridDataset gds = GridDataset.open(fileIn);
        CFGridWriter writer = new CFGridWriter();
        ArrayList<String> gridList = new ArrayList<String>();
        gridList.add("RH");
        gridList.add("T");
        DateFormatter format = new DateFormatter();
        Date start = format.getISODate("2005-12-06T18:00:00Z");
        Date end = format.getISODate("2005-12-07T18:00:00Z");
        writer.makeFile(fileOut, (ucar.nc2.dt.GridDataset)gds, gridList, new LatLonRect(new LatLonPointImpl(37.0, -109.0), 400.0, 7.0), CalendarDateRange.of(start, end), true, 1, 1, 1);
    }

    public static void main(String[] args) throws IOException, InvalidRangeException, ParseException {
        String fileIn = "dods://thredds.ucar.edu/repository/entry/show/output:data.opendap/entryid:c41a3a26-57e5-4b15-b8b1-a8762b6f02c7/dodsC/entry";
        String fileOut = "C:/temp/testCF.nc";
        GridDataset gds = GridDataset.open(fileIn);
        CFGridWriter writer = new CFGridWriter();
        ArrayList<String> gridList = new ArrayList<String>();
        gridList.add("Z_sfc");
        DateFormatter format = new DateFormatter();
        Date start = format.getISODate("2003-06-01T03:00:00Z");
        Date end = format.getISODate("2004-01-01T00:00:00Z");
        writer.makeFile(fileOut, (ucar.nc2.dt.GridDataset)gds, gridList, null, CalendarDateRange.of(start, end), true, 1, 1, 1);
    }
}

