/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.NetcdfFile;
import ucar.unidata.test.Diff;

public class UnitTestCommon
extends TestCase {
    public static boolean debug = false;
    public static Logger log = LoggerFactory.getLogger(NetcdfFile.class);
    static final String[] SUBROOTS = new String[]{"cdm", "tds", "opendap"};
    public static final String threddsRoot = UnitTestCommon.locateThreddsRoot();
    String title = "Testing";
    String name = "testcommon";

    static String locateThreddsRoot() {
        String path = System.getProperty("user.dir");
        path = path.replace('\\', '/');
        assert (path != null);
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path != null) {
            boolean allfound = true;
            for (String dirname : SUBROOTS) {
                String s = path + "/" + dirname;
                File tmp = new File(s);
                if (tmp.exists()) continue;
                allfound = false;
                break;
            }
            if (allfound) {
                return path;
            }
            int index = path.lastIndexOf(47);
            path = path.substring(0, index);
        }
        return null;
    }

    public void clearDir(File dir, boolean clearsubdirs) throws Exception {
        if (!dir.exists()) {
            return;
        }
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                if (clearsubdirs) {
                    this.clearDir(f, true);
                } else {
                    throw new Exception("InnerClass directory encountered: " + f.getAbsolutePath());
                }
            }
            f.delete();
        }
    }

    public UnitTestCommon() {
        this("UnitTest");
    }

    public UnitTestCommon(String name) {
        super(name);
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String compare(String tag, String baseline, String s) {
        try {
            Diff diff = new Diff(tag);
            StringWriter sw = new StringWriter();
            boolean pass = !diff.doDiff(baseline, s, (Writer)sw);
            return pass ? null : sw.toString();
        }
        catch (Exception e) {
            System.err.println("UnitTest: Diff failure: " + e);
            return null;
        }
    }

    public void testFakerooni() {
    }
}

