/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.test.Diff;

public class UnitTestCommon
extends TestCase {
    public static boolean debug = false;
    public static Logger log = LoggerFactory.getLogger(UnitTestCommon.class);
    static final String[] SUBROOTS = new String[]{"cdm", "tds", "opendap"};
    public static final String threddsRoot = UnitTestCommon.locateThreddsRoot();
    String title = "Testing";
    String name = "testcommon";

    static String locateThreddsRoot() {
        String path = System.getProperty("user.dir");
        path = path.replace('\\', '/');
        assert (path != null);
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path != null) {
            boolean allfound = true;
            for (String dirname : SUBROOTS) {
                String s = path + "/" + dirname;
                File tmp = new File(s);
                if (tmp.exists()) continue;
                allfound = false;
                break;
            }
            if (allfound) {
                return path;
            }
            int index = path.lastIndexOf(47);
            path = path.substring(0, index);
        }
        return null;
    }

    public void clearDir(File dir, boolean clearsubdirs) throws Exception {
        if (!dir.exists()) {
            return;
        }
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                if (clearsubdirs) {
                    this.clearDir(f, true);
                } else {
                    throw new Exception("InnerClass directory encountered: " + f.getAbsolutePath());
                }
            }
            f.delete();
        }
    }

    public UnitTestCommon() {
        this("UnitTest");
    }

    public UnitTestCommon(String name) {
        super(name);
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String compare(String tag, String baseline, String s) {
        try {
            Diff diff = new Diff(tag);
            StringWriter sw = new StringWriter();
            boolean pass = !diff.doDiff(baseline, s, (Writer)sw);
            return pass ? null : sw.toString();
        }
        catch (Exception e) {
            System.err.println("UnitTest: Diff failure: " + e);
            return null;
        }
    }

    public void testFakerooni() {
    }

    public static byte[] readbinaryfile(InputStream stream) throws IOException {
        int cnt;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] tmp = new byte[65536];
        while ((cnt = stream.read(tmp)) > 0) {
            bytes.write(tmp, 0, cnt);
        }
        return bytes.toByteArray();
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http", "debug");
    }

    public static class InterceptResponse
    implements HttpResponseInterceptor {
        HttpResponse response = null;
        HttpContext context = null;

        public synchronized void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            this.response = response;
            this.context = context;
        }

        public synchronized HttpResponse getResponse() {
            return this.response;
        }

        public synchronized HttpContext getContext() {
            return this.context;
        }

        public synchronized Header[] getHeaders(String key) {
            Header[] hdrs = null;
            if (this.response != null) {
                hdrs = this.response.getHeaders(key);
            }
            if (hdrs == null) {
                hdrs = new Header[]{};
            }
            return hdrs;
        }
    }

    public static class InterceptRequest
    implements HttpRequestInterceptor {
        HttpRequest request = null;
        HttpContext context = null;

        public synchronized void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            this.request = request;
            this.context = context;
        }

        public synchronized HttpRequest getRequest() {
            return this.request;
        }

        public synchronized HttpContext getContext() {
            return this.context;
        }

        public synchronized Header[] getHeaders(String key) {
            Header[] hdrs = null;
            if (this.request != null) {
                hdrs = this.request.getHeaders(key);
            }
            if (hdrs == null) {
                hdrs = new Header[]{};
            }
            return hdrs;
        }
    }
}

