/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.junit.Test;
import ucar.nc2.TestLocal;
import ucar.nc2.util.UnitTestCommon;
import ucar.nc2.util.net.HTTPAuthScope;
import ucar.nc2.util.net.HTTPAuthStore;
import ucar.nc2.util.net.HTTPCredentialsCache;
import ucar.nc2.util.net.HTTPFactory;
import ucar.nc2.util.net.HTTPMethod;
import ucar.nc2.util.net.HTTPSSLProvider;
import ucar.nc2.util.net.HTTPSession;

public class TestAuth
extends UnitTestCommon {
    static final String BADPASSWORD = "bad";
    static boolean remote = false;
    static final String KEYDIR = "/cdm/src/test/resources";
    static final String CLIENTKEY = "clientkey.jks";
    static final String CLIENTPWD = "changeit";
    static final boolean MUSTFAIL = true;
    static final boolean MUSTPASS = false;
    int passcount = 0;
    int xfailcount = 0;
    int failcount = 0;
    boolean verbose = true;
    boolean pass = false;
    String datadir = null;
    String threddsroot = null;
    static AuthDataBasic[] basictests;

    public TestAuth(String name, String testdir) {
        super(name);
        this.setTitle("DAP Authorization tests");
    }

    public TestAuth(String name) {
        this(name, null);
    }

    public TestAuth() {
        this("TestAuth", null);
    }

    @Test
    public void testSSH() throws Exception {
        String[] sshurls = new String[]{"https://thredds-test.ucar.edu:8444/dts/b31.dds"};
        System.out.println("*** Testing: Simple Https");
        for (String url : sshurls) {
            System.out.println("*** URL: " + url);
            HTTPSession session = HTTPFactory.newSession((String)url);
            HTTPMethod method = HTTPFactory.Get((HTTPSession)session);
            int status = method.execute();
            System.out.printf("\tstatus code = %d\n", status);
            this.pass = status == 200;
            TestAuth.assertTrue((String)"testSSH", (boolean)this.pass);
        }
    }

    @Test
    public void testBasic() throws Exception {
        System.out.println("*** Testing: Http Basic Password Authorization");
        for (AuthDataBasic data : basictests) {
            TestProvider provider = new TestProvider(data.user, data.password);
            System.out.println("*** URL: " + data.url);
            HTTPSession session = HTTPFactory.newSession((String)data.url);
            session.setCredentialsProvider((CredentialsProvider)provider);
            HTTPMethod method = HTTPFactory.Get((HTTPSession)session);
            int status = method.execute();
            System.err.printf("\tlocal provider: status code = %d\n", status);
            this.pass = status == 200 || status == 404;
            int count = provider.getCallCount();
            TestAuth.assertTrue((String)("Credentials provider called: " + count), (count == 1 ? 1 : 0) != 0);
            byte[] contents = TestAuth.readbinaryfile(method.getResponseAsStream());
            TestAuth.assertTrue((String)"no content", (contents.length > 0 ? 1 : 0) != 0);
            if (this.pass) {
                HTTPSession.setGlobalCredentialsProvider((CredentialsProvider)provider);
                session = HTTPFactory.newSession((String)data.url);
                method = HTTPFactory.Get((HTTPSession)session);
                status = method.execute();
                System.err.printf("\tglobal provider test: status code = %d\n", status);
                System.err.flush();
                this.pass = status == 200 || status == 404;
            }
            TestAuth.assertTrue((String)"testBasic", (boolean)this.pass);
        }
    }

    @Test
    public void testBasic2() throws Exception {
        System.err.println("*** Testing: Http Basic Password Authorization Using direct credentials");
        for (AuthDataBasic data : basictests) {
            UsernamePasswordCredentials cred = new UsernamePasswordCredentials(data.user, data.password);
            System.err.println("*** URL: " + data.url);
            HTTPSession session = HTTPFactory.newSession((String)data.url);
            session.setCredentials("Basic", (Credentials)cred);
            HTTPMethod method = HTTPFactory.Get((HTTPSession)session);
            int status = method.execute();
            System.err.printf("\tlocal provider: status code = %d\n", status);
            System.err.flush();
            boolean bl = this.pass = status == 200 || status == 404;
            if (this.pass) {
                session.clearState();
                AuthScope scope = HTTPAuthScope.urlToScope((String)data.url, (String)"Basic", null);
                HTTPSession.setGlobalCredentials((AuthScope)scope, (Credentials)cred);
                session = HTTPFactory.newSession((String)data.url);
                method = HTTPFactory.Get((HTTPSession)session);
                status = method.execute();
                System.err.printf("\tglobal provider test: status code = %d\n", status);
                System.err.flush();
                boolean bl2 = this.pass = status == 200 || status == 404;
            }
            if (this.pass) {
                TestAuth.assertTrue((String)"testBasic", (boolean)true);
                continue;
            }
            TestAuth.assertTrue((String)"testBasic", (boolean)false);
        }
    }

    @Test
    public void testBasic3() throws Exception {
        System.err.println("*** Testing: Cache Invalidation");
        HTTPAuthStore.DEFAULTS.clear();
        HTTPCredentialsCache.clearCache();
        for (AuthDataBasic data : basictests) {
            TestProvider provider = new TestProvider(data.user, BADPASSWORD);
            System.err.println("*** URL: " + data.url);
            HTTPSession session = HTTPFactory.newSession((String)data.url);
            session.setCredentialsProvider((CredentialsProvider)provider);
            HTTPMethod method = HTTPFactory.Get((HTTPSession)session);
            int status = method.execute();
            System.err.printf("\tlocal provider: status code = %d\n", status);
            TestAuth.assertTrue((status == 401 ? 1 : 0) != 0);
            int count = provider.getCallCount();
            TestAuth.assertTrue((String)("Credentials provider call count = " + count), (count == 1 ? 1 : 0) != 0);
            List removed = HTTPCredentialsCache.getTestList();
            if (removed.size() == 1) {
                HTTPCredentialsCache.Triple triple = (HTTPCredentialsCache.Triple)removed.get(0);
                this.pass = triple.scope.getScheme().equals("Basic".toUpperCase()) && triple.creds instanceof UsernamePasswordCredentials;
            } else {
                this.pass = false;
            }
            if (this.pass) {
                provider = new TestProvider(data.user, data.password);
                session.setCredentialsProvider((CredentialsProvider)provider);
                method = HTTPFactory.Get((HTTPSession)session);
                status = method.execute();
                TestAuth.assertTrue((status == 200 ? 1 : 0) != 0);
            }
            if (this.pass) {
                TestAuth.assertTrue((String)"testBasic", (boolean)true);
                continue;
            }
            TestAuth.assertTrue((String)"testBasic", (boolean)false);
        }
    }

    @Test
    public void testKeystore() throws Exception {
    }

    @Test
    public void testSerialize() throws Exception {
        System.err.println("*** Testing: HTTPAuthStore (de-)serialization");
        boolean ok = true;
        TestProvider credp1 = new TestProvider("p1", "pwd");
        HTTPSSLProvider credp2 = new HTTPSSLProvider("keystore", "keystorepwd");
        TestProvider credp3 = new TestProvider("p3", "pwd3");
        UsernamePasswordCredentials cred1 = new UsernamePasswordCredentials("u1", "pwd1");
        UsernamePasswordCredentials cred2 = new UsernamePasswordCredentials("u2", "pwd2");
        AuthScope scope = new AuthScope("http://ceda.ac.uk/dap/neodc/casix/seawifs_plankton/data/monthly/PSC_monthly_1998.nc.dds", -1, AuthScope.ANY_REALM, "Basic");
        HTTPAuthStore store = new HTTPAuthStore();
        scope = HTTPAuthScope.urlToScope((String)"http://ceda.ac.uk/dap/neodc/casix/seawifs_plankton/data/monthly/PSC_monthly_1998.nc.dds", (String)"Basic", null);
        store.insert(HTTPAuthScope.ANY_PRINCIPAL, scope, (CredentialsProvider)credp1);
        scope = HTTPAuthScope.urlToScope((String)"http://ceda.ac.uk", (String)"SSL", null);
        store.insert(HTTPAuthScope.ANY_PRINCIPAL, scope, (CredentialsProvider)credp2);
        scope = HTTPAuthScope.urlToScope((String)"http://ceda.ac.uk", (String)"Basic", null);
        store.insert(HTTPAuthScope.ANY_PRINCIPAL, scope, (CredentialsProvider)credp3);
        File target1 = new File(TestLocal.temporaryDataDir + "serial1");
        target1.delete();
        FileOutputStream ostream = new FileOutputStream(target1);
        store.serialize((OutputStream)ostream, "password1");
        FileInputStream istream = new FileInputStream(target1);
        ObjectInputStream ois = HTTPAuthStore.openobjectstream((InputStream)istream, (String)"password1");
        HTTPAuthStore newstore = HTTPAuthStore.getDeserializedStore((ObjectInputStream)ois);
        List rows = store.getAllRows();
        List newrows = newstore.getAllRows();
        for (HTTPAuthStore.Entry row : rows) {
            HTTPAuthStore.Entry match = null;
            for (HTTPAuthStore.Entry e : newrows) {
                if (!HTTPAuthScope.equivalent((AuthScope)row.scope, (AuthScope)e.scope) && row.provider.getClass() == e.provider.getClass()) continue;
                if (match == null) {
                    match = e;
                    continue;
                }
                System.err.println("ambigous match");
                ok = false;
            }
            if (match != null) continue;
            System.err.println("no match for: " + row.toString());
            ok = false;
        }
        TestAuth.assertTrue((String)"test(De-)Serialize", (boolean)ok);
    }

    @Test
    public void testFirewall() throws Exception {
        Object user = null;
        Object pwd = null;
        Object host = null;
        int port = -1;
        Object url = null;
        System.err.println("*** Testing: Http Firewall Proxy (with authentication)");
        TestAuth.assertTrue((String)"testProxy", (boolean)true);
    }

    static {
        HTTPSession.TESTING = true;
        HTTPCredentialsCache.TESTING = true;
        HTTPAuthStore.TESTING = true;
        basictests = new AuthDataBasic[]{new AuthDataBasic("http://thredds-test.ucar.edu/thredds/dodsC/restrict/testData.nc.html", "tiggeUser", "tigge")};
    }

    static class AuthDataBasic {
        String url;
        String user = null;
        String password = null;

        public AuthDataBasic(String url, String usr, String pwd) {
            this.url = url;
            this.user = usr;
            this.password = pwd;
        }
    }

    static class TestProvider
    implements CredentialsProvider,
    Serializable {
        protected int callcount = 0;
        String username = null;
        String password = null;

        public TestProvider(String username, String password) {
            this.username = username;
            this.password = password;
            this.callcount = 0;
        }

        public int getCallCount() {
            int count = this.callcount;
            this.callcount = 0;
            return count;
        }

        public Credentials getCredentials(AuthScope scope) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.username, this.password);
            System.err.printf("TestCredentials.getCredentials called: creds=|%s| host=%s port=%d%n", creds.toString(), scope.getHost(), scope.getPort());
            ++this.callcount;
            return creds;
        }

        public void setCredentials(AuthScope scope, Credentials creds) {
        }

        public void clear() {
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeObject(this.username);
            oos.writeObject(this.password);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.username = (String)ois.readObject();
            this.password = (String)ois.readObject();
        }
    }
}

