/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.InputStream;
import ucar.nc2.util.UnitTestCommon;
import ucar.nc2.util.net.HTTPException;
import ucar.nc2.util.net.HTTPFactory;
import ucar.nc2.util.net.HTTPMethod;
import ucar.nc2.util.net.HTTPSession;

public class TestHTTPMethod
extends UnitTestCommon {
    static final String baseurl = "http://thredds-test.ucar.edu:8081/dts";
    static String relativebaseline = "/cdm/src/test/data/ucar/nc2/util/net";
    static final String testcase = "test.01.dds";
    static final int EXPECTED = 20000;
    int passcount = 0;
    int xfailcount = 0;
    int failcount = 0;
    boolean verbose = true;
    boolean pass = false;
    String datadir = null;
    String threddsroot = null;

    public TestHTTPMethod() {
        this.setTitle("HTTP Method tests");
    }

    public void testGetStream() throws Exception {
        HTTPSession session = null;
        HTTPMethod method = null;
        String url = "http://thredds-test.ucar.edu:8081/dts/test.01.dds";
        String baseline = threddsRoot + relativebaseline + "/" + testcase;
        System.out.println("*** Testing: HTTPMethod");
        System.out.println("*** URL: " + url);
        System.out.println("*** Testing: HTTPMethod.getResponseBodyAsStream");
        session = HTTPFactory.newSession((String)url);
        method = HTTPFactory.Get((HTTPSession)session);
        method.execute();
        InputStream stream = method.getResponseBodyAsStream();
        byte[] buffer = new byte[20000];
        int count = stream.read(buffer);
        stream.close();
        try {
            method.execute();
            this.pass = false;
        }
        catch (HTTPException he) {
            this.pass = true;
        }
        TestHTTPMethod.assertTrue((String)"TestHTTPMethod.testGetStream", (boolean)this.pass);
        session.close();
    }

    public void testGetStreamPartial() throws Exception {
        HTTPSession session = null;
        HTTPMethod method = null;
        String url = "http://thredds-test.ucar.edu:8081/dts/test.01.dds";
        String baseline = threddsRoot + relativebaseline + "/" + testcase;
        System.out.println("*** Testing: HTTPMethod");
        System.out.println("*** URL: " + url);
        System.out.println("*** Testing: HTTPMethod.getResponseBodyAsStream partial read");
        session = HTTPFactory.newSession((String)url);
        method = HTTPFactory.Get((HTTPSession)session);
        method.execute();
        InputStream stream = method.getResponseBodyAsStream();
        byte[] buffer = new byte[20000];
        int count = stream.read(buffer, 0, 10);
        method.close();
        try {
            count = stream.read(buffer);
            this.pass = false;
        }
        catch (Throwable t) {
            this.pass = true;
        }
        TestHTTPMethod.assertTrue((String)"TestHTTPMethod.testGetStreamPartial", (boolean)this.pass);
        session.close();
    }

    static {
        HTTPSession.TESTING = true;
    }
}

