/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import ucar.httpclient.HTTPException;
import ucar.httpclient.HTTPFactory;
import ucar.httpclient.HTTPMethod;
import ucar.httpclient.HTTPSession;
import ucar.nc2.util.UnitTestCommon;

public class NoTestAuth2
extends UnitTestCommon {
    private static Data[] cases = new Data[]{new Data("http://remotetest.unidata.ucar.edu/thredds/dodsC/restrict/testdata/testData.nc.html", new CredentialsProvider(){

        public Credentials getCredentials(AuthScope scope) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials("tiggeUser", "tigge");
            System.out.printf("getCredentials called: creds=|%s| host=%s port=%d%n", creds.toString(), scope.getHost(), scope.getPort());
            return creds;
        }

        public void setCredentials(AuthScope scope, Credentials creds) {
        }

        public void clear() {
        }
    }), new Data("https://remotetest.unidata.ucar.edu/dts/b31.dds", null)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAuth2() throws Exception {
        boolean pass = true;
        for (Data data : cases) {
            HTTPSession session = HTTPFactory.newSession((String)data.url);
            if (data.provider != null) {
                session.setCredentialsProvider(data.provider);
            }
            session.setUserAgent("tdmRunner");
            HTTPSession.setGlobalUserAgent((String)"TDM v4.3");
            HTTPMethod m = null;
            try {
                System.out.printf("url %s%n", data.url);
                m = HTTPFactory.Get((HTTPSession)session);
                int status = m.execute();
                String s = m.getResponseAsString();
                System.out.printf("Trigger response = %d == %s%n", status, s);
                if (status == 200 || status == 404) continue;
                pass = false;
            }
            catch (HTTPException e) {
                System.err.println("Fail: " + data.url);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                e.printStackTrace(new PrintStream(bos));
                e.printStackTrace();
                pass = false;
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        if (pass) {
            NoTestAuth2.assertTrue((String)"testAuth2", (boolean)true);
        } else {
            NoTestAuth2.assertTrue((String)"testAuth2", (boolean)false);
        }
    }

    static class Data {
        String url;
        CredentialsProvider provider;

        public Data(String u, CredentialsProvider p) {
            this.url = u;
            this.provider = p;
        }
    }
}

