/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.junit.Ignore;
import org.junit.Test;
import ucar.httpclient.HTTPAuthScope;
import ucar.httpclient.HTTPAuthStore;
import ucar.httpclient.HTTPCachingProvider;
import ucar.httpclient.HTTPFactory;
import ucar.httpclient.HTTPMethod;
import ucar.httpclient.HTTPSSLProvider;
import ucar.httpclient.HTTPSession;
import ucar.nc2.util.UnitTestCommon;

public class TestAuth
extends UnitTestCommon {
    static final String BADPASSWORD = "bad";
    protected static final String MODULE = "httpclient";
    protected static final boolean IGNORE = true;
    static boolean remote = false;
    static final String KEYDIR = "/httpclient/src/test/resources";
    static final String CLIENTKEY = "clientkey.jks";
    static final String CLIENTPWD = "changeit";
    static final boolean MUSTFAIL = true;
    static final boolean MUSTPASS = false;
    static String temppath = null;
    protected int passcount = 0;
    protected int xfailcount = 0;
    protected int failcount = 0;
    protected boolean verbose = true;
    protected boolean pass = false;
    protected String datadir = null;
    protected String threddsroot = null;
    static AuthDataBasic[] basictests;
    static AuthDataBasic[] redirecttests;

    public TestAuth(String name, String testdir) {
        super(name);
        this.setTitle("DAP Authorization tests");
    }

    public TestAuth(String name) {
        this(name, null);
    }

    public TestAuth() {
        this("TestAuth", null);
    }

    @Test
    public void testSSH() throws Exception {
        String[] sshurls = new String[]{"https://remotetest.unidata.ucar.edu/dts/b31.dds"};
        System.out.println("*** Testing: Simple Https");
        for (String url : sshurls) {
            System.out.println("*** URL: " + url);
            HTTPSession session = HTTPFactory.newSession((String)url);
            HTTPMethod method = HTTPFactory.Get((HTTPSession)session);
            int status = method.execute();
            System.out.printf("\tstatus code = %d\n", status);
            this.pass = status == 200;
            TestAuth.assertTrue((String)"testSSH", (boolean)this.pass);
        }
    }

    @Test
    public void testBasic() throws Exception {
    }

    @Test
    public void testBasicDirect() throws Exception {
    }

    @Test
    public void testCache() throws Exception {
    }

    @Ignore
    @Test
    public void testDigest() throws Exception {
    }

    public void testRedirect() throws Exception {
    }

    @Ignore
    @Test
    public void testKeystore() throws Exception {
    }

    @Test
    public void testSerialize() throws Exception {
        System.err.println("*** Testing: HTTPAuthStore (de-)serialization");
        boolean ok = true;
        TestProvider credp1 = new TestProvider("p1", "pwd");
        HTTPSSLProvider credp2 = new HTTPSSLProvider("keystore", "keystorepwd");
        TestProvider credp3 = new TestProvider("p3", "pwd3");
        UsernamePasswordCredentials cred1 = new UsernamePasswordCredentials("u1", "pwd1");
        UsernamePasswordCredentials cred2 = new UsernamePasswordCredentials("u2", "pwd2");
        AuthScope scope = new AuthScope("http://ceda.ac.uk/dap/neodc/casix/seawifs_plankton/data/monthly/PSC_monthly_1998.nc.dds", -1, AuthScope.ANY_REALM, "Basic");
        HTTPAuthStore store = new HTTPAuthStore();
        scope = HTTPAuthScope.urlToScope((String)"http://ceda.ac.uk/dap/neodc/casix/seawifs_plankton/data/monthly/PSC_monthly_1998.nc.dds", (String)"Basic", null);
        store.insert(HTTPAuthScope.ANY_PRINCIPAL, scope, (CredentialsProvider)credp1);
        scope = HTTPAuthScope.urlToScope((String)"http://ceda.ac.uk", (String)"SSL", null);
        store.insert(HTTPAuthScope.ANY_PRINCIPAL, scope, (CredentialsProvider)credp2);
        scope = HTTPAuthScope.urlToScope((String)"http://ceda.ac.uk", (String)"Basic", null);
        store.insert(HTTPAuthScope.ANY_PRINCIPAL, scope, (CredentialsProvider)credp3);
        File target1 = new File(temppath + "/serial1");
        target1.delete();
        FileOutputStream ostream = new FileOutputStream(target1);
        store.serialize((OutputStream)ostream, "password1");
        FileInputStream istream = new FileInputStream(target1);
        ObjectInputStream ois = HTTPAuthStore.openobjectstream((InputStream)istream, (String)"password1");
        HTTPAuthStore newstore = HTTPAuthStore.getDeserializedStore((ObjectInputStream)ois);
        List rows = store.getAllRows();
        List newrows = newstore.getAllRows();
        for (HTTPAuthStore.Entry row : rows) {
            HTTPAuthStore.Entry match = null;
            for (HTTPAuthStore.Entry e : newrows) {
                if (!HTTPAuthScope.equivalent((AuthScope)row.scope, (AuthScope)e.scope) && row.provider.getClass() == e.provider.getClass()) continue;
                if (match == null) {
                    match = e;
                    continue;
                }
                System.err.println("ambigous match");
                ok = false;
            }
            if (match != null) continue;
            System.err.println("no match for: " + row.toString());
            ok = false;
        }
        TestAuth.assertTrue((String)"test(De-)Serialize", (boolean)ok);
    }

    @Ignore
    @Test
    public void testFirewall() throws Exception {
    }

    static {
        HTTPSession.TESTING = true;
        HTTPCachingProvider.TESTING = true;
        HTTPAuthStore.TESTING = true;
        temppath = threddsRoot + "/" + MODULE + "/" + TEMPROOT;
        new File(temppath).mkdirs();
        basictests = new AuthDataBasic[]{new AuthDataBasic("http://remotetest.unidata.ucar.edu/thredds/restricted/basicAuth", "remoteUser", "remotePassword")};
        redirecttests = new AuthDataBasic[]{new AuthDataBasic("http://remotetest.unidata.ucar.edu/thredds/dodsC/restrict/testData.nc.dds", "tiggUser", "tigge")};
    }

    static class AuthDataBasic {
        String url;
        String user = null;
        String password = null;

        public AuthDataBasic(String url, String usr, String pwd) {
            this.url = url;
            this.user = usr;
            this.password = pwd;
        }
    }

    static class TestProvider
    implements CredentialsProvider,
    Serializable {
        protected int callcount = 0;
        String username = null;
        String password = null;

        public TestProvider(String username, String password) {
            this.username = username;
            this.password = password;
            this.callcount = 0;
        }

        public int getCallCount() {
            int count = this.callcount;
            this.callcount = 0;
            return count;
        }

        public Credentials getCredentials(AuthScope scope) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.username, this.password);
            System.err.printf("TestCredentials.getCredentials called: creds=|%s| host=%s port=%d%n", creds.toString(), scope.getHost(), scope.getPort());
            ++this.callcount;
            return creds;
        }

        public void setCredentials(AuthScope scope, Credentials creds) {
        }

        public void clear() {
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeObject(this.username);
            oos.writeObject(this.password);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.username = (String)ois.readObject();
            this.password = (String)ois.readObject();
        }
    }
}

