/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.message.AbstractHttpMessage;
import org.junit.Test;
import ucar.httpclient.HTTPBasicProvider;
import ucar.httpclient.HTTPFactory;
import ucar.httpclient.HTTPMethod;
import ucar.httpclient.HTTPSession;
import ucar.nc2.util.UnitTestCommon;

public class TestHTTPSession
extends UnitTestCommon {
    static final String TESTURL1 = "http://remotetest.unidata.ucar.edu/dts/test.01.dds";
    static final String GLOBALAGENT = "TestUserAgent123global";
    static final String SESSIONAGENT = "TestUserAgent123session";
    int passcount = 0;
    int xfailcount = 0;
    int failcount = 0;
    boolean verbose = true;
    boolean pass = false;
    String datadir = null;
    String threddsroot = null;

    public TestHTTPSession() {
        this.setTitle("HTTP Session tests");
        HTTPSession.TESTING = true;
    }

    @Test
    public void testAgent() throws Exception {
        System.out.println("*** Testing: User Agent");
        System.out.println("*** URL: http://remotetest.unidata.ucar.edu/dts/test.01.dds");
        System.out.println("Test: HTTPSession.setGlobalUserAgent(TestUserAgent123global)");
        HTTPSession.debugHeaders((boolean)false);
        HTTPSession.setGlobalUserAgent((String)GLOBALAGENT);
        HTTPSession session = HTTPFactory.newSession((String)TESTURL1);
        HTTPMethod method = HTTPFactory.Get((HTTPSession)session);
        method.execute();
        List agents = HTTPSession.debugRequestInterceptor().getHeaders("User-Agent");
        TestHTTPSession.assertFalse((String)"User-Agent Header not found", (agents.size() == 0 ? 1 : 0) != 0);
        TestHTTPSession.assertFalse((String)"Multiple User-Agent Headers", (agents.size() > 1 ? 1 : 0) != 0);
        TestHTTPSession.assertTrue((String)String.format("User-Agent mismatch: expected %s found:%s", GLOBALAGENT, ((Header)agents.get(0)).getValue()), (boolean)GLOBALAGENT.equals(((Header)agents.get(0)).getValue()));
        System.out.println("*** Pass: set global agent");
        System.out.println("Test: HTTPSession.setUserAgent(TestUserAgent123session)");
        HTTPSession.debugReset();
        session.setUserAgent(SESSIONAGENT);
        method = HTTPFactory.Get((HTTPSession)session);
        method.execute();
        agents = HTTPSession.debugRequestInterceptor().getHeaders("User-Agent");
        TestHTTPSession.assertFalse((String)"User-Agent Header not found", (agents.size() == 0 ? 1 : 0) != 0);
        TestHTTPSession.assertFalse((String)"Multiple User-Agent Headers", (agents.size() > 1 ? 1 : 0) != 0);
        TestHTTPSession.assertTrue((String)String.format("User-Agent mismatch: expected %s found:%s", SESSIONAGENT, ((Header)agents.get(0)).getValue()), (boolean)SESSIONAGENT.equals(((Header)agents.get(0)).getValue()));
        System.out.println("*** Pass: set session agent");
        session.close();
    }

    @Test
    public void testConfigure() throws Exception {
        HTTPSession session = HTTPFactory.newSession((String)TESTURL1);
        System.out.println("Test: HTTPSession: Configuration");
        session.setSoTimeout(17777);
        session.setConnectionTimeout(37777);
        session.setMaxRedirects(111);
        HTTPBasicProvider bp = new HTTPBasicProvider("anyuser", "password");
        session.setCredentialsProvider("Basic", (CredentialsProvider)bp);
        HTTPMethod method = HTTPFactory.Get((HTTPSession)session);
        method.execute();
        AbstractHttpMessage dbgreq = (AbstractHttpMessage)method.debugRequest();
        boolean b = dbgreq.getParams().getBooleanParameter("http.protocol.allow-circular-redirects", true);
        System.out.println("Test: Circular Redirects");
        TestHTTPSession.assertTrue((String)"*** Fail: Circular Redirects", (boolean)b);
        System.out.println("*** Pass: Circular Redirects");
        System.out.println("Test: Max Redirects");
        int n = dbgreq.getParams().getIntParameter("http.protocol.max-redirects", -1);
        TestHTTPSession.assertTrue((String)"*** Fail: Max Redirects", (n == 111 ? 1 : 0) != 0);
        System.out.println("*** Pass: Max Redirects");
        System.out.println("Test: SO Timeout");
        n = dbgreq.getParams().getIntParameter("http.socket.timeout", -1);
        TestHTTPSession.assertTrue((String)"*** Fail: SO Timeout", (n == 17777 ? 1 : 0) != 0);
        System.out.println("*** Pass: SO Timeout");
        System.out.println("Test: Connection Timeout");
        n = dbgreq.getParams().getIntParameter("http.connection.timeout", -1);
        TestHTTPSession.assertTrue((String)"*** Fail: Connection Timeout", (n == 37777 ? 1 : 0) != 0);
        System.out.println("*** Pass: SO Timeout");
        session.close();
    }
}

