/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.net.URI;
import org.junit.Test;
import ucar.httpclient.HTTPFactory;
import ucar.httpclient.HTTPMethod;
import ucar.httpclient.HTTPSession;
import ucar.nc2.util.EscapeStrings;
import ucar.nc2.util.UnitTestCommon;

public class TestMisc
extends UnitTestCommon {
    int passcount = 0;
    int xfailcount = 0;
    int failcount = 0;
    boolean verbose = true;
    boolean pass = false;
    String datadir = null;
    String threddsroot = null;
    static final String[] esinputs;
    static final String[] esoutputs;

    public TestMisc() {
        this.setTitle("HTTP Session tests");
    }

    @Test
    public void testEscapeStrings() throws Exception {
        this.pass = true;
        assert (esinputs.length == esoutputs.length);
        for (int i = 0; i < esinputs.length && this.pass; ++i) {
            String result = EscapeStrings.escapeURL((String)esinputs[i]);
            System.err.printf("input= |%s|\n", esinputs[i]);
            System.err.printf("result=|%s|\n", result);
            System.err.printf("output=|%s|\n", esoutputs[i]);
            if (!result.equals(esoutputs[i])) {
                this.pass = false;
            }
            System.out.printf("input=%s output=%s pass=%s\n", esinputs[i], result, this.pass);
        }
        TestMisc.assertTrue((String)"TestMisc.testEscapeStrings", (boolean)this.pass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUTF8Stream() throws Exception {
        this.pass = true;
        String catalogName = "http://thredds.ucar.edu/thredds/catalog.xml";
        URI catalogURI = new URI(catalogName);
        HTTPMethod m = null;
        try (HTTPSession client = null;){
            client = HTTPFactory.newSession((String)catalogName);
            m = HTTPFactory.Get((HTTPSession)client);
            int statusCode = m.execute();
            System.out.printf("status = %d%n", statusCode);
            try {
                String content = m.getResponseAsString("ASC");
                System.out.printf("cat = %s%n", content);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    static {
        HTTPSession.TESTING = true;
        esinputs = new String[]{"http://localhost:8081/dts/test.01", "http://localhost:8081///xx/", "http://localhost:8081/<>^/`/"};
        esoutputs = new String[]{"http://localhost:8081/dts/test.01", "http://localhost:8081///xx/", "http://localhost:8081/%3c%3e%5e/%60/"};
    }
}

