/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.junit.Test;
import ucar.httpclient.HTTPFactory;
import ucar.httpclient.HTTPMethod;
import ucar.httpclient.HTTPMethodStream;
import ucar.httpclient.HTTPSession;
import ucar.nc2.util.UnitTestCommon;

public class TestState
extends UnitTestCommon {
    static final String SESSIONURL = "http://remotetest.unidata.ucar.edu/dts";
    static final String TESTSOURCE1 = "http://remotetest.unidata.ucar.edu/dts/test.01.dds";
    static final String TESTSOURCE2 = "http://remotetest.unidata.ucar.edu/dts/test.02.dds";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    boolean verbose = false;
    boolean pass = false;

    public TestState() {
        this.setTitle("HTTP Session and Method State tests");
    }

    @Test
    public void testState() throws Exception {
        HTTPSession session = HTTPFactory.newSession((String)SESSIONURL);
        TestState.assertFalse((boolean)session.isClosed());
        HTTPMethod method = HTTPFactory.Get((HTTPSession)session, (String)TESTSOURCE1);
        TestState.assertFalse((boolean)method.isClosed());
        int methodcount = session.getMethodcount();
        TestState.assertTrue((methodcount == 1 ? 1 : 0) != 0);
        method.execute();
        HTTPMethodStream stream = (HTTPMethodStream)method.getResponseBodyAsStream();
        TestState.assertTrue((boolean)method.hasStreamOpen());
        stream.close();
        TestState.assertTrue((boolean)method.isClosed());
        TestState.assertFalse((boolean)method.hasStreamOpen());
        methodcount = session.getMethodcount();
        TestState.assertTrue((methodcount == 0 ? 1 : 0) != 0);
        method = HTTPFactory.Get((HTTPSession)session, (String)TESTSOURCE1);
        methodcount = session.getMethodcount();
        TestState.assertTrue((methodcount == 1 ? 1 : 0) != 0);
        method.execute();
        stream = (HTTPMethodStream)method.getResponseBodyAsStream();
        method.close();
        TestState.assertTrue((boolean)stream.isClosed());
        TestState.assertFalse((boolean)method.hasStreamOpen());
        TestState.assertTrue((boolean)method.isClosed());
        method = HTTPFactory.Get((HTTPSession)session);
        methodcount = session.getMethodcount();
        TestState.assertTrue((methodcount == 1 ? 1 : 0) != 0);
        method.execute();
        stream = (HTTPMethodStream)method.getResponseBodyAsStream();
        session.close();
        TestState.assertTrue((boolean)stream.isClosed());
        TestState.assertTrue((boolean)method.isClosed());
        methodcount = session.getMethodcount();
        TestState.assertTrue((methodcount == 0 ? 1 : 0) != 0);
        TestState.assertTrue((boolean)session.isClosed());
        method = HTTPFactory.Get((String)TESTSOURCE1);
        TestState.assertTrue((boolean)method.isSessionLocal());
        session = method.getSession();
        methodcount = session.getMethodcount();
        TestState.assertTrue((methodcount == 1 ? 1 : 0) != 0);
        method.execute();
        String body = method.getResponseAsString();
        try {
            stream = (HTTPMethodStream)method.getResponseBodyAsStream();
            TestState.readbinaryfile((InputStream)stream);
            System.err.println("Stream not closed.");
            TestState.assertFalse((boolean)stream.isClosed());
        }
        catch (Exception e) {
            TestState.assertFalse((boolean)method.hasStreamOpen());
        }
        TestState.assertTrue((boolean)method.isClosed());
        methodcount = session.getMethodcount();
        TestState.assertTrue((methodcount == 0 ? 1 : 0) != 0);
        TestState.assertTrue((boolean)session.isClosed());
    }
}

