/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.NestedPointFeatureCollection;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.ProfileFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.writer.WriterCFPointCollection;
import ucar.nc2.ft.point.writer.WriterCFProfileCollection;
import ucar.nc2.ft.point.writer.WriterCFStationCollection;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingStrategy;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonRect;

public class CFPointWriter {
    private static boolean debug = false;
    private static final String[] reservedGAtts = new String[]{"Conventions", "geospatial_lat_min", "geospatial_lat_max", "geospatial_lon_min", "geospatial_lon_max", "time_coverage_start", "time_coverage_end", "_CoordSysBuilder", "CF:featureType", "CF:feature_type"};
    private static final String[] reservedVAtts = new String[]{"_CoordinateAxisType"};
    protected static final List<String> reservedGlobalAtts = Arrays.asList(reservedGAtts);
    protected static final List<String> reservedVariableAtts = Arrays.asList(reservedVAtts);
    protected static final String recordName = "record";
    protected static final String recordDimName = "obs";
    protected static final String latName = "latitude";
    protected static final String lonName = "longitude";
    protected static final String altName = "altitude";
    protected static final String timeName = "time";
    protected NetcdfFileWriter writer;
    protected Map<String, Variable> dataVarMap = new HashMap<String, Variable>();
    protected Structure record;
    protected String altUnits = null;
    protected LatLonRect llbb = null;
    protected CalendarDate minDate = null;
    protected CalendarDate maxDate = null;
    protected final boolean addTimeCoverage;
    protected final boolean isNetcdf3;
    protected final boolean isExtendedModel;

    public static int writeFeatureCollection(FeatureDatasetPoint fdpoint, String fileOut, NetcdfFileWriter.Version version) throws IOException {
        for (FeatureCollection fc : fdpoint.getPointFeatureCollectionList()) {
            assert (fc instanceof PointFeatureCollection || fc instanceof NestedPointFeatureCollection) : fc.getClass().getName();
            if (fc instanceof PointFeatureCollection) {
                return CFPointWriter.writePointFeatureCollection(fdpoint, (PointFeatureCollection)fc, fileOut, version);
            }
            if (fc instanceof StationTimeSeriesFeatureCollection) {
                return CFPointWriter.writeStationFeatureCollection(fdpoint, (StationTimeSeriesFeatureCollection)fc, fileOut, version);
            }
            if (!(fc instanceof ProfileFeatureCollection)) continue;
            return CFPointWriter.writeProfileFeatureCollection(fdpoint, (ProfileFeatureCollection)fc, fileOut, version);
        }
        return 0;
    }

    private static int writePointFeatureCollection(FeatureDatasetPoint fdpoint, PointFeatureCollection pfc, String fileOut, NetcdfFileWriter.Version version) throws IOException {
        WriterCFPointCollection cfWriter = new WriterCFPointCollection(version, fileOut, fdpoint.getGlobalAttributes());
        int count = 0;
        pfc.resetIteration();
        while (pfc.hasNext()) {
            PointFeature pf = pfc.next();
            if (count == 0) {
                cfWriter.writeHeader(fdpoint.getDataVariables(), pf.getTimeUnit(), null);
            }
            cfWriter.writeRecord(pf, pf.getData());
            if (debug && ++count % 100 == 0) {
                System.out.printf("%d ", count);
            }
            if (!debug || count % 1000 != 0) continue;
            System.out.printf("%n ", new Object[0]);
        }
        cfWriter.finish();
        return count;
    }

    private static int writeStationFeatureCollection(FeatureDatasetPoint fdpoint, StationTimeSeriesFeatureCollection fds, String fileOut, NetcdfFileWriter.Version version) throws IOException {
        WriterCFStationCollection cfWriter = new WriterCFStationCollection(version, fileOut, fdpoint.getGlobalAttributes());
        PointFeatureCollection pfc = fds.flatten(null, (CalendarDateRange)null);
        int count = 0;
        while (pfc.hasNext()) {
            PointFeature pf = pfc.next();
            if (count == 0) {
                cfWriter.writeHeader(fds.getStations(), fdpoint.getDataVariables(), pf.getTimeUnit(), "");
            }
            StationPointFeature spf = (StationPointFeature)pf;
            cfWriter.writeRecord(spf.getStation(), pf, pf.getData());
            if (debug && ++count % 100 == 0) {
                System.out.printf("%d ", count);
            }
            if (!debug || count % 1000 != 0) continue;
            System.out.printf("%n ", new Object[0]);
        }
        cfWriter.finish();
        return count;
    }

    private static int writeProfileFeatureCollection(FeatureDatasetPoint fdpoint, ProfileFeatureCollection pds, String fileOut, NetcdfFileWriter.Version version) throws IOException {
        WriterCFProfileCollection cfWriter = new WriterCFProfileCollection(fileOut, fdpoint.getGlobalAttributes(), version);
        int count = 0;
        ArrayList<String> profiles = new ArrayList<String>();
        pds.resetIteration();
        while (pds.hasNext()) {
            profiles.add(pds.next().getName());
        }
        pds.resetIteration();
        while (pds.hasNext()) {
            ProfileFeature profile = pds.next();
            profile.resetIteration();
            while (profile.hasNext()) {
                PointFeature pf = profile.next();
                if (count == 0) {
                    cfWriter.writeHeader(profiles, fdpoint.getDataVariables(), pf.getTimeUnit(), null);
                }
                cfWriter.writeRecord(profile.getName(), pf, pf.getData());
                if (debug && ++count % 100 == 0) {
                    System.out.printf("%d ", count);
                }
                if (!debug || count % 1000 != 0) continue;
                System.out.printf("%n ", new Object[0]);
            }
        }
        cfWriter.finish();
        return count;
    }

    protected CFPointWriter(String fileOut, List<Attribute> atts, NetcdfFileWriter.Version version) throws IOException {
        this.createWriter(fileOut, version);
        this.addGlobalAtts(atts);
        this.addTimeCoverage = true;
        this.isNetcdf3 = this.writer.getVersion() == NetcdfFileWriter.Version.netcdf3;
        this.isExtendedModel = this.writer.getVersion().isExtendedModel();
        this.addNetcdf3UnknownAtts(true);
    }

    protected CFPointWriter(String fileOut, List<Attribute> atts, NetcdfFileWriter.Version version, boolean addTimeCoverage) throws IOException {
        this.createWriter(fileOut, version);
        this.addGlobalAtts(atts);
        this.addTimeCoverage = addTimeCoverage;
        this.isNetcdf3 = this.writer.getVersion() == NetcdfFileWriter.Version.netcdf3;
        this.isExtendedModel = this.writer.getVersion().isExtendedModel();
        this.addNetcdf3UnknownAtts(addTimeCoverage);
    }

    private void createWriter(String fileOut, NetcdfFileWriter.Version version) throws IOException {
        this.writer = NetcdfFileWriter.createNew(version, fileOut, Nc4ChunkingStrategy.factory(Nc4Chunking.Strategy.none, 0, false));
        this.writer.setFill(false);
    }

    private void addGlobalAtts(List<Attribute> atts) {
        this.writer.addGroupAttribute(null, new Attribute("Conventions", "CF-1.6"));
        this.writer.addGroupAttribute(null, new Attribute("history", "Written by CFPointWriter"));
        for (Attribute att : atts) {
            if (reservedGlobalAtts.contains(att.getShortName())) continue;
            this.writer.addGroupAttribute(null, att);
        }
    }

    private void addNetcdf3UnknownAtts(boolean addTimeCoverage) {
        if (addTimeCoverage) {
            CalendarDate now = CalendarDate.of(new Date());
            this.writer.addGroupAttribute(null, new Attribute("time_coverage_start", CalendarDateFormatter.toDateTimeStringISO(now)));
            this.writer.addGroupAttribute(null, new Attribute("time_coverage_end", CalendarDateFormatter.toDateTimeStringISO(now)));
        }
        this.writer.addGroupAttribute(null, new Attribute("geospatial_lat_min", 0.0));
        this.writer.addGroupAttribute(null, new Attribute("geospatial_lat_max", 0.0));
        this.writer.addGroupAttribute(null, new Attribute("geospatial_lon_min", 0.0));
        this.writer.addGroupAttribute(null, new Attribute("geospatial_lon_max", 0.0));
    }

    public void setLength(long size) {
        this.writer.setLength(size);
    }

    protected void addDataVariablesClassic(List<? extends VariableSimpleIF> dataVars) throws IOException {
        HashSet<Dimension> dimSet = new HashSet<Dimension>(20);
        for (VariableSimpleIF variableSimpleIF : dataVars) {
            List<Dimension> dims = variableSimpleIF.getDimensions();
            dimSet.addAll(dims);
        }
        for (Dimension dimension : dimSet) {
            if (dimension.isUnlimited()) continue;
            this.writer.addDimension(null, dimension.getShortName(), dimension.getLength(), dimension.isShared(), false, dimension.isVariableLength());
        }
        for (VariableSimpleIF variableSimpleIF : dataVars) {
            if (this.writer.findVariable(variableSimpleIF.getShortName()) != null) continue;
            List<Dimension> oldDims = variableSimpleIF.getDimensions();
            StringBuilder dimNames = new StringBuilder(recordDimName);
            for (Dimension d : oldDims) {
                if (d.isUnlimited()) continue;
                dimNames.append(" ").append(d.getShortName());
            }
            Variable newVar = variableSimpleIF.getDataType().equals((Object)DataType.STRING) && !this.writer.getVersion().isExtendedModel() ? this.writer.addStringVariable(null, (Variable)variableSimpleIF, this.writer.makeDimList(null, dimNames.toString())) : this.writer.addVariable(null, variableSimpleIF.getShortName(), variableSimpleIF.getDataType(), dimNames.toString());
            List<Attribute> atts = variableSimpleIF.getAttributes();
            for (Attribute att : atts) {
                if (reservedVariableAtts.contains(att.getShortName())) continue;
                newVar.addAttribute(att);
            }
            String coordNames = "time latitude longitude";
            if (this.altUnits != null) {
                coordNames = coordNames + " " + altName;
            }
            newVar.addAttribute(new Attribute("coordinates", coordNames));
            this.dataVarMap.put(newVar.getShortName(), newVar);
        }
    }

    protected void addVariablesExtended(List<? extends VariableSimpleIF> dataVars) throws IOException {
        for (VariableSimpleIF variableSimpleIF : dataVars) {
            if (this.record.findVariable(variableSimpleIF.getShortName()) != null) continue;
            StringBuilder dimNames = new StringBuilder();
            for (Dimension d : variableSimpleIF.getDimensions()) {
                if (d.isUnlimited() || d.getShortName().equals(recordDimName)) continue;
                dimNames.append(" ").append(d.getLength());
            }
            Variable m = this.writer.addStructureMember(this.record, variableSimpleIF.getShortName(), variableSimpleIF.getDataType(), dimNames.toString());
            List<Attribute> atts = variableSimpleIF.getAttributes();
            for (Attribute att : atts) {
                if (reservedVariableAtts.contains(att.getShortName())) continue;
                m.addAttribute(att);
            }
            String coordNames = "time latitude longitude";
            if (this.altUnits != null) {
                coordNames = coordNames + " " + altName;
            }
            m.addAttribute(new Attribute("coordinates", coordNames));
        }
    }

    protected void trackBB(EarthLocation loc, CalendarDate obsDate) {
        if (loc != null) {
            if (this.llbb == null) {
                this.llbb = new LatLonRect(loc.getLatLon(), 0.001, 0.001);
                return;
            }
            this.llbb.extend(loc.getLatLon());
        }
        if (this.minDate == null || this.minDate.isAfter(obsDate)) {
            this.minDate = obsDate;
        }
        if (this.maxDate == null || this.maxDate.isBefore(obsDate)) {
            this.maxDate = obsDate;
        }
    }

    public void finish() throws IOException {
        if (this.llbb != null) {
            this.writer.updateAttribute(null, new Attribute("geospatial_lat_min", this.llbb.getLowerLeftPoint().getLatitude()));
            this.writer.updateAttribute(null, new Attribute("geospatial_lat_max", this.llbb.getUpperRightPoint().getLatitude()));
            this.writer.updateAttribute(null, new Attribute("geospatial_lon_min", this.llbb.getLowerLeftPoint().getLongitude()));
            this.writer.updateAttribute(null, new Attribute("geospatial_lon_max", this.llbb.getUpperRightPoint().getLongitude()));
        }
        if (this.addTimeCoverage) {
            if (this.minDate == null) {
                this.minDate = CalendarDate.present();
            }
            if (this.maxDate == null) {
                this.maxDate = CalendarDate.present();
            }
            this.writer.updateAttribute(null, new Attribute("time_coverage_start", CalendarDateFormatter.toDateTimeStringISO(this.minDate)));
            this.writer.updateAttribute(null, new Attribute("time_coverage_end", CalendarDateFormatter.toDateTimeStringISO(this.maxDate)));
        }
        this.writer.close();
    }

    protected int writeStructureData(int[] origin, StructureData sdata) throws IOException, InvalidRangeException {
        if (this.writer.getVersion().isExtendedModel() || this.isNetcdf3) {
            return this.writer.appendStructureData(this.record, sdata);
        }
        for (StructureMembers.Member m : sdata.getMembers()) {
            Variable mv;
            Array org = sdata.getArray(m);
            Array orgPlus1 = Array.makeArrayRankPlusOne(org);
            int[] useOrigin = origin;
            if (org.getRank() > 0) {
                useOrigin = new int[org.getRank() + 1];
                useOrigin[0] = origin[0];
            }
            if ((mv = this.dataVarMap.get(m.getName())) == null) continue;
            this.writer.write(mv, useOrigin, orgPlus1);
        }
        return origin[0];
    }
}

