/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFactory;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.crawlabledataset.filter.WildcardMatchOnNameFilter;

public class CrawlableDatasetAlias
implements CrawlableDataset {
    private static Logger log = LoggerFactory.getLogger(CrawlableDatasetAlias.class);
    private String path;
    private String name;
    private String wildcardPattern;
    private String postWildcardPath;
    private CrawlableDataset startDs;
    private String className;
    private Object configObj;

    public static boolean isAlias(String path) {
        return path.indexOf("*") != -1;
    }

    public CrawlableDatasetAlias(String path, String className, Object configObj) {
        if (!CrawlableDatasetAlias.isAlias(path)) {
            throw new IllegalArgumentException("No wildcard in path <" + path + ">.");
        }
        this.path = path;
        this.className = className;
        this.configObj = configObj;
        int preWildcardIndex = this.path.lastIndexOf("/", this.path.indexOf("*"));
        int postWildcardIndex = this.path.indexOf("/", preWildcardIndex + 1);
        log.debug("[" + preWildcardIndex + "] - [" + postWildcardIndex + "]");
        String preWildcardPath = this.path.substring(0, preWildcardIndex);
        this.wildcardPattern = postWildcardIndex == -1 ? this.path.substring(preWildcardIndex + 1) : this.path.substring(preWildcardIndex + 1, postWildcardIndex);
        this.postWildcardPath = postWildcardIndex == -1 ? null : this.path.substring(postWildcardIndex + 1);
        log.debug("dirPattern <" + this.path + ">=<" + preWildcardPath + "[" + preWildcardIndex + "]" + this.wildcardPattern + "[" + postWildcardIndex + "]" + this.postWildcardPath + ">");
        this.name = this.path.substring(preWildcardIndex + 1);
        try {
            this.startDs = CrawlableDatasetFactory.createCrawlableDataset(preWildcardPath, this.className, this.configObj);
        }
        catch (Exception e) {
            String tmpMsg = "Pre-wildcard path <" + preWildcardPath + "> not a CrawlableDataset of expected type <" + this.className + ">: " + e.getMessage();
            log.warn("CrawlableDatasetAlias(): " + tmpMsg);
            throw new IllegalArgumentException(tmpMsg);
        }
        if (!this.startDs.isCollection()) {
            String tmpMsg = "Pre-wildcard path not a directory <" + this.startDs.getPath() + ">";
            log.warn("CrawlableDatasetAlias(): " + tmpMsg);
            throw new IllegalArgumentException(tmpMsg);
        }
    }

    @Override
    public Object getConfigObject() {
        return this.configObj;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public CrawlableDataset getDescendant(String childPath) {
        return null;
    }

    @Override
    public CrawlableDataset getParentDataset() {
        return null;
    }

    @Override
    public List<CrawlableDataset> listDatasets() throws IOException {
        List<CrawlableDataset> curMatchDatasets = this.startDs.listDatasets(new MyFilter(this.wildcardPattern, this.postWildcardPath != null));
        if (this.postWildcardPath == null) {
            return curMatchDatasets;
        }
        ArrayList<CrawlableDataset> list = new ArrayList<CrawlableDataset>();
        for (CrawlableDataset curDs : curMatchDatasets) {
            String curMatchPathName = curDs.getPath() + "/" + this.postWildcardPath;
            CrawlableDataset newCrawlableDs = null;
            try {
                newCrawlableDs = CrawlableDatasetFactory.createCrawlableDataset(curMatchPathName, this.className, this.configObj);
            }
            catch (Exception e) {
                String tmpMsg = "Couldn't create CrawlableDataset for path <" + curMatchPathName + "> and given class name <" + this.className + ">: " + e.getMessage();
                log.warn("listDatasets(): " + tmpMsg);
                continue;
            }
            if (CrawlableDatasetAlias.isAlias(this.postWildcardPath)) {
                list.addAll(newCrawlableDs.listDatasets());
                continue;
            }
            list.add(newCrawlableDs);
        }
        return list;
    }

    @Override
    public List<CrawlableDataset> listDatasets(CrawlableDatasetFilter filter) throws IOException {
        List<CrawlableDataset> list = this.listDatasets();
        if (filter == null) {
            return list;
        }
        ArrayList<CrawlableDataset> result = new ArrayList<CrawlableDataset>(list.size());
        for (CrawlableDataset curDs : list) {
            if (!filter.accept(curDs)) continue;
            result.add(curDs);
        }
        return result;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public Date lastModified() {
        return null;
    }

    private class MyFilter
    implements CrawlableDatasetFilter {
        private boolean mustBeCollection;
        private WildcardMatchOnNameFilter proxyFilter;

        MyFilter(String wildcardString, boolean mustBeCollection) {
            this.proxyFilter = new WildcardMatchOnNameFilter(wildcardString);
            this.mustBeCollection = mustBeCollection;
        }

        @Override
        public Object getConfigObject() {
            return null;
        }

        @Override
        public boolean accept(CrawlableDataset dataset) {
            if (this.mustBeCollection && !dataset.isCollection()) {
                return false;
            }
            return this.proxyFilter.accept(dataset);
        }
    }
}

