/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.filesystem.MFileOS7;
import thredds.inventory.CollectionGlob;
import thredds.inventory.CollectionList;
import thredds.inventory.CollectionManagerCatalog;
import thredds.inventory.CollectionSingleFile;
import thredds.inventory.DateExtractor;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import thredds.inventory.MFileFilter;
import thredds.inventory.partition.DirectoryCollection;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.CloseableIterator;
import ucar.unidata.util.StringUtil2;

public abstract class CollectionAbstract
implements MCollection {
    private static Logger defaultLog = LoggerFactory.getLogger((String)"featureCollectionScan");
    public static final String NCX_SUFFIX = ".ncx2";
    public static final String CATALOG = "catalog:";
    public static final String DIR = "directory:";
    public static final String FILE = "file:";
    public static final String LIST = "list:";
    public static final String GLOB = "glob:";
    protected String collectionName;
    protected String root;
    protected final Logger logger;
    protected FeatureCollectionConfig.ProtoChoice protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
    protected Map<String, Object> auxInfo;
    protected DateExtractor dateExtractor;
    protected CalendarDate startCollection;
    protected long lastModified;
    protected MFileFilter filter;
    protected DirectoryStream.Filter<Path> sfilter;
    private boolean isLeaf = true;

    public static MCollection open(String collectionName, String collectionSpec, String olderThan, Formatter errlog) throws IOException {
        if (collectionSpec.startsWith(CATALOG)) {
            return new CollectionManagerCatalog(collectionName, collectionSpec.substring(CATALOG.length()), olderThan, errlog);
        }
        if (collectionSpec.startsWith(DIR)) {
            return new DirectoryCollection(collectionName, collectionSpec.substring(DIR.length()), null);
        }
        if (collectionSpec.startsWith(FILE)) {
            return new CollectionSingleFile(MFileOS7.getExistingFile(collectionSpec.substring(FILE.length())), null);
        }
        if (collectionSpec.startsWith(LIST)) {
            return new CollectionList(collectionName, collectionSpec.substring(LIST.length()), null);
        }
        if (collectionSpec.startsWith(GLOB)) {
            return new CollectionGlob(collectionName, collectionSpec.substring(GLOB.length()), null);
        }
        return MFileCollectionManager.open(collectionName, collectionSpec, olderThan, errlog);
    }

    public static String cleanName(String name) {
        if (name == null) {
            return null;
        }
        return StringUtil2.replace(name.trim(), ' ', "_");
    }

    protected CollectionAbstract(String collectionName, Logger logger) {
        this.collectionName = CollectionAbstract.cleanName(collectionName);
        this.logger = logger != null ? logger : defaultLog;
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    @Override
    public String getCollectionName() {
        return this.collectionName;
    }

    @Override
    public String getIndexFilename() {
        return this.getRoot() + "/" + this.collectionName + NCX_SUFFIX;
    }

    public void setMFileFilter(MFileFilter filter) {
        this.filter = filter;
    }

    public void setStreamFilter(DirectoryStream.Filter<Path> filter) {
        this.sfilter = filter;
    }

    @Override
    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public MFile getLatestFile() throws IOException {
        MFile result = null;
        Iterator<MFile> i$ = this.getFilesSorted().iterator();
        while (i$.hasNext()) {
            MFile f;
            result = f = i$.next();
        }
        return result;
    }

    @Override
    public List<String> getFilenames() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (MFile f : this.getFilesSorted()) {
            result.add(f.getPath());
        }
        return result;
    }

    @Override
    public CalendarDate extractDate(MFile mfile) {
        return this.dateExtractor == null ? null : this.dateExtractor.getCalendarDate(mfile);
    }

    @Override
    public boolean hasDateExtractor() {
        return this.dateExtractor != null;
    }

    public void setDateExtractor(DateExtractor dateExtractor) {
        this.dateExtractor = dateExtractor;
    }

    @Override
    public CalendarDate getStartCollection() {
        return this.startCollection;
    }

    @Override
    public Object getAuxInfo(String key) {
        return this.auxInfo == null ? null : this.auxInfo.get(key);
    }

    @Override
    public void putAuxInfo(String key, Object value) {
        if (this.auxInfo == null) {
            this.auxInfo = new HashMap<String, Object>();
        }
        this.auxInfo.put(key, value);
    }

    @Override
    public int getProtoIndex(int n) {
        if (n < 2) {
            return 0;
        }
        int protoIdx = 0;
        switch (this.protoChoice) {
            case First: {
                protoIdx = 0;
                break;
            }
            case Random: {
                Random r = new Random(System.currentTimeMillis());
                protoIdx = r.nextInt(n - 1);
                break;
            }
            case Run: 
            case Penultimate: {
                protoIdx = Math.max(n - 2, 0);
                break;
            }
            case Latest: {
                protoIdx = Math.max(n - 1, 0);
            }
        }
        return protoIdx;
    }

    private CalendarDate extractRunDateWithError(MFile mfile) {
        CalendarDate result = this.extractDate(mfile);
        if (result == null) {
            this.logger.error("Failed to extract date from file {} with Extractor {}", (Object)mfile.getPath(), (Object)this.dateExtractor);
        }
        return result;
    }

    protected List<MFile> makeFileListSorted() throws IOException {
        ArrayList<MFile> list = new ArrayList<MFile>(100);
        try (CloseableIterator<MFile> iter = this.getFileIterator();){
            while (iter.hasNext()) {
                list.add((MFile)iter.next());
            }
        }
        if (this.hasDateExtractor()) {
            Collections.sort(list, new DateSorter());
        } else {
            Collections.sort(list);
        }
        return list;
    }

    public class MyGribFilter
    implements DirectoryStream.Filter<Path> {
        @Override
        public boolean accept(Path entry) throws IOException {
            if (CollectionAbstract.this.sfilter != null && !CollectionAbstract.this.sfilter.accept(entry)) {
                return false;
            }
            String last = entry.getName(entry.getNameCount() - 1).toString();
            return !last.endsWith(".gbx9") && !last.endsWith(".gbx8") && !last.endsWith(".ncx") && !last.endsWith(CollectionAbstract.NCX_SUFFIX) && !last.endsWith(".xml");
        }
    }

    public class DateSorter
    implements Comparator<MFile> {
        @Override
        public int compare(MFile m1, MFile m2) {
            CalendarDate cd1 = CollectionAbstract.this.extractRunDateWithError(m1);
            CalendarDate cd2 = CollectionAbstract.this.extractRunDateWithError(m2);
            if (cd1 == null || cd2 == null) {
                cd1 = CollectionAbstract.this.extractRunDateWithError(m1);
                cd2 = CollectionAbstract.this.extractRunDateWithError(m2);
                throw new IllegalStateException();
            }
            return cd1.compareTo(cd2);
        }
    }
}

