/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import org.slf4j.Logger;
import thredds.filesystem.MFileOS7;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.MFile;
import ucar.nc2.util.CloseableIterator;

public class CollectionGeneral
extends CollectionAbstract {
    private Path rootPath;

    public CollectionGeneral(String collectionName, Path rootPath, Logger logger) {
        super(collectionName, logger);
        this.rootPath = rootPath;
        this.root = rootPath.toString();
    }

    @Override
    public void close() {
    }

    @Override
    public Iterable<MFile> getFilesSorted() throws IOException {
        return this.makeFileListSorted();
    }

    @Override
    public CloseableIterator<MFile> getFileIterator() throws IOException {
        return new MyFileIterator(this.rootPath);
    }

    private class MyFileIterator
    implements CloseableIterator<MFile> {
        DirectoryStream<Path> dirStream;
        Iterator<Path> dirStreamIterator;
        MFile nextMFile;

        MyFileIterator(Path dir) throws IOException {
            this.dirStream = Files.newDirectoryStream(dir, new CollectionAbstract.MyGribFilter());
            this.dirStreamIterator = this.dirStream.iterator();
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (!this.dirStreamIterator.hasNext()) {
                    return false;
                }
                try {
                    Path nextPath = this.dirStreamIterator.next();
                    BasicFileAttributes attr = Files.readAttributes(nextPath, BasicFileAttributes.class, new LinkOption[0]);
                    if (attr.isDirectory()) continue;
                    this.nextMFile = new MFileOS7(nextPath, attr);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (CollectionGeneral.this.filter == null || CollectionGeneral.this.filter.accept(this.nextMFile)) break;
            }
            return true;
        }

        @Override
        public MFile next() {
            return this.nextMFile;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            this.dirStream.close();
        }
    }
}

