/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.NestedPointFeatureCollection;
import ucar.nc2.ft.NestedPointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointIteratorFlatten;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;

public abstract class OneNestedPointCollectionImpl
implements NestedPointFeatureCollection {
    protected String name;
    protected DateUnit timeUnit;
    protected String altUnits;
    protected FeatureType collectionFeatureType;
    protected int npts;
    protected List<Variable> extras;

    protected OneNestedPointCollectionImpl(String name, DateUnit timeUnit, String altUnits, FeatureType collectionFeatureType) {
        this.name = name;
        this.timeUnit = timeUnit;
        this.altUnits = altUnits;
        this.collectionFeatureType = collectionFeatureType;
        this.npts = -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DateUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public String getAltUnits() {
        return this.altUnits;
    }

    @Override
    public List<Variable> getExtraVariables() {
        return this.extras == null ? new ArrayList() : this.extras;
    }

    @Override
    public int size() {
        return this.npts;
    }

    protected void setSize(int npts) {
        this.npts = npts;
    }

    @Override
    public boolean isMultipleNested() {
        return false;
    }

    @Override
    public FeatureType getCollectionFeatureType() {
        return this.collectionFeatureType;
    }

    @Override
    public NestedPointFeatureCollectionIterator getNestedPointFeatureCollectionIterator(int bufferSize) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " (single nested) PointFeatureCollection does not implement getNestedPointFeatureCollectionIterator()");
    }

    @Override
    public PointFeatureCollection flatten(LatLonRect boundingBox, DateRange dateRange) throws IOException {
        return this.flatten(boundingBox, CalendarDateRange.of(dateRange));
    }

    @Override
    public PointFeatureCollection flatten(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
        return new NestedPointFeatureCollectionFlatten(this, boundingBox, dateRange);
    }

    private class NestedPointFeatureCollectionFlatten
    extends PointCollectionImpl {
        protected OneNestedPointCollectionImpl from;
        protected LatLonRect boundingBox;

        NestedPointFeatureCollectionFlatten(OneNestedPointCollectionImpl from, LatLonRect filter_bb, CalendarDateRange filter_date) {
            super(from.getName(), from.getTimeUnit(), from.getAltUnits());
            this.from = from;
            this.boundingBox = filter_bb;
            this.dateRange = filter_date;
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            return new PointIteratorFlatten(this.from.getPointFeatureCollectionIterator(bufferSize), this.boundingBox, this.dateRange);
        }
    }
}

