/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.NestedPointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.OneNestedPointCollectionImpl;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.StationTimeSeriesCollectionFlattened;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public abstract class StationTimeSeriesCollectionImpl
extends OneNestedPointCollectionImpl
implements StationTimeSeriesFeatureCollection {
    protected StationHelper stationHelper;
    protected PointFeatureCollectionIterator localIterator;

    public StationTimeSeriesCollectionImpl(String name, DateUnit timeUnit, String altUnits) {
        super(name, timeUnit, altUnits, FeatureType.STATION);
    }

    protected abstract StationHelper initStationHelper();

    @Override
    public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
        this.initStationHelper();
        return new PointFeatureCollectionIterator(){
            Iterator<StationFeature> stationIter;
            {
                this.stationIter = StationTimeSeriesCollectionImpl.this.stationHelper.getStationFeatures().iterator();
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.stationIter.hasNext();
            }

            @Override
            public PointFeatureCollection next() throws IOException {
                return (StationTimeSeriesFeature)this.stationIter.next();
            }

            @Override
            public void setBufferSize(int bytes) {
            }

            @Override
            public void finish() {
            }
        };
    }

    @Override
    public StationTimeSeriesFeature getStationFeature(Station s) throws IOException {
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        return (StationTimeSeriesFeature)this.stationHelper.getStationFeature(s);
    }

    @Override
    public Station getStation(PointFeature feature) throws IOException {
        StationPointFeature stationFeature = (StationPointFeature)feature;
        return stationFeature.getStation();
    }

    @Override
    public List<StationFeature> getStationFeatures() throws IOException {
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        return this.stationHelper.getStationFeatures();
    }

    @Override
    public List<StationFeature> getStationFeatures(List<String> stnNames) {
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        return this.stationHelper.getStationFeaturesFromNames(stnNames);
    }

    @Override
    public List<StationFeature> getStationFeatures(LatLonRect boundingBox) throws IOException {
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        return this.stationHelper.getStationFeatures(boundingBox);
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(LatLonRect boundingBox) throws IOException {
        return this.subset(this.getStations(boundingBox));
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(List<Station> stations) throws IOException {
        if (stations == null) {
            return this;
        }
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        List<StationFeature> stationsFeatures = this.stationHelper.getStationFeatures(stations);
        return new StationTimeSeriesCollectionSubset(this, stationsFeatures);
    }

    @Override
    public StationTimeSeriesFeatureCollection subsetFeatures(List<StationFeature> stationsFeatures) throws IOException {
        return new StationTimeSeriesCollectionSubset(this, stationsFeatures);
    }

    @Override
    public PointFeatureCollection flatten(List<String> stationNames, CalendarDateRange dateRange, List<VariableSimpleIF> varList) throws IOException {
        if (stationNames == null || stationNames.size() == 0) {
            return new StationTimeSeriesCollectionFlattened(this, dateRange);
        }
        this.initStationHelper();
        List<StationFeature> subsetStations = this.stationHelper.getStationFeaturesFromNames(stationNames);
        return new StationTimeSeriesCollectionFlattened(new StationTimeSeriesCollectionSubset(this, subsetStations), dateRange);
    }

    @Override
    public PointFeatureCollection flatten(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
        if (boundingBox == null) {
            return new StationTimeSeriesCollectionFlattened(this, dateRange);
        }
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        List<StationFeature> subsetStations = this.stationHelper.getStationFeatures(boundingBox);
        return new StationTimeSeriesCollectionFlattened(new StationTimeSeriesCollectionSubset(this, subsetStations), dateRange);
    }

    @Override
    public PointFeatureCollection flatten(List<String> stations, DateRange dateRange, List<VariableSimpleIF> varList) throws IOException {
        return this.flatten(stations, CalendarDateRange.of(dateRange), varList);
    }

    @Override
    public List<Station> getStations() {
        if (this.stationHelper == null) {
            this.stationHelper = this.initStationHelper();
        }
        return this.stationHelper.getStations();
    }

    @Override
    public List<Station> getStations(List<String> stnNames) {
        if (this.stationHelper == null) {
            this.stationHelper = this.initStationHelper();
        }
        return this.stationHelper.getStations(stnNames);
    }

    @Override
    public List<Station> getStations(LatLonRect boundingBox) throws IOException {
        if (this.stationHelper == null) {
            this.stationHelper = this.initStationHelper();
        }
        return this.stationHelper.getStations(boundingBox);
    }

    @Override
    public Station getStation(String name) {
        if (this.stationHelper == null) {
            this.stationHelper = this.initStationHelper();
        }
        return this.stationHelper.getStation(name);
    }

    @Override
    public LatLonRect getBoundingBox() {
        if (this.stationHelper == null) {
            this.stationHelper = this.initStationHelper();
        }
        return this.stationHelper.getBoundingBox();
    }

    @Override
    public NestedPointFeatureCollectionIterator getNestedPointFeatureCollectionIterator(int bufferSize) throws IOException {
        throw new UnsupportedOperationException("StationFeatureCollection does not implement getNestedPointFeatureCollection()");
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public void finish() {
        if (this.localIterator != null) {
            this.localIterator.finish();
        }
    }

    @Override
    public StationTimeSeriesFeature next() throws IOException {
        return (StationTimeSeriesFeature)this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = this.getPointFeatureCollectionIterator(-1);
    }

    private class StationTimeSeriesCollectionSubset
    extends StationTimeSeriesCollectionImpl {
        StationTimeSeriesCollectionImpl from;

        StationTimeSeriesCollectionSubset(StationTimeSeriesCollectionImpl from, List<StationFeature> stations) {
            super(from.getName(), from.getTimeUnit(), from.getAltUnits());
            this.from = from;
            this.stationHelper = new StationHelper();
            this.stationHelper.setStations(stations);
        }

        @Override
        protected StationHelper initStationHelper() {
            return this.stationHelper;
        }

        @Override
        public List<StationFeature> getStationFeatures() throws IOException {
            return this.stationHelper.getStationFeatures();
        }
    }
}

