/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.point.standard.CoordSysEvaluator;
import ucar.nc2.ft.point.standard.Join;
import ucar.nc2.ft.point.standard.JoinArray;
import ucar.nc2.ft.point.standard.JoinMuiltdimStructure;
import ucar.nc2.ft.point.standard.JoinParentIndex;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.PointConfigXML;
import ucar.nc2.ft.point.standard.PointDatasetStandardFactory;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurer;
import ucar.nc2.ft.point.standard.plug.BuoyShipSynop;
import ucar.nc2.ft.point.standard.plug.CFpointObs;
import ucar.nc2.ft.point.standard.plug.CFpointObsExt;
import ucar.nc2.ft.point.standard.plug.CdmDirect;
import ucar.nc2.ft.point.standard.plug.Cosmic;
import ucar.nc2.ft.point.standard.plug.FslRaob;
import ucar.nc2.ft.point.standard.plug.FslWindProfiler;
import ucar.nc2.ft.point.standard.plug.GempakCdm;
import ucar.nc2.ft.point.standard.plug.Iridl;
import ucar.nc2.ft.point.standard.plug.Jason;
import ucar.nc2.ft.point.standard.plug.Madis;
import ucar.nc2.ft.point.standard.plug.MadisAcars;
import ucar.nc2.ft.point.standard.plug.NdbcCoards;
import ucar.nc2.ft.point.standard.plug.Nldn;
import ucar.nc2.ft.point.standard.plug.RafNimbus;
import ucar.nc2.ft.point.standard.plug.Suomi;
import ucar.nc2.ft.point.standard.plug.UnidataPointObs;

public class TableAnalyzer {
    private static Logger log = LoggerFactory.getLogger(TableAnalyzer.class);
    private static final List<Configurator> conventionList = new ArrayList<Configurator>();
    private static boolean userMode = false;
    private static final boolean debug = false;
    private TableConfigurer tc;
    private NetcdfDataset ds;
    private Map<String, TableConfig> tableFind = new HashMap<String, TableConfig>();
    private Set<TableConfig> tableSet = new HashSet<TableConfig>();
    private List<NestedTable> leaves = new ArrayList<NestedTable>();
    private FeatureType ft;
    private TableConfig configResult;
    private Formatter userAdvice = new Formatter();
    private Formatter errlog = new Formatter();
    private String conventionName;

    public static void registerAnalyzer(String conventionName, Class c, ConventionNameOk match) {
        TableConfigurer tc;
        if (!TableConfigurer.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c.getName() + " must implement TableConfigurer");
        }
        try {
            tc = (TableConfigurer)c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("TableConfigurer Class " + c.getName() + " cannot instantiate, probably need default Constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("TableConfigurer Class " + c.getName() + " is not accessible");
        }
        Configurator anal = new Configurator(conventionName, c, tc, match);
        if (userMode) {
            conventionList.add(0, anal);
        } else {
            conventionList.add(anal);
        }
    }

    private static Configurator matchConfigurator(String convName) {
        for (Configurator anal : conventionList) {
            if (anal.match == null && anal.convName.equalsIgnoreCase(convName)) {
                return anal;
            }
            if (anal.match == null || !anal.match.isMatch(convName, anal.convName)) continue;
            return anal;
        }
        return null;
    }

    public static TableConfigurer getTableConfigurer(FeatureType wantFeatureType, NetcdfDataset ds) throws IOException {
        String convUsed = null;
        String convName = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (convName == null) {
            convName = ds.findAttValueIgnoreCase(null, "Convention", null);
        }
        Configurator anal = null;
        if (convName != null) {
            anal = TableAnalyzer.matchConfigurator(convName = convName.trim());
            if (anal != null) {
                convUsed = convName;
            }
            if (anal == null) {
                String name;
                StringTokenizer stoke;
                ArrayList<String> names = new ArrayList<String>();
                if (convName.indexOf(44) > 0 || convName.indexOf(59) > 0) {
                    stoke = new StringTokenizer(convName, ",;");
                    while (stoke.hasMoreTokens()) {
                        name = stoke.nextToken();
                        names.add(name.trim());
                    }
                } else if (convName.indexOf(47) > 0) {
                    stoke = new StringTokenizer(convName, "/");
                    while (stoke.hasMoreTokens()) {
                        name = stoke.nextToken();
                        names.add(name.trim());
                    }
                }
                if (names.size() > 0) {
                    for (Configurator conv : conventionList) {
                        for (String name2 : names) {
                            if (!name2.equalsIgnoreCase(conv.convName)) continue;
                            anal = conv;
                            convUsed = name2;
                        }
                        if (anal == null) continue;
                        break;
                    }
                }
            }
        }
        if (anal == null) {
            for (Configurator conv : conventionList) {
                Method isMineMethod;
                Class c = conv.confClass;
                try {
                    isMineMethod = c.getMethod("isMine", FeatureType.class, NetcdfDataset.class);
                }
                catch (NoSuchMethodException ex) {
                    continue;
                }
                try {
                    Boolean result = (Boolean)isMineMethod.invoke((Object)conv.confInstance, new Object[]{wantFeatureType, ds});
                    if (!result.booleanValue()) continue;
                    anal = conv;
                    convUsed = conv.convName;
                    break;
                }
                catch (Exception ex) {
                    System.out.println("ERROR: Class " + c.getName() + " Exception invoking isMine method%n" + ex);
                }
            }
        }
        TableConfigurer tc = null;
        if (anal != null) {
            try {
                tc = (TableConfigurer)anal.confClass.newInstance();
                tc.setConvName(convName);
                tc.setConvUsed(convUsed);
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.error("TableConfigurer create failed", (Throwable)e);
            }
        }
        return tc;
    }

    public static TableAnalyzer factory(TableConfigurer tc, FeatureType wantFeatureType, NetcdfDataset ds) throws IOException {
        TableAnalyzer analyzer = new TableAnalyzer(ds, tc);
        if (tc != null) {
            if (tc.getConvName() == null) {
                analyzer.userAdvice.format(" No 'Conventions' global attribute.%n", new Object[0]);
            } else {
                analyzer.userAdvice.format(" Conventions global attribute = %s %n", tc.getConvName());
            }
            if (tc.getConvUsed() != null) {
                analyzer.setConventionUsed(tc.getConvUsed());
                if (!tc.getConvUsed().equals(tc.getConvName())) {
                    analyzer.userAdvice.format(" TableConfigurer used = " + tc.getConvUsed() + ".%n", new Object[0]);
                }
            }
        } else {
            analyzer.userAdvice.format(" No TableConfigurer found, using default analysis.%n", new Object[0]);
        }
        analyzer.analyze(wantFeatureType);
        return analyzer;
    }

    private TableAnalyzer(NetcdfDataset ds, TableConfigurer tc) {
        this.tc = tc;
        this.ds = ds;
        if (tc == null) {
            this.userAdvice.format("Using default TableConfigurer.%n", new Object[0]);
        }
    }

    public List<NestedTable> getFlatTables() {
        return this.leaves;
    }

    public boolean featureTypeOk(FeatureType ftype, Formatter errlog) {
        for (NestedTable nt : this.leaves) {
            if (!nt.hasCoords()) {
                errlog.format("Table %s featureType %s: lat/lon/time coord not found%n", new Object[]{nt.getName(), nt.getFeatureType()});
            }
            if (!FeatureDatasetFactoryManager.featureTypeOk(ftype, nt.getFeatureType())) {
                errlog.format("Table %s featureType %s doesnt match desired type %s%n", new Object[]{nt.getName(), nt.getFeatureType(), ftype});
            }
            if (!nt.hasCoords() || !FeatureDatasetFactoryManager.featureTypeOk(ftype, nt.getFeatureType())) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        if (this.tc != null) {
            return this.tc.getClass().getName();
        }
        return "Default";
    }

    public FeatureType getFirstFeatureType() {
        for (NestedTable nt : this.leaves) {
            if (!nt.hasCoords()) continue;
            return nt.getFeatureType();
        }
        return null;
    }

    public NetcdfDataset getNetcdfDataset() {
        return this.ds;
    }

    public String getUserAdvice() {
        return this.userAdvice.toString();
    }

    public String getErrlog() {
        return this.errlog.toString();
    }

    private void setConventionUsed(String convName) {
        this.conventionName = convName;
    }

    TableConfig getTableConfig() {
        return this.configResult;
    }

    TableConfigurer getTableConfigurer() {
        return this.tc;
    }

    private void analyze(FeatureType wantFeatureType) throws IOException {
        boolean structAdded = (Boolean)this.ds.sendIospMessage("AddRecordStructure");
        if (this.tc == null) {
            this.makeTablesDefault(structAdded);
            this.makeNestedTables();
        } else {
            this.configResult = this.tc.getConfig(wantFeatureType, this.ds, this.errlog);
            if (this.configResult != null) {
                this.addTableRecurse(this.configResult);
            } else {
                this.makeTablesDefault(structAdded);
                this.makeNestedTables();
            }
        }
        for (TableConfig config : this.tableSet) {
            if (config.children != null) continue;
            NestedTable flatTable = new NestedTable(this.ds, config, this.errlog);
            this.leaves.add(flatTable);
        }
        if (PointDatasetStandardFactory.showTables) {
            this.getDetailInfo(new Formatter(System.out));
        }
    }

    private void addTable(TableConfig t) {
        this.tableFind.put(t.name, t);
        if (t.dimName != null) {
            this.tableFind.put(t.dimName, t);
        }
        this.tableSet.add(t);
    }

    private void addTableRecurse(TableConfig t) {
        this.addTable(t);
        if (t.children != null) {
            for (TableConfig child : t.children) {
                this.addTableRecurse(child);
            }
        }
    }

    private void makeTablesDefault(boolean structAdded) throws IOException {
        ArrayList<Variable> vars = new ArrayList<Variable>(this.ds.getVariables());
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            Variable v = (Variable)iter.next();
            if (v instanceof Structure) {
                TableConfig st = new TableConfig(Table.Type.Structure, v.getFullName());
                CoordSysEvaluator.findCoords(st, this.ds, null);
                st.structName = v.getFullName();
                st.nestedTableName = v.getShortName();
                this.addTable(st);
                this.checkIfTrajectory(st);
                iter.remove();
                this.findNestedStructures((Structure)v, st);
                continue;
            }
            if (!structAdded || !v.isUnlimited()) continue;
            iter.remove();
        }
        if (this.tableSet.size() > 0) {
            return;
        }
        HashSet<Dimension> dimSet = new HashSet<Dimension>(10);
        for (CoordinateAxis axis : this.ds.getCoordinateAxes()) {
            if (axis.getAxisType() != AxisType.Lat && axis.getAxisType() != AxisType.Lon && axis.getAxisType() != AxisType.Time) continue;
            for (Dimension dim : axis.getDimensions()) {
                dimSet.add(dim);
            }
        }
        if (dimSet.size() == 1) {
            final Dimension obsDim = (Dimension)dimSet.toArray()[0];
            TableConfig st = new TableConfig(Table.Type.Structure, obsDim.getShortName());
            st.structureType = obsDim.isUnlimited() ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
            st.structName = obsDim.isUnlimited() ? "record" : obsDim.getShortName();
            st.dimName = obsDim.getShortName();
            CoordSysEvaluator.findCoords(st, this.ds, new CoordSysEvaluator.Predicate(){

                @Override
                public boolean match(CoordinateAxis axis) {
                    return obsDim.equals(axis.getDimension(0));
                }
            });
            CoordinateAxis time = CoordSysEvaluator.findCoordByType(this.ds, AxisType.Time);
            if (time != null && time.getRank() == 0) {
                st.addJoin(new JoinArray(time, JoinArray.Type.scalar, 0));
                st.time = time.getShortName();
            }
            this.addTable(st);
            this.checkIfTrajectory(st);
        }
        if (this.tableSet.size() > 0) {
            return;
        }
        Variable time = null;
        for (CoordinateAxis axis : this.ds.getCoordinateAxes()) {
            if (axis.getAxisType() != AxisType.Time || !axis.isCoordinateVariable()) continue;
            time = axis;
            break;
        }
        if (time != null) {
            Dimension obsDim = time.getDimension(0);
            TableConfig st = new TableConfig(Table.Type.Structure, obsDim.getShortName());
            st.structureType = TableConfig.StructureType.PsuedoStructure;
            st.dimName = obsDim.getShortName();
            CoordSysEvaluator.findCoords(st, this.ds, null);
            this.addTable(st);
        }
    }

    private void checkIfTrajectory(TableConfig st) {
        FeatureType ft = FeatureDatasetFactoryManager.findFeatureType(this.ds);
        if (ft == FeatureType.TRAJECTORY) {
            TableConfig pc;
            st.featureType = FeatureType.TRAJECTORY;
            st.parent = pc = new TableConfig(Table.Type.Top, "single");
            pc.addChild(st);
        } else {
            st.featureType = FeatureType.POINT;
        }
    }

    private void findNestedStructures(Structure s, TableConfig parent) {
        for (Variable v : s.getVariables()) {
            if (!(v instanceof Structure)) continue;
            TableConfig nestedTable = new TableConfig(Table.Type.NestedStructure, v.getFullName());
            nestedTable.structName = v.getFullName();
            nestedTable.nestedTableName = v.getShortName();
            this.addTable(nestedTable);
            parent.addChild(nestedTable);
            this.findNestedStructures((Structure)v, nestedTable);
        }
    }

    private void makeNestedTables() {
    }

    public void showNestedTables(Formatter sf) {
        for (NestedTable nt : this.leaves) {
            nt.show(sf);
        }
    }

    public String getImplementationName() {
        return this.tc != null ? this.tc.getClass().getSimpleName() : "defaultAnalyser";
    }

    public void getDetailInfo(Formatter sf) {
        String userAdviceS;
        sf.format("-----------------------------------------------------%nTableAnalyzer on Dataset %s%n", this.ds.getLocation());
        if (this.tc != null) {
            sf.format(" TableAnalyser = %s%n", this.tc.getClass().getName());
        }
        this.showNestedTables(sf);
        String errlogS = this.errlog.toString();
        if (errlogS.length() > 0) {
            sf.format("%n Errlog=%n%s", errlogS);
        }
        if ((userAdviceS = this.userAdvice.toString()).length() > 0) {
            sf.format("%n userAdvice=%n%s%n", userAdviceS);
        }
        try {
            this.writeConfigXML(sf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeConfigXML(Formatter sf) throws IOException {
        if (this.configResult != null) {
            PointConfigXML tcx = new PointConfigXML();
            tcx.writeConfigXML(this.configResult, this.tc.getClass().getName(), sf);
            return;
        }
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        sf.format("%s", fmt.outputString(this.makeDocument()));
    }

    private Document makeDocument() {
        Element rootElem = new Element("featureDataset");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("location", this.ds.getLocation());
        if (this.tc != null) {
            rootElem.addContent((Content)new Element("analyser").setAttribute("class", this.tc.getClass().getName()));
        }
        if (this.ft != null) {
            rootElem.setAttribute("featureType", this.ft.toString());
        }
        for (NestedTable nt : this.leaves) {
            this.writeTable(rootElem, nt.getLeaf());
        }
        return doc;
    }

    private Element writeTable(Element parent, Table table) {
        if (table.parent != null) {
            parent = this.writeTable(parent, table.parent);
        }
        Element tableElem = new Element("table");
        parent.addContent((Content)tableElem);
        if (table.getName() != null) {
            tableElem.setAttribute("name", table.getName());
        }
        if (table.getFeatureType() != null) {
            tableElem.setAttribute("featureType", table.getFeatureType().toString());
        }
        tableElem.setAttribute("class", table.getClass().toString());
        this.addCoordinates(tableElem, table);
        for (String colName : table.cols.keySet()) {
            if (table.nondataVars.contains(colName)) continue;
            tableElem.addContent((Content)new Element("variable").addContent(colName));
        }
        if (table.extraJoins != null) {
            for (Join j : table.extraJoins) {
                if (j instanceof JoinArray) {
                    tableElem.addContent((Content)this.writeJoinArray((JoinArray)j));
                    continue;
                }
                if (j instanceof JoinMuiltdimStructure) {
                    tableElem.addContent((Content)this.writeJoinMuiltdimStructure((JoinMuiltdimStructure)j));
                    continue;
                }
                if (!(j instanceof JoinParentIndex)) continue;
                tableElem.addContent((Content)this.writeJoinParentIndex((JoinParentIndex)j));
            }
        }
        return tableElem;
    }

    private void addCoordinates(Element tableElem, Table table) {
        this.addCoord(tableElem, table.lat, "lat");
        this.addCoord(tableElem, table.lon, "lon");
        this.addCoord(tableElem, table.elev, "elev");
        this.addCoord(tableElem, table.time, "time");
        this.addCoord(tableElem, table.timeNominal, "timeNominal");
        this.addCoord(tableElem, table.stnId, "stnId");
        this.addCoord(tableElem, table.stnDesc, "stnDesc");
        this.addCoord(tableElem, table.stnNpts, "stnNpts");
        this.addCoord(tableElem, table.stnWmoId, "stnWmoId");
        this.addCoord(tableElem, table.stnAlt, "stnAlt");
        this.addCoord(tableElem, table.limit, "limit");
    }

    private void addCoord(Element tableElem, String name, String kind) {
        if (name != null) {
            Element elem = new Element("coordinate").setAttribute("kind", kind);
            elem.addContent(name);
            tableElem.addContent((Content)elem);
        }
    }

    private Element writeJoinArray(JoinArray join) {
        Element joinElem = new Element("join");
        joinElem.setAttribute("class", join.getClass().toString());
        if (join.type != null) {
            joinElem.setAttribute("type", join.type.toString());
        }
        if (join.v != null) {
            joinElem.addContent((Content)new Element("variable").setAttribute("name", join.v.getFullName()));
        }
        joinElem.addContent((Content)new Element("param").setAttribute("value", Integer.toString(join.param)));
        return joinElem;
    }

    private Element writeJoinMuiltdimStructure(JoinMuiltdimStructure join) {
        Element joinElem = new Element("join");
        joinElem.setAttribute("class", join.getClass().toString());
        if (join.parentStructure != null) {
            joinElem.addContent((Content)new Element("parentStructure").setAttribute("name", join.parentStructure.getFullName()));
        }
        joinElem.addContent((Content)new Element("dimLength").setAttribute("value", Integer.toString(join.dimLength)));
        return joinElem;
    }

    private Element writeJoinParentIndex(JoinParentIndex join) {
        Element joinElem = new Element("join");
        joinElem.setAttribute("class", join.getClass().toString());
        if (join.parentStructure != null) {
            joinElem.addContent((Content)new Element("parentStructure").setAttribute("name", join.parentStructure.getFullName()));
        }
        if (join.parentIndex != null) {
            joinElem.addContent((Content)new Element("parentIndex").setAttribute("name", join.parentIndex));
        }
        return joinElem;
    }

    static void doit(String filename) throws IOException {
        System.out.println(filename);
        NetcdfDataset ncd = NetcdfDataset.openDataset(filename);
        TableAnalyzer csa = TableAnalyzer.factory(null, null, ncd);
        csa.getDetailInfo(new Formatter(System.out));
        System.out.println("%n-----------------");
    }

    public static void main(String[] args) throws IOException {
        TableAnalyzer.doit("D:/datasets/metars/Surface_METAR_20070513_0000.nc");
    }

    static {
        TableAnalyzer.registerAnalyzer("CDM", CdmDirect.class, null);
        TableAnalyzer.registerAnalyzer("CDM-Extended-CF", CFpointObsExt.class, null);
        TableAnalyzer.registerAnalyzer("CF-1.", CFpointObs.class, new ConventionNameOk(){

            @Override
            public boolean isMatch(String convName, String wantName) {
                return convName.startsWith(wantName);
            }
        });
        TableAnalyzer.registerAnalyzer("GEMPAK/CDM", GempakCdm.class, null);
        TableAnalyzer.registerAnalyzer("Unidata Observation Dataset v1.0", UnidataPointObs.class, null);
        TableAnalyzer.registerAnalyzer("Cosmic", Cosmic.class, null);
        TableAnalyzer.registerAnalyzer("Jason", Jason.class, null);
        TableAnalyzer.registerAnalyzer("FslWindProfiler", FslWindProfiler.class, null);
        TableAnalyzer.registerAnalyzer("MADIS-ACARS", MadisAcars.class, null);
        TableAnalyzer.registerAnalyzer("MADIS surface observations, v1.0", Madis.class, null);
        TableAnalyzer.registerAnalyzer("FSL Raobs", FslRaob.class, null);
        TableAnalyzer.registerAnalyzer("IRIDL", Iridl.class, null);
        TableAnalyzer.registerAnalyzer("Ndbc", NdbcCoards.class, null);
        TableAnalyzer.registerAnalyzer("Suomi-Station-CDM", Suomi.class, null);
        TableAnalyzer.registerAnalyzer("BuoyShip-NetCDF", BuoyShipSynop.class, null);
        TableAnalyzer.registerAnalyzer("NCAR-RAF/nimbus", RafNimbus.class, null);
        TableAnalyzer.registerAnalyzer("NLDN-CDM", Nldn.class, null);
        userMode = true;
    }

    private static class Configurator {
        String convName;
        Class confClass;
        TableConfigurer confInstance;
        ConventionNameOk match;

        Configurator(String convName, Class confClass, TableConfigurer confInstance, ConventionNameOk match) {
            this.convName = convName;
            this.confClass = confClass;
            this.confInstance = confInstance;
            this.match = match;
        }
    }

    private static interface ConventionNameOk {
        public boolean isMatch(String var1, String var2);
    }
}

