/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.geotiff;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.geotiff.GeotiffWriter;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;

public class GeoTiffWriter2
extends GeotiffWriter {
    public GeoTiffWriter2(String fileOut) {
        super(fileOut);
    }

    public void writeGrid(String gridDataset_filename, String gridName, int time, int level, boolean greyScale, LatLonRect pt) throws IOException {
        try (GridDataset dataset = GridDataset.open(gridDataset_filename);){
            int y2;
            int x2;
            double xStart;
            double yStart;
            int y1;
            int x1;
            GridDatatype grid = dataset.findGridDatatype(gridName);
            if (grid == null) {
                throw new IllegalArgumentException("No grid named " + gridName + " in fileName");
            }
            GridCoordSystem gcs = grid.getCoordinateSystem();
            ProjectionImpl proj = grid.getProjection();
            if (!gcs.isRegularSpatial()) {
                Attribute att = dataset.findGlobalAttributeIgnoreCase("datasetId");
                if (att != null && att.getStringValue().contains("DMSP")) {
                    this.writeSwathGrid(gridDataset_filename, gridName, time, level, greyScale, pt);
                    return;
                }
                throw new IllegalArgumentException("Must have 1D x and y axes for " + grid.getFullName());
            }
            CoordinateAxis1D xaxis = (CoordinateAxis1D)gcs.getXHorizAxis();
            CoordinateAxis1D yaxis = (CoordinateAxis1D)gcs.getYHorizAxis();
            if (!xaxis.isRegular() || !yaxis.isRegular()) {
                throw new IllegalArgumentException("Must be evenly spaced grid = " + grid.getFullName());
            }
            Array data = grid.readDataSlice(time, level, -1, -1);
            Array lon = xaxis.read();
            Array lat = yaxis.read();
            double scaler = gcs.isLatLon() ? 1.0 : 1000.0;
            if (yaxis.getCoordValue(0) < yaxis.getCoordValue(1)) {
                data = data.flip(0);
                lat = lat.flip(0);
            }
            if (gcs.isLatLon()) {
                data = this.geoShiftDataAtLon(data, lon);
                lon = this.geoShiftLon(lon);
            }
            LatLonPointImpl llp0 = pt.getLowerLeftPoint();
            LatLonPointImpl llpn = pt.getUpperRightPoint();
            double minLon = llp0.getLongitude();
            double minLat = llp0.getLatitude();
            double maxLon = llpn.getLongitude();
            double maxLat = llpn.getLatitude();
            if (!gcs.isLatLon()) {
                ProjectionPointImpl pjp0 = proj.latLonToProj(maxLat, minLon);
                double[] lonArray = (double[])lon.copyTo1DJavaArray();
                double[] latArray = (double[])lat.copyTo1DJavaArray();
                x1 = this.getXIndex(lon, pjp0.getX(), 0);
                y1 = this.getYIndex(lat, pjp0.getY(), 0);
                yStart = pjp0.getY() * 1000.0;
                xStart = pjp0.getX() * 1000.0;
                ProjectionPointImpl pjpn = proj.latLonToProj(minLat, maxLon);
                x2 = this.getXIndex(lon, pjpn.getX(), 1);
                y2 = this.getYIndex(lat, pjpn.getY(), 1);
            } else {
                xStart = minLon;
                yStart = maxLat;
                x1 = this.getLonIndex(lon, minLon, 0);
                y1 = this.getLatIndex(lat, maxLat, 0);
                x2 = this.getLonIndex(lon, maxLon, 1);
                y2 = this.getLatIndex(lat, minLat, 1);
            }
            double xInc = xaxis.getIncrement() * scaler;
            double yInc = Math.abs(yaxis.getIncrement()) * scaler;
            Array data1 = this.getYXDataInBox(data, x1, x2, y1, y2);
            if (this.pageNumber > 1) {
                this.geotiff.initTags();
            }
            this.writeGrid(grid, data1, greyScale, xStart, yStart, xInc, yInc, this.pageNumber);
            this.pageNumber = (short)(this.pageNumber + 1);
        }
    }

    void writeSwathGrid(String fileName, String gridName, int time, int level, boolean greyScale, LatLonRect llr) throws IOException {
        int y2;
        int x2;
        int y1;
        int x1;
        double yStart;
        double xStart;
        double maxLat;
        double maxLon;
        double minLat;
        double minLon;
        GridDataset dataset = GridDataset.open(fileName);
        GridDatatype grid = dataset.findGridDatatype(gridName);
        GridCoordSystem gcs = grid.getCoordinateSystem();
        ProjectionImpl proj = grid.getProjection();
        CoordinateAxis2D xaxis = (CoordinateAxis2D)gcs.getXHorizAxis();
        CoordinateAxis2D yaxis = (CoordinateAxis2D)gcs.getYHorizAxis();
        Array data = grid.readDataSlice(time, level, -1, -1);
        Array lon = xaxis.read();
        Array lat = yaxis.read();
        double[] swathInfo = this.getSwathLatLonInformation(lat, lon);
        double scaler = gcs.isLatLon() ? 1.0 : 1000.0;
        data = data.flip(0);
        if (gcs.isLatLon()) {
            data = this.geoShiftDataAtLon(data, lon);
            lon = this.geoShiftLon(lon);
        }
        double xInc = swathInfo[0] * scaler;
        double yInc = swathInfo[1] * scaler;
        if (llr == null) {
            minLon = swathInfo[4];
            minLat = swathInfo[2];
            maxLon = swathInfo[5];
            maxLat = swathInfo[3];
            xStart = minLon;
            yStart = maxLat;
            x1 = 0;
            y1 = 0;
            x2 = (int)((maxLon - minLon) / xInc + 0.5);
            y2 = (int)((maxLat - minLat) / yInc + 0.5);
        } else {
            LatLonPointImpl llp0 = llr.getLowerLeftPoint();
            LatLonPointImpl llpn = llr.getUpperRightPoint();
            minLon = llp0.getLongitude() < swathInfo[4] ? swathInfo[4] : llp0.getLongitude();
            minLat = llp0.getLatitude() < swathInfo[2] ? swathInfo[2] : llp0.getLatitude();
            maxLon = llpn.getLongitude() > swathInfo[5] ? swathInfo[5] : llpn.getLongitude();
            maxLat = llpn.getLatitude() > swathInfo[3] ? swathInfo[3] : llpn.getLatitude();
            LatLonPointImpl pUpLeft = new LatLonPointImpl(swathInfo[3], swathInfo[4]);
            LatLonPointImpl pDownRight = new LatLonPointImpl(swathInfo[2], swathInfo[5]);
            LatLonRect swathLLR = new LatLonRect(pUpLeft, pDownRight);
            LatLonRect bIntersect = swathLLR.intersect(llr);
            if (bIntersect == null) {
                throw new IllegalArgumentException("The assigned extent of latitude and longitude is unvalid. No intersection with the swath extent");
            }
            xStart = minLon;
            yStart = maxLat;
            x1 = (int)((minLon - swathInfo[4]) / xInc + 0.5);
            y1 = (int)Math.abs((maxLat - swathInfo[3]) / yInc + 0.5);
            x2 = (int)((maxLon - swathInfo[4]) / xInc + 0.5);
            y2 = (int)Math.abs((minLat - swathInfo[3]) / yInc + 0.5);
        }
        if (!gcs.isLatLon()) {
            ProjectionPointImpl pjp0 = proj.latLonToProj(maxLat, minLon);
            x1 = this.getXIndex(lon, pjp0.getX(), 0);
            y1 = this.getYIndex(lat, pjp0.getY(), 0);
            yStart = pjp0.getY() * 1000.0;
            xStart = pjp0.getX() * 1000.0;
            ProjectionPointImpl pjpn = proj.latLonToProj(minLat, maxLon);
            x2 = this.getXIndex(lon, pjpn.getX(), 1);
            y2 = this.getYIndex(lat, pjpn.getY(), 1);
        }
        Array targetImage = this.getTargetImagerFromSwath(lat, lon, data, swathInfo);
        Array interpolatedImage = this.interpolation(targetImage);
        Array clippedImage = this.getClippedImageFromInterpolation(interpolatedImage, x1, x2, y1, y2);
        if (this.pageNumber > 1) {
            this.geotiff.initTags();
        }
        this.writeGrid(grid, clippedImage, greyScale, xStart, yStart, xInc, yInc, this.pageNumber);
        this.pageNumber = (short)(this.pageNumber + 1);
    }

    int getXIndex(Array aAxis, double value, int side) {
        IndexIterator aIter = aAxis.getIndexIterator();
        int count = 0;
        boolean isInd = false;
        double aValue = aIter.getFloatNext();
        if (aValue == value || aValue > value) {
            return 0;
        }
        while (aIter.hasNext() && aValue < value) {
            ++count;
            aValue = aIter.getFloatNext();
            if (aValue != value) continue;
            isInd = true;
        }
        if (isInd) {
            count += side;
        }
        return count -= side;
    }

    int getYIndex(Array aAxis, double value, int side) {
        IndexIterator aIter = aAxis.getIndexIterator();
        int count = 0;
        boolean isInd = false;
        double aValue = aIter.getFloatNext();
        if (aValue == value || aValue < value) {
            return 0;
        }
        while (aIter.hasNext() && aValue > value) {
            ++count;
            aValue = aIter.getFloatNext();
            if (aValue != value) continue;
            isInd = true;
        }
        if (isInd) {
            count += side;
        }
        return count -= side;
    }

    int getLatIndex(Array lat, double value, int side) {
        int[] shape = lat.getShape();
        IndexIterator latIter = lat.getIndexIterator();
        Index ind = lat.getIndex();
        int count = 0;
        boolean isInd = false;
        double xlat = latIter.getFloatNext();
        if (xlat == value) {
            return 0;
        }
        while (latIter.hasNext() && xlat > value) {
            ++count;
            xlat = latIter.getFloatNext();
            if (xlat != value) continue;
            isInd = true;
        }
        if (isInd) {
            count += side;
        }
        return count -= side;
    }

    int getLonIndex(Array lon, double value, int side) {
        int[] shape = lon.getShape();
        IndexIterator lonIter = lon.getIndexIterator();
        Index ind = lon.getIndex();
        int count = 0;
        boolean isInd = false;
        float xlon = lonIter.getFloatNext();
        if (xlon > 180.0f) {
            xlon -= 360.0f;
        }
        if ((double)xlon == value) {
            return 0;
        }
        while (lonIter.hasNext() && (double)xlon < value) {
            ++count;
            xlon = lonIter.getFloatNext();
            if (xlon > 180.0f) {
                xlon -= 360.0f;
            }
            if ((double)xlon != value) continue;
            isInd = true;
        }
        if (isInd) {
            count += side;
        }
        return count -= side;
    }

    Array getYXDataInBox(Array data, int x1, int x2, int y1, int y2) throws IOException {
        Array dataVolume;
        int rank = data.getRank();
        int[] start = new int[rank];
        int[] shape = new int[rank];
        for (int i = 0; i < rank; ++i) {
            start[i] = 0;
            shape[i] = 1;
        }
        if (y1 >= 0 && y2 >= 0) {
            start[0] = y1;
            shape[0] = y2 - y1;
        }
        if (x1 >= 0 && x2 >= 0) {
            start[1] = x1;
            shape[1] = x2 - x1;
        }
        try {
            dataVolume = data.section(start, shape);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return dataVolume;
    }

    Array getClippedImageFromInterpolation(Array arr, int x1, int x2, int y1, int y2) {
        int[] srcShape = arr.getShape();
        int rank = arr.getRank();
        int[] start = new int[rank];
        int[] shape = new int[rank];
        for (int i = 0; i < rank; ++i) {
            start[i] = 0;
            shape[i] = 1;
        }
        if (y1 >= 0 && y2 >= 0) {
            start[0] = y1;
            shape[0] = y2 - y1;
        }
        if (x1 >= 0 && x2 >= 0) {
            start[1] = x1;
            shape[1] = x2 - x1;
        }
        Array dataVolume = Array.factory(DataType.FLOAT, shape);
        int count = 0;
        for (int i = y1; i < y2; ++i) {
            for (int j = x1; j < x2; ++j) {
                int index = i * srcShape[1] + j;
                if (index >= srcShape[0] * srcShape[1]) {
                    index = srcShape[0] * srcShape[1] - 1;
                }
                float curValue = arr.getFloat(index);
                if (count >= shape[0] * shape[1]) {
                    count = shape[0] * shape[1] - 1;
                }
                dataVolume.setFloat(count, curValue);
                ++count;
            }
        }
        return dataVolume;
    }

    Array getTargetImagerFromSwath(Array lat, Array lon, Array data, double[] swathInfo) {
        int srcDataHeight = data.getShape()[0];
        int srcDataWidth = data.getShape()[1];
        int BBoxHeight = (int)((swathInfo[3] - swathInfo[2]) / swathInfo[1] + 0.5);
        int BBoxWidth = (int)((swathInfo[5] - swathInfo[4]) / swathInfo[0] + 0.5);
        int[] BBoxShape = new int[]{BBoxHeight, BBoxWidth};
        Array bBoxArray = Array.factory(DataType.FLOAT, BBoxShape);
        double startLon = swathInfo[4];
        double startLat = swathInfo[3];
        IndexIterator dataIter = data.getIndexIterator();
        IndexIterator latIter = lat.getIndexIterator();
        IndexIterator lonIter = lon.getIndexIterator();
        for (int i = 0; i < srcDataHeight; ++i) {
            for (int j = 0; j < srcDataWidth; ++j) {
                while (latIter.hasNext() && lonIter.hasNext() && dataIter.hasNext()) {
                    float curLat = latIter.getFloatNext();
                    float curLon = lonIter.getFloatNext();
                    float curPix = dataIter.getFloatNext();
                    float alreadyValue = 0.0f;
                    int curPixelInBBoxIndex = this.getIndexOfBBFromLatlonOfOri(startLat, startLon, swathInfo[1], swathInfo[0], curLat, curLon, BBoxHeight, BBoxWidth);
                    try {
                        alreadyValue = bBoxArray.getFloat(curPixelInBBoxIndex);
                    }
                    catch (Exception e) {
                        alreadyValue = 0.0f;
                    }
                    if (alreadyValue > 0.0f) {
                        bBoxArray.setFloat(curPixelInBBoxIndex, (curPix + alreadyValue) / 2.0f);
                        continue;
                    }
                    bBoxArray.setFloat(curPixelInBBoxIndex, curPix);
                }
            }
        }
        return bBoxArray;
    }

    int getIndexOfBBFromLatlonOfOri(double sLat, double sLon, double latInc, double lonInc, double curLat, double curLon, int bbHeight, int bbWidth) {
        int col;
        int index;
        double lonDelta = Math.abs((curLon - sLon) / lonInc);
        double latDelta = Math.abs((curLat - sLat) / latInc);
        int row = (int)(lonDelta + 0.5);
        if (row >= bbWidth - 1) {
            row = bbWidth - 2;
        }
        if (row == 0) {
            row = 1;
        }
        if ((index = (col = (int)(latDelta + 0.5)) * bbWidth + row) >= bbHeight * bbWidth) {
            index = (col - 1) * bbWidth + row;
        }
        return index;
    }

    Array interpolation(Array arr) {
        int[] orishape = arr.getShape();
        int width = orishape[1];
        int height = orishape[0];
        int pixelNum = width * height;
        Array interpolatedArray = Array.factory(DataType.FLOAT, orishape);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int curIndex = i * width + j;
                float curValue = arr.getFloat(curIndex);
                if (curValue == 0.0f) {
                    float tempPixelSum = 0.0f;
                    int numNeighborHasValue = 0;
                    float left = 0.0f;
                    float right = 0.0f;
                    float up = 0.0f;
                    float down = 0.0f;
                    float upleft = 0.0f;
                    float upright = 0.0f;
                    float downleft = 0.0f;
                    float downright = 0.0f;
                    if (curIndex - 1 >= 0 && curIndex - 1 < pixelNum && (left = arr.getFloat(curIndex - 1)) > 0.0f) {
                        tempPixelSum += left;
                        ++numNeighborHasValue;
                    }
                    if (curIndex + 1 >= 0 && curIndex + 1 < pixelNum && (right = arr.getFloat(curIndex + 1)) > 0.0f) {
                        tempPixelSum += right;
                        ++numNeighborHasValue;
                    }
                    if (curIndex - width >= 0 && curIndex - width < pixelNum && (up = arr.getFloat(curIndex - width)) > 0.0f) {
                        tempPixelSum += up;
                        ++numNeighborHasValue;
                    }
                    if (curIndex + width >= 0 && curIndex + width < pixelNum && (down = arr.getFloat(curIndex + width)) > 0.0f) {
                        tempPixelSum += down;
                        ++numNeighborHasValue;
                    }
                    if (curIndex - width - 1 >= 0 && curIndex - width - 1 < pixelNum && (upleft = arr.getFloat(curIndex - width - 1)) > 0.0f) {
                        tempPixelSum += upleft;
                        ++numNeighborHasValue;
                    }
                    if (curIndex - width + 1 >= 0 && curIndex - width + 1 < pixelNum && (upright = arr.getFloat(curIndex - width + 1)) > 0.0f) {
                        tempPixelSum += upright;
                        ++numNeighborHasValue;
                    }
                    if (curIndex + width - 1 >= 0 && curIndex + width - 1 < pixelNum && (downleft = arr.getFloat(curIndex + width - 1)) > 0.0f) {
                        tempPixelSum += downleft;
                        ++numNeighborHasValue;
                    }
                    if (curIndex + width + 1 >= 0 && curIndex + width + 1 < pixelNum && (downright = arr.getFloat(curIndex + width + 1)) > 0.0f) {
                        tempPixelSum += downright;
                        ++numNeighborHasValue;
                    }
                    if (!(tempPixelSum > 0.0f)) continue;
                    interpolatedArray.setFloat(curIndex, tempPixelSum / (float)numNeighborHasValue);
                    continue;
                }
                interpolatedArray.setFloat(curIndex, curValue);
            }
        }
        return interpolatedArray;
    }

    double[] getSwathLatLonInformation(Array lat, Array lon) {
        double[] increment = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        IndexIterator latIter = lat.getIndexIterator();
        IndexIterator lonIter = lon.getIndexIterator();
        int numScan = lat.getShape()[0];
        int numSample = lat.getShape()[1];
        double maxLat = -91.0;
        double minLat = 91.0;
        double maxLon = -181.0;
        double minLon = 181.0;
        float firstLineStartLat = 0.0f;
        float firstLineStartLon = 0.0f;
        float firstLineEndLat = 0.0f;
        float firstLineEndLon = 0.0f;
        float lastLineStartLat = 0.0f;
        float lastLineStartLon = 0.0f;
        float lastLineEndLat = 0.0f;
        float lastLineEndLon = 0.0f;
        for (int i = 0; i < numScan; ++i) {
            for (int j = 0; j < numSample; ++j) {
                if (!latIter.hasNext() || !lonIter.hasNext()) continue;
                float curLat = latIter.getFloatNext();
                float curLon = lonIter.getFloatNext();
                if (i == 0 && j == 0) {
                    firstLineStartLat = curLat;
                    firstLineStartLon = curLon;
                    continue;
                }
                if (i == 0 && j == numSample - 1) {
                    firstLineEndLat = curLat;
                    firstLineEndLon = curLon;
                    continue;
                }
                if (i == numScan - 1 && j == 0) {
                    lastLineStartLat = curLat;
                    lastLineStartLon = curLon;
                    continue;
                }
                if (i != numScan - 1 || j != numSample - 1) continue;
                lastLineEndLat = curLat;
                lastLineEndLon = curLon;
            }
        }
        double[] edgeLat = new double[]{firstLineStartLat, firstLineEndLat, lastLineStartLat, lastLineEndLat};
        double[] edgeLon = new double[]{firstLineStartLon, firstLineEndLon, lastLineStartLon, lastLineEndLon};
        for (int i = 0; i < edgeLat.length; ++i) {
            maxLat = maxLat > edgeLat[i] ? maxLat : edgeLat[i];
            minLat = minLat < edgeLat[i] ? minLat : edgeLat[i];
            maxLon = maxLon > edgeLon[i] ? maxLon : edgeLon[i];
            minLon = minLon < edgeLon[i] ? minLon : edgeLon[i];
        }
        double xInc1 = Math.abs((firstLineEndLon - firstLineStartLon) / (float)numSample);
        double yInc1 = Math.abs((lastLineStartLat - firstLineStartLat) / (float)numScan);
        increment[0] = xInc1;
        increment[1] = yInc1;
        increment[2] = minLat;
        increment[3] = maxLat;
        increment[4] = minLon;
        increment[5] = maxLon;
        increment[6] = (maxLon - minLon) / xInc1;
        increment[7] = (maxLat - minLat) / yInc1;
        return increment;
    }

    private Array geoShiftLon(Array lon) {
        int count = 0;
        Index lonIndex = lon.getIndex();
        int[] lonShape = lon.getShape();
        ArrayFloat slon = new ArrayFloat(new int[]{lonShape[0]});
        Index slonIndex = slon.getIndex();
        IndexIterator lonIter = lon.getIndexIterator();
        LatLonPointImpl llp = new LatLonPointImpl();
        LatLonPointImpl p0 = new LatLonPointImpl(0.0, lon.getFloat(lonIndex.set(lonShape[0] - 1)));
        LatLonPointImpl pN = new LatLonPointImpl(0.0, lon.getFloat(lonIndex.set(0)));
        while (lonIter.hasNext()) {
            float l = lonIter.getFloatNext();
            if (!((double)l > 180.0)) continue;
            ++count;
        }
        int spoint = 0;
        spoint = p0.getLongitude() == pN.getLongitude() ? lonShape[0] - count - 1 : lonShape[0] - count;
        if (count > 0 && lonShape[0] > count) {
            for (int j = 1; j < lonShape[0]; ++j) {
                int jj = 0;
                jj = j >= count ? j - count : j + spoint;
                float dd = lon.getFloat(lonIndex.set(jj));
                slon.setFloat(slonIndex.set(j), (float)LatLonPointImpl.lonNormal(dd));
            }
            if (p0.getLongitude() == pN.getLongitude()) {
                float dd = slon.getFloat(slonIndex.set(lonShape[0] - 1));
                slon.setFloat(slonIndex.set(0), -((float)LatLonPointImpl.lonNormal(dd)));
            }
            return slon;
        }
        return lon;
    }
}

