/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.httpservices.HTTPSession;
import ucar.nc2.constants.CDM;

public class EscapeStrings {
    public static Logger log = LoggerFactory.getLogger(HTTPSession.class);
    protected static final String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    protected static final String numeric = "0123456789";
    protected static final String alphaNumeric = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    protected static final String httpclient_urllegal = "!#$&'()*+,-./:;=?@_~";
    protected static final String httpclient_querylegal = "!#$&'()*+,-./:;=?@_~%";
    protected static final String httpclient_urlillegal = " \"<>[\\]^`{|}%";
    protected static final String httpclient_queryillegal = " \"<>[\\]^`{|}";
    protected static final String nonAlphaNumeric = " !\"#$%&'()*+,-./:;<=>?@[]\\^_`|{}~";
    protected static final String queryReserved = " \"<>[\\]^`{|}";
    protected static final String urlReserved = " \"<>[\\]^`{|}%";
    protected static final String urlDisallowed = " \"<>[\\]^`{|}%";
    protected static final String urlAllowed = "!#$&'()*+,-./:;=?@_~";
    protected static final String _allowableInUrl = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$&'()*+,-./:;=?@_~";
    protected static final String queryIdentDisallowed = " \"\\^`|<>[]{}";
    protected static final String queryIdentAllowed = "!#$%&'()*+,-./:;=?@_~";
    protected static final String _allowableInUrlQuery = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%&'()*+,-./:;=?@_~";
    protected static final String dapSpecAllowed = "_!~*'-\"";
    protected static final String _namAllowedInDAP = "_!~*'-\"./";
    protected static final String _allowableInDAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_!~*'-\"./";
    protected static final String _namAllowedInOGC = "-_.!~*'()";
    protected static final String _disallowedInOGC = " \"#$%&+,/:;<=>?@[]\\^`|{}";
    protected static final String _allowableInOGC = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.!~*'()";
    protected static final String opendap_identifier_special_characters = "_!~*'-\"./";
    protected static final String opendap_identifier_characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_!~*'-\"./";
    protected static final char _URIEscape = '%';
    static final byte blank = 32;
    static final byte plus = 43;
    static final byte hexa = 97;
    static final byte hexf = 102;
    static final byte hexA = 65;
    static final byte hexF = 70;
    static final byte hex0 = 48;
    static final byte hex9 = 57;
    static final byte ten = 10;
    private static final Pattern p = Pattern.compile("([\\w]+)://([.\\w]+(:[\\d]+)?)([/][^?#])?([?][^#]*)?([#].*)?");
    private static final int sep = 46;
    static final String xmlGT = "&gt;";
    static final String xmlLT = "&lt;";
    static final String xmlAmp = "&amp;";
    static final String xmlApos = "&apos;";
    static final String xmlQuote = "&quot;";

    private static String stringUnion(String s) {
        StringBuilder union = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (s.indexOf(c, i + 1) >= 0) continue;
            union.append(c);
        }
        return union.toString();
    }

    private static String stringDiff(String s1, String s2) {
        String diff = "";
        for (char c : s1.toCharArray()) {
            if (s2.indexOf(c) >= 0) continue;
            diff = diff + c;
        }
        return diff;
    }

    private static String xescapeString(String in, String allowable, char esc, boolean spaceplus) {
        try {
            StringBuffer out = new StringBuffer();
            if (in == null) {
                return null;
            }
            byte[] utf8 = in.getBytes(CDM.utf8Charset);
            byte[] allow8 = allowable.getBytes(CDM.utf8Charset);
            for (byte b : utf8) {
                if (b == 32 && spaceplus) {
                    out.append('+');
                    continue;
                }
                boolean found = false;
                for (byte a : allow8) {
                    if (a != b) continue;
                    found = true;
                    break;
                }
                if (found) {
                    out.append((char)b);
                    continue;
                }
                String c = Integer.toHexString(b);
                out.append(esc);
                if (c.length() < 2) {
                    out.append('0');
                }
                out.append(c);
            }
            return out.toString();
        }
        catch (Exception e) {
            return in;
        }
    }

    private static String escapeString(String in, String allowable) {
        return EscapeStrings.xescapeString(in, allowable, '%', false);
    }

    private static String escapeString(String in, String allowable, char esc) {
        return EscapeStrings.xescapeString(in, allowable, esc, false);
    }

    private static String xunescapeString(String in, char escape, boolean spaceplus) {
        try {
            if (in == null) {
                return null;
            }
            byte[] utf8 = in.getBytes(CDM.utf8Charset);
            byte escape8 = (byte)escape;
            byte[] out = new byte[utf8.length];
            int index8 = 0;
            int i = 0;
            while (i < utf8.length) {
                byte b;
                if ((b = utf8[i++]) == 43 && spaceplus) {
                    out[index8++] = 32;
                } else if (b == escape8 && i + 2 <= utf8.length) {
                    b = (byte)(EscapeStrings.fromHex(utf8[i]) << 4 | EscapeStrings.fromHex(utf8[i + 1]));
                    i += 2;
                }
                out[index8++] = b;
            }
            return new String(out, 0, index8, CDM.utf8Charset);
        }
        catch (Exception e) {
            return in;
        }
    }

    private static String unescapeString(String in) {
        return EscapeStrings.xunescapeString(in, '%', false);
    }

    private static String unescapeString(String in, char escape) {
        return EscapeStrings.xunescapeString(in, escape, false);
    }

    private static byte fromHex(byte b) throws NumberFormatException {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(10 + (b - 97));
        }
        if (b >= 65 && b <= 70) {
            return (byte)(10 + (b - 65));
        }
        throw new NumberFormatException("Illegal hex character: " + b);
    }

    public static String unescapeDAPIdentifier(String id) {
        String s;
        try {
            s = EscapeStrings.unescapeString(id);
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    public static String escapeURL(String url) {
        String protocol = null;
        String authority = null;
        String path = null;
        String query = null;
        String fragment = null;
        URL u = null;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
        protocol = u.getProtocol();
        authority = u.getAuthority();
        path = u.getPath();
        query = u.getQuery();
        fragment = u.getRef();
        url = protocol + "://" + authority;
        if (path != null && path.length() > 0) {
            String[] pieces = path.split("[/]", -1);
            for (int i = 0; i < pieces.length; ++i) {
                String p = pieces[i];
                if (p == null) {
                    p = "";
                }
                if (i > 0) {
                    url = url + "/";
                }
                url = url + EscapeStrings.urlEncode(p);
            }
        }
        if (query != null && query.length() > 0) {
            url = url + "?" + EscapeStrings.escapeURLQuery(query);
        }
        if (fragment != null && fragment.length() > 0) {
            url = url + "#" + EscapeStrings.urlEncode(fragment);
        }
        return url;
    }

    static int nextpiece(String s, int index, String sep) {
        if ((index = s.indexOf(sep, index)) < 0) {
            index = s.length();
        }
        return index;
    }

    public static String escapeURLQuery(String ce) {
        try {
            ce = EscapeStrings.escapeString(ce, _allowableInUrlQuery);
        }
        catch (Exception e) {
            ce = null;
        }
        return ce;
    }

    public static String unescapeURLQuery(String ce) {
        try {
            ce = EscapeStrings.unescapeString(ce);
        }
        catch (Exception e) {
            ce = null;
        }
        return ce;
    }

    private static String urlEncode(String s) {
        s = EscapeStrings.escapeString(s, _allowableInUrl);
        return s;
    }

    public static String urlDecode(String s) {
        try {
            s = URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    public static String unescapeURL(String url) {
        String newurl = null;
        newurl = EscapeStrings.urlDecode(url);
        return newurl;
    }

    public static String escapeDAPIdentifier(String s) {
        return EscapeStrings.escapeString(s, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_!~*'-\"./");
    }

    public static String escapeOGC(String s) {
        return EscapeStrings.escapeString(s, _allowableInOGC);
    }

    public static void testOGC() {
        for (char c : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~".toCharArray()) {
            String encoded = EscapeStrings.escapeOGC("" + c);
            System.err.printf("|%c|=|%s|\n", Character.valueOf(c), encoded);
        }
    }

    public static String unescapeOGC(String s) {
        return EscapeStrings.urlDecode(s);
    }

    public static String backslashEscape(String x, String reservedChars) {
        if (reservedChars == null) {
            return x;
        }
        boolean ok = true;
        for (int pos = 0; pos < x.length(); ++pos) {
            char c = x.charAt(pos);
            if (reservedChars.indexOf(c) < 0) continue;
            ok = false;
            break;
        }
        if (ok) {
            return x;
        }
        StringBuilder sb = new StringBuilder(x);
        for (int pos = 0; pos < sb.length(); ++pos) {
            char c = sb.charAt(pos);
            if (reservedChars.indexOf(c) < 0) continue;
            sb.setCharAt(pos, '\\');
            sb.insert(++pos, c);
            ++pos;
        }
        return sb.toString();
    }

    public static String backslashUnescape(String x) {
        if (!x.contains("\\")) {
            return x;
        }
        StringBuilder sb = new StringBuilder(x.length());
        for (int pos = 0; pos < x.length(); ++pos) {
            char c = x.charAt(pos);
            if (c == '\\') {
                c = x.charAt(++pos);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static List<String> tokenizeEscapedName(String escapedName) {
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        int start = 0;
        while ((pos = escapedName.indexOf(46, pos + 1)) > 0) {
            if (pos <= 0 || escapedName.charAt(pos - 1) == '\\') continue;
            result.add(escapedName.substring(start, pos));
            start = pos + 1;
        }
        result.add(escapedName.substring(start, escapedName.length()));
        return result;
    }

    public static int indexOf(String escapedName, char c) {
        int pos = 0;
        do {
            if ((pos = escapedName.indexOf(c, pos + 1)) > 0) continue;
            return pos;
        } while (pos <= 0 || escapedName.charAt(pos - 1) == '\\');
        return pos;
    }

    public static void main2(String[] args) {
        String s = "http://thredds.ucar.edu/thredds/dodsC/fmrc/NCEP/GFS/Global_0p5deg/runs/NCEP-GFS-Global_0p5deg_RUN_2011-07-15T00:00:00Z.html.asc?Total_cloud_cover_low_cloud%5B1:1:1%5D%5B0:1:360%5D%5B0:1:719%5D";
        log.debug("%s%n", (Object)s);
        log.debug("%s%n", (Object)EscapeStrings.unescapeURL(s));
    }

    public static void main(String[] args) {
        String s = "https://localhost:8443/thredds/admin/log/access/";
        System.out.printf("%s%n", s);
        System.out.printf("%s%n", EscapeStrings.escapeURL(s));
    }

    public static void mainOld(String[] args) throws Exception {
    }

    public static String normalizeToXML(String s) {
        StringBuffer sb = new StringBuffer(s);
        block7: for (int offset = 0; offset < sb.length(); ++offset) {
            char c = sb.charAt(offset);
            switch (c) {
                case '>': {
                    sb.replace(offset, offset + 1, xmlGT);
                    continue block7;
                }
                case '<': {
                    sb.replace(offset, offset + 1, xmlLT);
                    continue block7;
                }
                case '&': {
                    sb.replace(offset, offset + 1, xmlAmp);
                    continue block7;
                }
                case '\'': {
                    sb.replace(offset, offset + 1, xmlApos);
                    continue block7;
                }
                case '\"': {
                    sb.replace(offset, offset + 1, xmlQuote);
                    continue block7;
                }
            }
        }
        return sb.toString();
    }

    public static String backslashToDAP(String bs) {
        StringBuilder buf = new StringBuilder();
        int len = bs.length();
        for (int i = 0; i < len; ++i) {
            char c = bs.charAt(i);
            if (i < len - 1 && c == '\\') {
                c = bs.charAt(++i);
            }
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_!~*'-\"./".indexOf(c) < 0) {
                buf.append('%');
                String ashex = Integer.toHexString(c);
                if (ashex.length() < 2) {
                    buf.append('0');
                }
                buf.append(ashex);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String backslashEscapeDapString(String s) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < ' ') {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': {
                        buf.append(c);
                        break;
                    }
                    default: {
                        buf.append(String.format("\\x%02x", c & 0xFF));
                        break;
                    }
                }
                continue;
            }
            if (c == '\"') {
                buf.append("\\\"");
                continue;
            }
            if (c == '\\') {
                buf.append('\\');
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

