/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.unidata.test.Diff;

public class UnitTestCommon
extends TestCase {
    static boolean DEBUG = false;
    protected boolean prop_ascii = true;
    protected boolean prop_diff = true;
    protected boolean prop_baseline = false;
    protected boolean prop_visual = false;
    protected boolean prop_debug = DEBUG;
    protected boolean prop_generate = true;
    protected String prop_controls = null;
    public static String TEMPROOT = "target/test/tmp/";
    static final String[] SUBROOTS = new String[]{"httpservices", "cdm", "tds", "opendap"};
    public static final String threddsRoot = UnitTestCommon.locateThreddsRoot();
    String title = "Testing";
    String name = "testcommon";

    static String locateThreddsRoot() {
        String path = System.getProperty("user.dir");
        path = path.replace('\\', '/');
        assert (path != null);
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path != null) {
            boolean allfound = true;
            for (String dirname : SUBROOTS) {
                String s = path + "/" + dirname;
                File tmp = new File(s);
                if (tmp.exists()) continue;
                allfound = false;
                break;
            }
            if (allfound) {
                return path;
            }
            int index = path.lastIndexOf(47);
            path = path.substring(0, index);
        }
        return null;
    }

    public void clearDir(File dir, boolean clearsubdirs) throws Exception {
        if (!dir.exists()) {
            return;
        }
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                if (clearsubdirs) {
                    this.clearDir(f, true);
                } else {
                    throw new Exception("InnerClass directory encountered: " + f.getAbsolutePath());
                }
            }
            f.delete();
        }
    }

    public UnitTestCommon() {
        this("UnitTest");
    }

    public UnitTestCommon(String name) {
        super(name);
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String compare(String tag, String baseline, String s) {
        try {
            Diff diff = new Diff(tag);
            StringWriter sw = new StringWriter();
            boolean pass = !diff.doDiff(baseline, s, (Writer)sw);
            return pass ? null : sw.toString();
        }
        catch (Exception e) {
            System.err.println("UnitTest: Diff failure: " + e);
            return null;
        }
    }

    public static byte[] readbinaryfile(InputStream stream) throws IOException {
        int cnt;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] tmp = new byte[65536];
        while ((cnt = stream.read(tmp)) > 0) {
            bytes.write(tmp, 0, cnt);
        }
        return bytes.toByteArray();
    }

    protected void setSystemProperties() {
        if (System.getProperty("nodiff") != null) {
            this.prop_diff = false;
        }
        if (System.getProperty("baseline") != null) {
            this.prop_baseline = true;
        }
        if (System.getProperty("nogenerate") != null) {
            this.prop_generate = false;
        }
        if (System.getProperty("debug") != null) {
            this.prop_debug = true;
        }
        if (System.getProperty("visual") != null) {
            this.prop_visual = true;
        }
        if (System.getProperty("ascii") != null) {
            this.prop_ascii = true;
        }
        if (System.getProperty("utf8") != null) {
            this.prop_ascii = false;
        }
        if (this.prop_baseline && this.prop_diff) {
            this.prop_diff = false;
        }
        this.prop_controls = System.getProperty("controls", "");
    }

    public void visual(String header, String captured) {
        if (!captured.endsWith("\n")) {
            captured = captured + "\n";
        }
        System.out.println("Testing " + this.getName() + ": " + header + ":");
        System.out.println("---------------");
        System.out.print(captured);
        System.out.println("---------------");
    }

    protected static String ncdumpmetadata(NetcdfFile ncfile) throws Exception {
        StringWriter sw = new StringWriter();
        try {
            if (!NCdumpW.print((NetcdfFile)ncfile, (String)"-unsigned", (Writer)sw, null)) {
                throw new Exception("NcdumpW failed");
            }
        }
        catch (IOException ioe) {
            throw new Exception("NcdumpW failed", ioe);
        }
        sw.close();
        return sw.toString();
    }

    protected static String ncdumpdata(NetcdfFile ncfile) throws Exception {
        StringWriter sw = new StringWriter();
        sw = new StringWriter();
        try {
            if (!NCdumpW.print((NetcdfFile)ncfile, (String)"-vall -unsigned", (Writer)sw, null)) {
                throw new Exception("NCdumpW failed");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new Exception("NCdumpW failed", ioe);
        }
        sw.close();
        return sw.toString();
    }
}

