/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Set;
import junit.framework.TestCase;
import org.slf4j.Logger;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.unidata.test.Diff;
import ucar.unidata.test.util.TestDir;

public class UnitTestCommon
extends TestCase {
    static final boolean DEBUG = false;
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    static final String[] DEFAULTSUBDIRS = new String[]{"httpservices", "cdm", "tds", "opendap", "dap4"};
    public static Logger log;
    static final Set<NetcdfDataset.Enhance> ENHANCEMENT;
    protected boolean prop_ascii = true;
    protected boolean prop_diff = true;
    protected boolean prop_baseline = false;
    protected boolean prop_visual = false;
    protected boolean prop_debug = false;
    protected boolean prop_generate = true;
    protected String prop_controls = null;
    protected String title = "Testing";
    protected String name = "testcommon";
    protected String threddsroot = null;
    protected String dtsServer = null;
    protected String threddsServer = null;

    static String locateThreddsRoot() {
        String path = System.getProperty("user.dir");
        path = path.replace('\\', '/');
        assert (path != null);
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        for (File prefix = new File(path); prefix != null; prefix = prefix.getParentFile()) {
            String[] subdirs;
            int found = 0;
            block3: for (String dirname : subdirs = prefix.list()) {
                for (String want : DEFAULTSUBDIRS) {
                    if (!dirname.equals(want)) continue;
                    ++found;
                    continue block3;
                }
            }
            if (found != DEFAULTSUBDIRS.length) continue;
            try {
                String root = prefix.getCanonicalPath();
                root = root.replace('\\', '/');
                return root;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return null;
    }

    protected static String rebuildpath(String[] pieces, int last) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i <= last; ++i) {
            buf.append("/");
            buf.append(pieces[i]);
        }
        return buf.toString();
    }

    public static void clearDir(File dir, boolean clearsubdirs) {
        if (!dir.exists()) {
            return;
        }
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                if (!clearsubdirs) continue;
                UnitTestCommon.clearDir(f, true);
                f.delete();
                continue;
            }
            f.delete();
        }
    }

    public UnitTestCommon() {
        this("UnitTest");
    }

    public UnitTestCommon(String name) {
        super(name);
        this.name = name;
        this.setSystemProperties();
        this.initPaths();
    }

    protected void initPaths() {
        this.threddsroot = UnitTestCommon.locateThreddsRoot();
        this.dtsServer = TestDir.dap2TestServer;
        this.threddsServer = TestDir.threddsTestServer;
    }

    protected void setSystemProperties() {
        if (System.getProperty("nodiff") != null) {
            this.prop_diff = false;
        }
        if (System.getProperty("baseline") != null) {
            this.prop_baseline = true;
        }
        if (System.getProperty("nogenerate") != null) {
            this.prop_generate = false;
        }
        if (System.getProperty("debug") != null) {
            this.prop_debug = true;
        }
        if (System.getProperty("visual") != null) {
            this.prop_visual = true;
        }
        if (System.getProperty("ascii") != null) {
            this.prop_ascii = true;
        }
        if (System.getProperty("utf8") != null) {
            this.prop_ascii = false;
        }
        if (this.prop_baseline && this.prop_diff) {
            this.prop_diff = false;
        }
        this.prop_controls = System.getProperty("controls", "");
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getThreddsroot() {
        return this.threddsroot;
    }

    public void visual(String header, String captured) {
        if (!captured.endsWith("\n")) {
            captured = captured + "\n";
        }
        System.out.println("Testing " + this.getName() + ": " + header + ":");
        System.out.println("---------------");
        System.out.print(captured);
        System.out.println("---------------");
    }

    public String compare(String tag, String baseline, String s) {
        try {
            Diff diff = new Diff(tag);
            StringWriter sw = new StringWriter();
            boolean pass = !diff.doDiff(baseline, s, (Writer)sw);
            return pass ? null : sw.toString();
        }
        catch (Exception e) {
            System.err.println("UnitTest: Diff failure: " + e);
            return null;
        }
    }

    protected String findServer(String servlet, String svcname, String schema) throws Exception {
        String svc;
        if (servlet.startsWith("/")) {
            servlet = servlet.substring(1);
        }
        if (!this.checkServer(svc = "http://" + svcname + "/" + servlet)) {
            throw new Exception("Server not reachable:" + svc);
        }
        return schema + "://" + svcname + "/" + servlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkServer(String candidate) {
        if (candidate == null) {
            return false;
        }
        System.err.print("Checking for sourceurl: " + candidate);
        try {
            HTTPSession session = new HTTPSession(candidate);
            HTTPMethod method = HTTPFactory.Get((HTTPSession)session);
            method.execute();
            String s = method.getResponseAsString();
            session.close();
            System.err.println(" ; found");
            boolean bl = true;
            return bl;
        }
        catch (IOException ie) {
            System.err.println(" ; fail");
            boolean bl = false;
            return bl;
        }
    }

    public static void writefile(String path, String content) throws IOException {
        File f = new File(path);
        if (f.exists()) {
            f.delete();
        }
        FileWriter out = new FileWriter(f);
        out.write(content);
        out.close();
    }

    public static void writefile(String path, byte[] content) throws IOException {
        File f = new File(path);
        if (f.exists()) {
            f.delete();
        }
        FileOutputStream out = new FileOutputStream(f);
        out.write(content);
        out.close();
    }

    public static String readfile(String filename) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        File xx = new File(filename);
        if (!xx.canRead()) {
            boolean x = false;
        }
        FileReader file = new FileReader(filename);
        BufferedReader rdr = new BufferedReader(file);
        while ((line = rdr.readLine()) != null) {
            if (line.startsWith("#")) continue;
            buf.append(line + "\n");
        }
        return buf.toString();
    }

    public static byte[] readbinaryfile(String filename) throws IOException {
        FileInputStream stream = new FileInputStream(filename);
        byte[] result = UnitTestCommon.readbinaryfile(stream);
        stream.close();
        return result;
    }

    public static byte[] readbinaryfile(InputStream stream) throws IOException {
        int cnt;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] tmp = new byte[65536];
        while ((cnt = stream.read(tmp)) > 0) {
            bytes.write(tmp, 0, cnt);
        }
        return bytes.toByteArray();
    }

    public static NetcdfDataset openDataset(String url) throws IOException {
        return NetcdfDataset.acquireDataset(null, (String)url, ENHANCEMENT, (int)-1, null, null);
    }

    public static String shortenFileName(String text, String filename) {
        String fixed = filename.replace('\\', '/');
        String shortname = filename;
        if (fixed.lastIndexOf(47) >= 0) {
            shortname = filename.substring(fixed.lastIndexOf(47) + 1, filename.length());
        }
        text = text.replaceAll(filename, shortname);
        return text;
    }

    public static void tag(String t) {
        System.err.println(t);
        System.err.flush();
    }

    protected static String ncdumpmetadata(NetcdfFile ncfile) throws Exception {
        StringWriter sw = new StringWriter();
        try {
            if (!NCdumpW.print((NetcdfFile)ncfile, (String)"-unsigned", (Writer)sw, null)) {
                throw new Exception("NcdumpW failed");
            }
        }
        catch (IOException ioe) {
            throw new Exception("NcdumpW failed", ioe);
        }
        sw.close();
        return sw.toString();
    }

    protected static String ncdumpdata(NetcdfFile ncfile) throws Exception {
        StringWriter sw = new StringWriter();
        sw = new StringWriter();
        try {
            if (!NCdumpW.print((NetcdfFile)ncfile, (String)"-vall -unsigned", (Writer)sw, null)) {
                throw new Exception("NCdumpW failed");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new Exception("NCdumpW failed", ioe);
        }
        sw.close();
        return sw.toString();
    }

    static {
        ENHANCEMENT = EnumSet.of(NetcdfDataset.Enhance.CoordSystems);
    }
}

