/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.test.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.unidata.io.RandomAccessFile;

public class TestDir {
    public static String testdataDir;
    public static String cdmUnitTestDir;
    public static String cdmLocalTestDataDir;
    public static String temporaryLocalDataDir;
    private static String testdataDirPropName;
    private static String threddsPropFileName;
    private static String threddsTestServerPropName;
    public static String threddsTestServer;
    public static String dap2TestServerPropName;
    public static String dap2TestServer;
    public static String dap4TestServerPropName;
    public static String dap4TestServer;
    private static boolean dumpFile;
    static int max_size;

    public static void showMem(String where) {
        Runtime runtime = Runtime.getRuntime();
        System.out.println(where + " memory free = " + (double)runtime.freeMemory() * 0.001 * 0.001 + " total= " + (double)runtime.totalMemory() * 0.001 * 0.001 + " max= " + (double)runtime.maxMemory() * 0.001 * 0.001 + " MB");
    }

    public static NetcdfFile open(String filename) {
        try {
            System.out.println("**** Open " + filename);
            NetcdfFile ncfile = NetcdfFile.open((String)filename, null);
            if (dumpFile) {
                System.out.println("open " + ncfile);
            }
            return ncfile;
        }
        catch (IOException e) {
            try {
                File absf = new File(filename);
                System.out.printf("abs path of %s == %s%n", filename, absf.getCanonicalPath());
            }
            catch (IOException ioe) {
                e.printStackTrace();
            }
            File pwd = new File(".");
            System.out.printf("pwd = %s%n", pwd.getAbsolutePath());
            System.out.println(" fail = " + e);
            e.printStackTrace();
            assert (false);
            return null;
        }
    }

    public static NetcdfFile openFileLocal(String filename) {
        return TestDir.open(cdmLocalTestDataDir + filename);
    }

    public static void checkLeaks() {
        if (RandomAccessFile.getOpenFiles().size() > 0) {
            System.out.printf("RandomAccessFile still open:%n", new Object[0]);
            for (String filename : RandomAccessFile.getOpenFiles()) {
                System.out.printf(" open= %s%n", filename);
            }
        } else {
            System.out.printf("RandomAccessFile: no leaks%n", new Object[0]);
        }
        System.out.printf("RandomAccessFile: count open=%d, max=%d%n", RandomAccessFile.getOpenFileCount(), RandomAccessFile.getMaxOpenFileCount());
    }

    public static int actOnAll(String dirName, FileFilter ff, Act act) throws IOException {
        return TestDir.actOnAll(dirName, ff, act, true);
    }

    public static int actOnAllParameterized(String dirName, FileFilter ff, Collection<Object[]> filenames) throws IOException {
        return TestDir.actOnAll(dirName, ff, new ListAction(filenames), true);
    }

    public static int actOnAll(String dirName, FileFilter ff, Act act, boolean recurse) throws IOException {
        int count = 0;
        System.out.println("---------------Reading directory " + dirName);
        File allDir = new File(dirName);
        File[] allFiles = allDir.listFiles();
        if (null == allFiles) {
            System.out.println("---------------INVALID " + dirName);
            return count;
        }
        List<File> flist = Arrays.asList(allFiles);
        Collections.sort(flist);
        for (File f : flist) {
            String name = f.getAbsolutePath();
            if (f.isDirectory() || ff != null && !ff.accept(f) || name.endsWith(".exclude")) continue;
            System.out.println("----acting on file " + name);
            count += act.doAct(name);
        }
        if (!recurse) {
            return count;
        }
        for (File f : allFiles) {
            if (!f.isDirectory() || f.getName().equals("exclude") || f.getName().equals("problem")) continue;
            count += TestDir.actOnAll(f.getAbsolutePath(), ff, act);
        }
        return count;
    }

    public static int readAllDir(String dirName, FileFilter ff) throws IOException {
        return TestDir.actOnAll(dirName, ff, new ReadAllVariables());
    }

    public static void readAll(String filename) throws IOException {
        ReadAllVariables act = new ReadAllVariables();
        act.doAct(filename);
    }

    static Section makeSubset(Variable v) throws InvalidRangeException {
        int[] shape = v.getShape();
        shape[0] = 1;
        Section s = new Section(shape);
        long size = s.computeSize();
        shape[0] = (int)Math.max(1L, (long)max_size / size);
        return new Section(shape);
    }

    public static int readAllData(NetcdfFile ncfile) {
        block4: {
            System.out.println("\n------Reading ncfile " + ncfile.getLocation());
            try {
                for (Variable v : ncfile.getVariables()) {
                    if (v.getSize() > (long)max_size) {
                        Section s = TestDir.makeSubset(v);
                        System.out.println("  Try to read variable " + v.getNameAndDimensions() + " size= " + v.getSize() + " section= " + s);
                        v.read(s);
                        continue;
                    }
                    System.out.println("  Try to read variable " + v.getNameAndDimensions() + " size= " + v.getSize());
                    v.read();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        return 1;
    }

    public static List<Object[]> getAllFilesInDirectory(String topdir, FileFilter filter) {
        ArrayList<File> files = new ArrayList<File>();
        File topDir = new File(topdir);
        for (File f : topDir.listFiles()) {
            if (filter != null && !filter.accept(f)) continue;
            files.add(f);
        }
        Collections.sort(files);
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (File f : files) {
            result.add(new Object[]{f.getAbsolutePath()});
            System.out.printf("%s%n", f.getAbsolutePath());
        }
        return result;
    }

    static {
        String d4ts;
        String dts;
        String rts;
        File tmpDataDir;
        File file;
        File userHomeDirFile;
        File userThreddsPropsFile;
        testdataDir = null;
        cdmUnitTestDir = null;
        cdmLocalTestDataDir = "../cdm/src/test/data/";
        temporaryLocalDataDir = "target/test/tmp/";
        testdataDirPropName = "unidata.testdata.path";
        threddsPropFileName = "thredds.properties";
        threddsTestServerPropName = "threddstestserver";
        threddsTestServer = "remotetest.unidata.ucar.edu";
        dap2TestServerPropName = "dts";
        dap2TestServer = "remotetest.unidata.ucar.edu";
        dap4TestServerPropName = "d4ts";
        dap4TestServer = "remotetest.unidata.ucar.edu";
        testdataDir = System.getProperty(testdataDirPropName);
        if (testdataDir == null && (userThreddsPropsFile = new File(userHomeDirFile = new File(System.getProperty("user.home")), threddsPropFileName)).exists() && userThreddsPropsFile.canRead()) {
            Properties userThreddsProps = new Properties();
            try {
                userThreddsProps.load(new FileInputStream(userThreddsPropsFile));
            }
            catch (IOException e) {
                System.err.println("**Failed loading user THREDDS property file: " + e.getMessage());
            }
            if (userThreddsProps != null && !userThreddsProps.isEmpty() && testdataDir == null) {
                testdataDir = userThreddsProps.getProperty(testdataDirPropName);
            }
        }
        if (testdataDir == null) {
            testdataDir = "/share/testdata/";
            System.err.printf("**No '%s' property, defaulting to '%s'%n", testdataDirPropName, testdataDir);
        }
        if (!(testdataDir = testdataDir.replace('\\', '/')).endsWith("/")) {
            testdataDir = testdataDir + "/";
        }
        if (!(file = new File(cdmUnitTestDir = testdataDir + "cdmUnitTest/")).exists() || !file.isDirectory()) {
            System.err.println("**WARN: Non-existence of Level 3 test data directory [" + file.getAbsolutePath() + "].");
        }
        if (!(tmpDataDir = new File(temporaryLocalDataDir)).exists() && !tmpDataDir.mkdirs()) {
            System.err.println("**ERROR: Could not create temporary data dir <" + tmpDataDir.getAbsolutePath() + ">.");
        }
        if ((rts = System.getProperty(threddsTestServerPropName)) != null && rts.length() > 0) {
            threddsTestServer = rts;
        }
        if ((dts = System.getProperty(dap2TestServerPropName)) != null && dts.length() > 0) {
            dap2TestServer = dts;
        }
        if ((d4ts = System.getProperty(dap4TestServerPropName)) != null && d4ts.length() > 0) {
            dap4TestServer = d4ts;
        }
        dumpFile = false;
        max_size = 10000000;
    }

    private static class ReadAllVariables
    implements Act {
        private ReadAllVariables() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int doAct(String filename) throws IOException {
            System.out.println("\n------Reading filename " + filename);
            NetcdfFile ncfile = null;
            try {
                ncfile = NetcdfFile.open((String)filename);
                for (Variable v : ncfile.getVariables()) {
                    if (v.getSize() > (long)max_size) {
                        Section s = TestDir.makeSubset(v);
                        System.out.println("  Try to read variable " + v.getNameAndDimensions() + " size= " + v.getSize() + " section= " + s);
                        v.read(s);
                        continue;
                    }
                    System.out.println("  Try to read variable " + v.getNameAndDimensions() + " size= " + v.getSize());
                    v.read();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (ncfile != null) {
                    try {
                        ncfile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return 1;
        }
    }

    static class ListAction
    implements Act {
        Collection<Object[]> filenames;

        ListAction(Collection<Object[]> filenames) {
            this.filenames = filenames;
        }

        @Override
        public int doAct(String filename) throws IOException {
            this.filenames.add(new Object[]{filename});
            return 0;
        }
    }

    public static class FileFilterNoWant
    implements FileFilter {
        String[] suffixes;

        public FileFilterNoWant(String suffixes) {
            this.suffixes = suffixes.split(" ");
        }

        @Override
        public boolean accept(File file) {
            for (String s : this.suffixes) {
                if (!file.getPath().endsWith(s)) continue;
                return false;
            }
            return true;
        }
    }

    public static class FileFilterFromSuffixes
    implements FileFilter {
        String[] suffixes;

        public FileFilterFromSuffixes(String suffixes) {
            this.suffixes = suffixes.split(" ");
        }

        @Override
        public boolean accept(File file) {
            for (String s : this.suffixes) {
                if (!file.getPath().endsWith(s)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Act {
        public int doAct(String var1) throws IOException;
    }
}

