/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import ucar.nc2.util.TableParser;

public class TestTableParser {
    static final String testName3 = "/resources/nj22/tables/nexrad.tbl";
    static final String testRepeat = "C:\\data\\ghcnm\\ghcnm.v3.0.0-beta1.20101207.qae.dat";

    @Test
    public void testReadNexradTable() throws IOException {
        Class<TableParser> c = TableParser.class;
        InputStream is = c.getResourceAsStream(testName3);
        List recs = TableParser.readTable((InputStream)is, (String)"3,15,54,60d,67d,73d", (int)50000);
        TableParser.Record rec = (TableParser.Record)recs.get(0);
        Assert.assertEquals((Object)"TLX", (Object)rec.get(0));
        Assert.assertEquals((Object)"      000001", (Object)rec.get(1));
        Assert.assertEquals((Object)" OKLAHOMA_CITY/Norman             OK US", (Object)rec.get(2));
        Assert.assertEquals((double)3532.0, (double)((Double)rec.get(3)), (double)0.1);
        Assert.assertEquals((double)-9727.0, (double)((Double)rec.get(4)), (double)0.1);
        Assert.assertEquals((double)370.0, (double)((Double)rec.get(5)), (double)0.1);
        rec = (TableParser.Record)recs.get(20);
        Assert.assertEquals((Object)"TWX", (Object)rec.get(0));
        Assert.assertEquals((Object)"      000554", (Object)rec.get(1));
        Assert.assertEquals((Object)" TOPEKA/Alma                      KS US", (Object)rec.get(2));
        Assert.assertEquals((double)3898.0, (double)((Double)rec.get(3)), (double)0.1);
        Assert.assertEquals((double)-9622.0, (double)((Double)rec.get(4)), (double)0.1);
        Assert.assertEquals((double)417.0, (double)((Double)rec.get(5)), (double)0.1);
    }

    @Test
    @Ignore(value="ghcnm.v3.0.0-beta1.20101207.qae.dat isn't in repo")
    public void testReadgGghcnmTable() throws IOException {
        List recs = TableParser.readTable((String)testRepeat, (String)"11L,15i,19,(24i,25,26,27)*10", (int)5);
        for (TableParser.Record record : recs) {
            for (int j = 0; j < record.values.size(); ++j) {
                Object s = record.values.get(j);
                System.out.print(" " + s.toString());
            }
            System.out.println();
        }
    }
}

