/*
 * Decompiled with CFR 0.152.
 */
package thredds.featurecollection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionType;
import thredds.featurecollection.TimeUnitConverter;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.DateExtractor;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.DateExtractorNone;
import ucar.nc2.time.CalendarPeriod;
import ucar.unidata.util.StringUtil2;

public class FeatureCollectionConfig {
    public static final String AUX_CONFIG = "fcConfig";
    private static boolean regularizeDefault = false;
    private static Logger log = LoggerFactory.getLogger(FeatureCollectionConfig.class);
    public FeatureCollectionType type;
    public PartitionType ptype = PartitionType.directory;
    public CalendarPeriod timePeriod;
    public String name;
    public String path;
    public String spec;
    public String collectionName;
    public String dateFormatMark;
    public String olderThan;
    public UpdateConfig tdmConfig = new UpdateConfig();
    public UpdateConfig updateConfig = new UpdateConfig();
    public ProtoConfig protoConfig = new ProtoConfig();
    public FmrcConfig fmrcConfig = new FmrcConfig();
    public PointConfig pointConfig = new PointConfig();
    public GribConfig gribConfig = new GribConfig();
    public Element innerNcml = null;
    private static Set<FmrcDatasetType> defaultFmrcDatasetTypes = Collections.unmodifiableSet(EnumSet.of(FmrcDatasetType.TwoD, FmrcDatasetType.Best, FmrcDatasetType.Files, FmrcDatasetType.Runs));
    private static Set<PointDatasetType> defaultPointDatasetTypes = Collections.unmodifiableSet(EnumSet.of(PointDatasetType.cdmrFeature, PointDatasetType.Files));
    private static final Set<GribDatasetType> defaultGribDatasetTypes = Collections.unmodifiableSet(EnumSet.of(GribDatasetType.TwoD, GribDatasetType.Best, GribDatasetType.Files, GribDatasetType.Latest));
    public static boolean useGenTypeDef = false;
    public static boolean useTableVersionDef = false;
    public static boolean intvMergeDef = true;
    public static boolean useCenterDef = false;

    public static void setRegularizeDefault(boolean t) {
        regularizeDefault = t;
    }

    public static boolean getRegularizeDefault() {
        return regularizeDefault;
    }

    public FeatureCollectionConfig() {
    }

    public FeatureCollectionConfig(String name, String path, FeatureCollectionType fcType, String spec, String collectionName, String dateFormatMark, String olderThan, String timePartition, Element innerNcml) {
        this.name = name;
        this.path = path;
        this.type = fcType;
        this.spec = spec;
        this.collectionName = collectionName == null ? name : collectionName;
        this.dateFormatMark = dateFormatMark;
        this.olderThan = olderThan;
        if (null != timePartition) {
            if (timePartition.equalsIgnoreCase("none")) {
                this.ptype = PartitionType.none;
            } else if (timePartition.equalsIgnoreCase("directory")) {
                this.ptype = PartitionType.directory;
            } else if (timePartition.equalsIgnoreCase("file")) {
                this.ptype = PartitionType.file;
            } else {
                this.timePeriod = CalendarPeriod.of(timePartition);
                this.ptype = PartitionType.timePeriod;
                if (this.timePeriod == null) {
                    throw new IllegalArgumentException("Illegal timePeriod= " + timePartition);
                }
            }
        }
        this.innerNcml = innerNcml;
    }

    public boolean isTrigggerOk() {
        return this.updateConfig.triggerOk || this.tdmConfig != null && this.tdmConfig.triggerOk;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("FeatureCollectionConfig name ='%s' collectionName='%s' type='%s'%n", new Object[]{this.name, this.collectionName, this.type});
        f.format("  spec='%s'%n", this.spec);
        if (this.dateFormatMark != null) {
            f.format("  dateFormatMark ='%s'%n", this.dateFormatMark);
        }
        if (this.olderThan != null) {
            f.format("  olderThan =%s%n", this.olderThan);
        }
        f.format("  timePartition =%s%n", new Object[]{this.ptype});
        if (this.updateConfig != null) {
            f.format("  updateConfig =%s%n", this.updateConfig);
        }
        if (this.tdmConfig != null) {
            f.format("  tdmConfig =%s%n", this.tdmConfig);
        }
        if (this.protoConfig != null) {
            f.format("  %s%n", this.protoConfig);
        }
        f.format("  hasInnerNcml =%s%n", this.innerNcml != null);
        if (this.type != null) {
            switch (this.type) {
                case GRIB1: 
                case GRIB2: {
                    f.format("  %s%n", this.gribConfig);
                    break;
                }
                case FMRC: {
                    f.format("  fmrcConfig =%s%n", this.fmrcConfig);
                    break;
                }
                case Point: 
                case Station: 
                case Station_Profile: {
                    f.format("  pointConfig =%s%n", this.pointConfig);
                }
            }
        }
        return f.toString();
    }

    public void show(Formatter f) {
        f.format("FeatureCollectionConfig name= '%s' collectionName= '%s' type= '%s'%n", new Object[]{this.name, this.collectionName, this.type});
        f.format("  spec= '%s'%n", this.spec);
        if (this.dateFormatMark != null) {
            f.format("  dateFormatMark='%s'%n", this.dateFormatMark);
        }
        if (this.olderThan != null) {
            f.format("  olderThan= %s%n", this.olderThan);
        }
        if (this.ptype == PartitionType.timePeriod) {
            f.format("  timePartition= %s %n", this.timePeriod);
        } else {
            f.format("  timePartition= %s%n", new Object[]{this.ptype});
        }
        if (this.type != null) {
            switch (this.type) {
                case GRIB1: 
                case GRIB2: {
                    this.gribConfig.show(f);
                    break;
                }
                case FMRC: {
                    f.format("  fmrcConfig= %s%n", this.fmrcConfig);
                    break;
                }
                case Point: 
                case Station: 
                case Station_Profile: {
                    f.format("  pointConfig= %s%n", this.pointConfig);
                }
            }
        }
    }

    public void finish() {
        if (!this.tdmConfig.userDefined) {
            this.tdmConfig.updateType = CollectionUpdateType.test;
        }
        if (!this.updateConfig.userDefined) {
            this.updateConfig.updateType = this.tdmConfig.userDefined ? CollectionUpdateType.never : CollectionUpdateType.nocheck;
        }
        this.updateConfig.startupType = this.updateConfig.updateType;
        this.tdmConfig.startupType = this.tdmConfig.updateType;
    }

    public DateExtractor getDateExtractor() {
        if (this.dateFormatMark != null) {
            return new DateExtractorFromName(this.dateFormatMark, false);
        }
        CollectionSpecParser sp = new CollectionSpecParser(this.spec, null);
        if (sp.getDateFormatMark() != null) {
            return new DateExtractorFromName(sp.getDateFormatMark(), true);
        }
        return new DateExtractorNone();
    }

    static /* synthetic */ boolean access$100() {
        return regularizeDefault;
    }

    static /* synthetic */ Set access$200() {
        return defaultFmrcDatasetTypes;
    }

    static /* synthetic */ Set access$300() {
        return defaultPointDatasetTypes;
    }

    static /* synthetic */ Set access$400() {
        return defaultGribDatasetTypes;
    }

    public static class TimeUnitConverterHash
    implements TimeUnitConverter {
        public Map<Integer, Integer> map = new HashMap<Integer, Integer>(5);

        @Override
        public int convertTimeUnit(int timeUnit) {
            if (this.map == null) {
                return timeUnit;
            }
            Integer convert = this.map.get(timeUnit);
            return convert == null ? timeUnit : convert;
        }
    }

    public static class GribIntvFilter {
        public List<GribIntvFilterParam> filter;
        public boolean isZeroExcluded = true;

        public boolean isZeroExcluded() {
            return this.isZeroExcluded;
        }

        public boolean hasFilter() {
            return this.filter != null;
        }

        public boolean filterOk(int id, int intvLength, int prob) {
            if (intvLength == 0 && this.isZeroExcluded()) {
                return false;
            }
            if (this.filter == null) {
                return true;
            }
            for (GribIntvFilterParam param : this.filter) {
                boolean isMine;
                boolean needProb = param.prob != Integer.MIN_VALUE;
                boolean hasProb = prob != Integer.MIN_VALUE;
                boolean bl = isMine = !needProb || hasProb && param.prob == prob;
                if (param.id != id || !isMine || param.intvLength == intvLength) continue;
                return false;
            }
            return true;
        }

        void addVariable(int intvLength, String idS, String probS) {
            if (idS == null) {
                log.warn("Error on intvFilter: must have an id attribute");
                return;
            }
            String[] s = idS.split("-");
            if (s.length != 3 && s.length != 4) {
                log.warn("Error on intvFilter: id attribute must be of format 'discipline-category-number' (GRIB2) or 'center-subcenter-version-param' (GRIB1)");
                return;
            }
            try {
                int prob;
                int id;
                if (s.length == 3) {
                    int discipline = Integer.parseInt(s[0]);
                    int category = Integer.parseInt(s[1]);
                    int number = Integer.parseInt(s[2]);
                    id = (discipline << 16) + (category << 8) + number;
                } else {
                    int center = Integer.parseInt(s[0]);
                    int subcenter = Integer.parseInt(s[1]);
                    int version = Integer.parseInt(s[2]);
                    int param = Integer.parseInt(s[3]);
                    id = (center << 8) + (subcenter << 16) + (version << 24) + param;
                }
                int n = prob = probS == null ? Integer.MIN_VALUE : Integer.parseInt(probS);
                if (this.filter == null) {
                    this.filter = new ArrayList<GribIntvFilterParam>(10);
                }
                this.filter.add(new GribIntvFilterParam(id, intvLength, prob));
            }
            catch (NumberFormatException e) {
                log.info("Error on intvFilter element - attribute must be an integer");
            }
        }
    }

    public static class GribIntvFilterParam {
        public final int id;
        public final int intvLength;
        public final int prob;

        public GribIntvFilterParam(int id, int intvLength, int prob) {
            this.id = id;
            this.intvLength = intvLength;
            this.prob = prob;
        }
    }

    public static class GribConfig {
        public Map<Integer, Integer> gdsHash;
        public Map<Integer, String> gdsNamer;
        public boolean useGenType = useGenTypeDef;
        public boolean useTableVersion = useTableVersionDef;
        public boolean intvMerge = intvMergeDef;
        public boolean useCenter = useCenterDef;
        public boolean unionRuntimeCoord;
        public GribIntvFilter intvFilter;
        public TimeUnitConverterHash tuc;
        public CalendarPeriod userTimeUnit;
        public String latestNamer;
        public String bestNamer;
        public Boolean filesSortIncreasing = true;
        public Set<GribDatasetType> datasets = FeatureCollectionConfig.access$400();
        public String lookupTablePath;
        public String paramTablePath;
        public Element paramTable;
        private boolean explicitDatasets = false;

        public TimeUnitConverter getTimeUnitConverter() {
            return this.tuc;
        }

        public void configFromXml(Element configElem, Namespace ns) {
            Element filesSortElem;
            String datasetTypes = configElem.getAttributeValue("datasetTypes");
            if (null != datasetTypes) {
                this.addDatasetType(datasetTypes);
            }
            List gdsElems = configElem.getChildren("gdsHash", ns);
            for (Element gds : gdsElems) {
                this.addGdsHash(gds.getAttributeValue("from"), gds.getAttributeValue("to"));
            }
            List tuElems = configElem.getChildren("timeUnitConvert", ns);
            for (Element tu : tuElems) {
                this.addTimeUnitConvert(tu.getAttributeValue("from"), tu.getAttributeValue("to"));
            }
            gdsElems = configElem.getChildren("gdsName", ns);
            for (Element gds : gdsElems) {
                this.addGdsName(gds.getAttributeValue("hash"), gds.getAttributeValue("groupName"));
            }
            if (configElem.getChild("parameterMap", ns) != null) {
                this.paramTable = configElem.getChild("parameterMap", ns);
            }
            if (configElem.getChild("gribParameterTable", ns) != null) {
                this.paramTablePath = configElem.getChildText("gribParameterTable", ns);
            }
            if (configElem.getChild("gribParameterTableLookup", ns) != null) {
                this.lookupTablePath = configElem.getChildText("gribParameterTableLookup", ns);
            }
            if (configElem.getChild("latestNamer", ns) != null) {
                this.latestNamer = configElem.getChild("latestNamer", ns).getAttributeValue("name");
            }
            if (configElem.getChild("bestNamer", ns) != null) {
                this.bestNamer = configElem.getChild("bestNamer", ns).getAttributeValue("name");
            }
            if ((filesSortElem = configElem.getChild("filesSort", ns)) != null) {
                String orderByS = filesSortElem.getAttributeValue("orderBy");
                String increasingS = filesSortElem.getAttributeValue("increasing");
                if (increasingS != null) {
                    this.filesSortIncreasing = !increasingS.equalsIgnoreCase("false");
                } else {
                    Element lexigraphicByName = filesSortElem.getChild("lexigraphicByName", ns);
                    if (lexigraphicByName != null) {
                        this.filesSortIncreasing = Boolean.valueOf(lexigraphicByName.getAttributeValue("increasing"));
                    }
                }
            }
            List intvElems = configElem.getChildren("intvFilter", ns);
            for (Element intvElem : intvElems) {
                String intvLengthS;
                String excludeZero;
                if (this.intvFilter == null) {
                    this.intvFilter = new GribIntvFilter();
                }
                if ((excludeZero = intvElem.getAttributeValue("excludeZero")) != null) {
                    this.setExcludeZero(!excludeZero.equals("false"));
                }
                if ((intvLengthS = intvElem.getAttributeValue("intvLength")) == null) continue;
                int intvLength = Integer.parseInt(intvLengthS);
                List varElems = intvElem.getChildren("variable", ns);
                for (Element varElem : varElems) {
                    this.intvFilter.addVariable(intvLength, varElem.getAttributeValue("id"), varElem.getAttributeValue("prob"));
                }
            }
            List paramElems = configElem.getChildren("option", ns);
            if (paramElems.size() == 0) {
                paramElems = configElem.getChildren("parameter", ns);
            }
            for (Element param : paramElems) {
                String name = param.getAttributeValue("name");
                String value = param.getAttributeValue("value");
                if (name == null || value == null) continue;
                this.setOption(name, value);
            }
            Element pdsHashElement = configElem.getChild("pdsHash", ns);
            this.useGenType = this.readValue(pdsHashElement, "useGenType", ns, useGenTypeDef);
            this.useTableVersion = this.readValue(pdsHashElement, "useTableVersion", ns, useTableVersionDef);
            this.intvMerge = this.readValue(pdsHashElement, "intvMerge", ns, intvMergeDef);
            this.useCenter = this.readValue(pdsHashElement, "useCenter", ns, useCenterDef);
        }

        public boolean setOption(String name, String value) {
            if (name == null || value == null) {
                return false;
            }
            if (name.equalsIgnoreCase("timeUnit")) {
                this.setUserTimeUnit(value);
                return true;
            }
            if (name.equalsIgnoreCase("runtimeCoordinate") && value.equalsIgnoreCase("union")) {
                this.unionRuntimeCoord = true;
                return true;
            }
            return false;
        }

        public void setUserTimeUnit(String value) {
            if (value != null) {
                this.userTimeUnit = CalendarPeriod.of(value);
            }
        }

        public void setExcludeZero(boolean val) {
            if (this.intvFilter == null) {
                this.intvFilter = new GribIntvFilter();
            }
            this.intvFilter.isZeroExcluded = val;
        }

        public void setUseTableVersion(boolean val) {
            this.useTableVersion = val;
        }

        public void setIntervalLength(int intvLength, String varId) {
            if (this.intvFilter == null) {
                this.intvFilter = new GribIntvFilter();
            }
            this.intvFilter.addVariable(intvLength, varId, null);
        }

        private boolean readValue(Element pdsHashElement, String key, Namespace ns, boolean value) {
            Element e;
            if (pdsHashElement != null && (e = pdsHashElement.getChild(key, ns)) != null) {
                value = true;
                String t = e.getTextNormalize();
                if (t != null && t.equalsIgnoreCase("true")) {
                    value = true;
                }
                if (t != null && t.equalsIgnoreCase("false")) {
                    value = false;
                }
            }
            return value;
        }

        public void addDatasetType(String datasetTypes) {
            String[] types;
            if (!this.explicitDatasets) {
                this.datasets = EnumSet.noneOf(GribDatasetType.class);
            }
            this.explicitDatasets = true;
            for (String type : types = StringUtil2.splitString(datasetTypes)) {
                try {
                    GribDatasetType fdt = GribDatasetType.valueOf(type);
                    if (fdt == GribDatasetType.LatestFile) {
                        fdt = GribDatasetType.Latest;
                    }
                    this.datasets.add(fdt);
                }
                catch (Exception e) {
                    log.warn("Dont recognize GribDatasetType {}", (Object)type);
                }
            }
        }

        public boolean hasDatasetType(GribDatasetType type) {
            return this.datasets.contains((Object)type);
        }

        public void addGdsHash(String fromS, String toS) {
            if (fromS == null || toS == null) {
                return;
            }
            if (this.gdsHash == null) {
                this.gdsHash = new HashMap<Integer, Integer>(10);
            }
            try {
                int from = Integer.parseInt(fromS);
                int to = Integer.parseInt(toS);
                this.gdsHash.put(from, to);
            }
            catch (Exception e) {
                log.warn("Failed  to parse as Integer = {} {}", (Object)fromS, (Object)toS);
            }
        }

        public void addTimeUnitConvert(String fromS, String toS) {
            if (fromS == null || toS == null) {
                return;
            }
            if (this.tuc == null) {
                this.tuc = new TimeUnitConverterHash();
            }
            try {
                int from = Integer.parseInt(fromS);
                int to = Integer.parseInt(toS);
                this.tuc.map.put(from, to);
            }
            catch (Exception e) {
                log.warn("Failed  to parse as Integer = {} {}", (Object)fromS, (Object)toS);
            }
        }

        public void addGdsName(String hashS, String name) {
            if (hashS == null || name == null) {
                return;
            }
            if (this.gdsNamer == null) {
                this.gdsNamer = new HashMap<Integer, String>(5);
            }
            try {
                int hash = Integer.parseInt(hashS);
                this.gdsNamer.put(hash, name);
            }
            catch (Exception e) {
                log.warn("Failed  to parse as Integer = {} {}", (Object)hashS, (Object)name);
            }
        }

        public void show(Formatter f) {
            f.format("GribConfig= ", new Object[0]);
            if (this.useGenType != useGenTypeDef) {
                f.format(" useGenType=%s", this.useGenType);
            }
            if (this.useTableVersion != useTableVersionDef) {
                f.format(" useTableVersion=%s", this.useTableVersion);
            }
            if (this.intvMerge != intvMergeDef) {
                f.format(" intvMerge=%s", this.intvMerge);
            }
            if (this.useCenter != useCenterDef) {
                f.format(" useCenter=%s", this.useCenter);
            }
            if (this.userTimeUnit != null) {
                f.format(" userTimeUnit= %s", this.userTimeUnit);
            }
            f.format("%n", new Object[0]);
            if (this.gdsHash != null) {
                f.format("  gdsHash=%s%n", this.gdsHash);
            }
            if (this.gdsNamer != null) {
                f.format("  gdsNamer=%s%n", this.gdsNamer);
            }
            if (this.intvFilter != null) {
                f.format("  intvFilter=%s%n", this.intvFilter);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("GribConfig{");
            sb.append("datasets=").append(this.datasets);
            if (this.gdsHash != null) {
                sb.append(", gdsHash=").append(this.gdsHash);
            }
            if (this.gdsNamer != null) {
                sb.append(", gdsNamer=").append(this.gdsNamer);
            }
            sb.append(", useGenType=").append(this.useGenType);
            sb.append(", useTableVersion=").append(this.useTableVersion);
            sb.append(", intvMerge=").append(this.intvMerge);
            sb.append(", useCenter=").append(this.useCenter);
            if (this.lookupTablePath != null) {
                sb.append(", lookupTablePath='").append(this.lookupTablePath).append('\'');
            }
            if (this.paramTablePath != null) {
                sb.append(", paramTablePath='").append(this.paramTablePath).append('\'');
            }
            if (this.latestNamer != null) {
                sb.append(", latestNamer='").append(this.latestNamer).append('\'');
            }
            if (this.bestNamer != null) {
                sb.append(", bestNamer='").append(this.bestNamer).append('\'');
            }
            if (this.paramTable != null) {
                sb.append(", paramTable=").append(this.paramTable);
            }
            if (this.filesSortIncreasing != null) {
                sb.append(", filesSortIncreasing=").append(this.filesSortIncreasing);
            }
            if (this.intvFilter != null) {
                sb.append(", intvFilter=").append(this.intvFilter);
            }
            if (this.userTimeUnit != null) {
                sb.append(", userTimeUnit='").append(this.userTimeUnit).append('\'');
            }
            sb.append('}');
            return sb.toString();
        }

        public Object getIospMessage() {
            if (this.lookupTablePath != null) {
                return "gribParameterTableLookup=" + this.lookupTablePath;
            }
            if (this.paramTablePath != null) {
                return "gribParameterTable=" + this.paramTablePath;
            }
            return null;
        }

        public int convertGdsHash(int hashcode) {
            if (this.gdsHash == null) {
                return hashcode;
            }
            Integer convertedValue = this.gdsHash.get(hashcode);
            if (convertedValue == null) {
                return hashcode;
            }
            return convertedValue;
        }
    }

    public static class PointConfig {
        public Set<PointDatasetType> datasets = FeatureCollectionConfig.access$300();
        protected boolean explicit = false;

        public void addDatasetType(String datasetTypes) {
            String[] types;
            if (!this.explicit) {
                this.datasets = EnumSet.noneOf(PointDatasetType.class);
            }
            this.explicit = true;
            for (String type : types = StringUtil2.splitString(datasetTypes)) {
                try {
                    PointDatasetType fdt = PointDatasetType.valueOf(type);
                    this.datasets.add(fdt);
                }
                catch (Exception e) {
                    log.warn("Dont recognize PointDatasetType " + type);
                }
            }
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("PointConfig: datasetTypes=%s", this.datasets);
            return f.toString();
        }
    }

    public static class BestDataset {
        public String name;
        public double greaterThan;

        public BestDataset(String name, double greaterThan) {
            this.name = name;
            this.greaterThan = greaterThan;
        }
    }

    public static class FmrcConfig {
        public boolean regularize = FeatureCollectionConfig.access$100();
        public Set<FmrcDatasetType> datasets = FeatureCollectionConfig.access$200();
        private boolean explicit = false;
        private List<BestDataset> bestDatasets = null;

        public FmrcConfig() {
        }

        public FmrcConfig(String regularize) {
            this.regularize = regularize != null && regularize.equalsIgnoreCase("true");
        }

        public void addDatasetType(String datasetTypes) {
            String[] types;
            if (!this.explicit) {
                this.datasets = EnumSet.noneOf(FmrcDatasetType.class);
            }
            this.explicit = true;
            for (String type : types = StringUtil2.splitString(datasetTypes)) {
                try {
                    FmrcDatasetType fdt = FmrcDatasetType.valueOf(type);
                    this.datasets.add(fdt);
                }
                catch (Exception e) {
                    log.warn("Dont recognize FmrcDatasetType " + type);
                }
            }
        }

        public void addBestDataset(String name, double greaterEqual) {
            if (this.bestDatasets == null) {
                this.bestDatasets = new ArrayList<BestDataset>(2);
            }
            this.bestDatasets.add(new BestDataset(name, greaterEqual));
        }

        public List<BestDataset> getBestDatasets() {
            return this.bestDatasets;
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("FmrcConfig: regularize=%s datasetTypes=%s", this.regularize, this.datasets);
            if (this.bestDatasets != null) {
                for (BestDataset bd : this.bestDatasets) {
                    f.format("best = (%s, %f) ", bd.name, bd.greaterThan);
                }
            }
            return f.toString();
        }
    }

    public static class ProtoConfig {
        public ProtoChoice choice = ProtoChoice.Penultimate;
        public String param = null;
        public String change = null;
        public Element outerNcml = null;
        public boolean cacheAll = true;

        public ProtoConfig() {
        }

        public ProtoConfig(String choice, String change, String param, Element ncml) {
            if (choice != null) {
                try {
                    this.choice = ProtoChoice.valueOf(choice);
                }
                catch (Exception e) {
                    log.warn("Dont recognize ProtoChoice " + choice);
                }
            }
            this.change = change;
            this.param = param;
            this.outerNcml = ncml;
        }

        public String toString() {
            return "ProtoConfig{choice=" + (Object)((Object)this.choice) + ", change='" + this.change + '\'' + ", param='" + this.param + '\'' + ", outerNcml='" + this.outerNcml + '\'' + ", cacheAll=" + this.cacheAll + '}';
        }
    }

    public static class UpdateConfig {
        public String recheckAfter;
        public String rescan;
        public boolean triggerOk = true;
        public boolean userDefined = false;
        public CollectionUpdateType startupType = CollectionUpdateType.nocheck;
        public CollectionUpdateType updateType = CollectionUpdateType.nocheck;
        public String deleteAfter = null;

        public UpdateConfig() {
        }

        public UpdateConfig(String startupS, String rewriteS, String recheckAfter, String rescan, String triggerS, String deleteAfter) {
            this.rescan = rescan;
            if (recheckAfter != null) {
                this.recheckAfter = recheckAfter;
            }
            if (rescan != null) {
                this.recheckAfter = null;
            }
            this.deleteAfter = deleteAfter;
            if (triggerS != null) {
                this.triggerOk = triggerS.equalsIgnoreCase("allow");
            }
            if (rewriteS == null) {
                rewriteS = startupS;
            }
            if (rewriteS != null) {
                if ((rewriteS = rewriteS.toLowerCase()).equalsIgnoreCase("true")) {
                    this.updateType = CollectionUpdateType.test;
                } else {
                    try {
                        this.updateType = CollectionUpdateType.valueOf(rewriteS);
                    }
                    catch (Throwable t) {
                        log.error("Bad updateType= {} in {}", (Object)rewriteS);
                    }
                }
                this.userDefined = true;
            }
        }

        public String toString() {
            return "UpdateConfig{userDefined=" + this.userDefined + ", recheckAfter='" + this.recheckAfter + '\'' + ", rescan='" + this.rescan + '\'' + ", triggerOk=" + this.triggerOk + ", updateType=" + (Object)((Object)this.updateType) + '}';
        }
    }

    public static enum PartitionType {
        none,
        directory,
        file,
        timePeriod;

    }

    public static enum GribDatasetType {
        TwoD,
        Best,
        Analysis,
        Files,
        Latest,
        LatestFile;

    }

    public static enum PointDatasetType {
        cdmrFeature,
        Files;

    }

    public static enum FmrcDatasetType {
        TwoD,
        Best,
        Files,
        Runs,
        ConstantForecasts,
        ConstantOffsets;

    }

    public static enum ProtoChoice {
        First,
        Random,
        Latest,
        Penultimate,
        Run;

    }
}

