/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.partition;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.CollectionSingleIndexFile;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.partition.PartitionManager;
import ucar.nc2.util.CloseableIterator;

public class PartitionManagerFromIndexList
extends CollectionAbstract
implements PartitionManager {
    private List<MFile> partIndexFiles;
    private final FeatureCollectionConfig config;

    public PartitionManagerFromIndexList(MCollection dcm, List<MFile> partFiles, Logger logger) {
        super(dcm.getCollectionName(), logger);
        this.config = (FeatureCollectionConfig)dcm.getAuxInfo("fcConfig");
        this.root = dcm.getRoot();
        this.partIndexFiles = partFiles;
    }

    @Override
    public Iterable<MCollection> makePartitions(CollectionUpdateType forceCollection) throws IOException {
        return new PartIterator();
    }

    @Override
    public void close() {
    }

    @Override
    public Iterable<MFile> getFilesSorted() throws IOException {
        return null;
    }

    @Override
    public CloseableIterator<MFile> getFileIterator() throws IOException {
        return null;
    }

    private class PartIterator
    implements Iterator<MCollection>,
    Iterable<MCollection> {
        Iterator<MFile> iter;

        private PartIterator() {
            this.iter = PartitionManagerFromIndexList.this.partIndexFiles.iterator();
        }

        @Override
        public Iterator<MCollection> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public MCollection next() {
            MFile nextFile = this.iter.next();
            CollectionSingleIndexFile result = new CollectionSingleIndexFile(nextFile, PartitionManagerFromIndexList.this.logger);
            result.putAuxInfo("fcConfig", PartitionManagerFromIndexList.this.config);
            return result;
        }

        @Override
        public void remove() {
        }
    }
}

