/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.radial.RadialDatasetSweepAdapter;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;

public class Nids2Dataset
extends RadialDatasetSweepAdapter
implements TypedDatasetFactoryIF {
    private NetcdfDataset ds;

    @Override
    public boolean isMine(NetcdfDataset ds) {
        String format;
        String convention = ds.findAttValueIgnoreCase(null, "Conventions", null);
        return null != convention && convention.equals("_Coordinates") && (format = ds.findAttValueIgnoreCase(null, "Format", null)) != null && format.equals("Level3/NIDS");
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new Nids2Dataset(ncd);
    }

    @Override
    public FeatureType getScientificDataType() {
        return FeatureType.RADIAL;
    }

    public Nids2Dataset() {
    }

    public Nids2Dataset(NetcdfDataset ds) {
        super(ds);
        this.ds = ds;
        this.desc = "Nids 2 radar dataset";
        try {
            if (ds.findGlobalAttribute("isRadial").getNumericValue().intValue() == 0) {
                this.parseInfo.append("*** Dataset is not a radial data\n");
                throw new IOException("Dataset is not a radial data\n");
            }
            this.setEarthLocation();
            this.setTimeUnits();
            this.setStartDate();
            this.setEndDate();
            this.setBoundingBox();
        }
        catch (Throwable e) {
            System.err.println("CDM radial dataset failed to open this dataset " + e);
        }
    }

    @Override
    public EarthLocation getCommonOrigin() {
        return this.origin;
    }

    @Override
    public String getRadarID() {
        Attribute att = this.ds.findGlobalAttribute("ProductStation");
        if (att == null) {
            att = this.ds.findGlobalAttribute("Product_station");
        }
        return att.getStringValue();
    }

    @Override
    public boolean isStationary() {
        return true;
    }

    @Override
    public String getRadarName() {
        return this.ds.findGlobalAttribute("ProductStationName").getStringValue();
    }

    @Override
    public String getDataFormat() {
        return "Level III";
    }

    @Override
    public boolean isVolume() {
        return false;
    }

    @Override
    protected void setEarthLocation() {
        double lat = 0.0;
        double lon = 0.0;
        double elev = 0.0;
        Attribute attLat = this.ds.findGlobalAttribute("RadarLatitude");
        Attribute attLon = this.ds.findGlobalAttribute("RadarLongitude");
        Attribute attElev = this.ds.findGlobalAttribute("RadarAltitude");
        try {
            if (attLat == null) {
                throw new IOException("Unable to init radar location!\n");
            }
            lat = attLat.getNumericValue().doubleValue();
            if (attLon == null) {
                throw new IOException("Unable to init radar location!\n");
            }
            lon = attLon.getNumericValue().doubleValue();
            if (attElev == null) {
                throw new IOException("Unable to init radar location!\n");
            }
            elev = attElev.getNumericValue().intValue();
        }
        catch (Throwable e) {
            System.err.println("CDM radial dataset failed to open this dataset " + e);
        }
        this.origin = new EarthLocationImpl(lat, lon, elev);
    }

    @Override
    protected void setTimeUnits() throws Exception {
        CoordinateAxis axis = this.ds.findCoordinateAxis(AxisType.Time);
        if (axis == null) {
            this.parseInfo.append("*** Time Units not Found\n");
        } else {
            String units = axis.getUnitsString();
            this.dateUnits = new DateUnit(units);
            this.calDateUnits = CalendarDateUnit.of(null, units);
        }
    }

    @Override
    protected void setStartDate() {
        String start_datetime = this.ds.findAttValueIgnoreCase(null, "time_coverage_start", null);
        if (start_datetime != null) {
            this.startDate = DateUnit.getStandardOrISO(start_datetime);
            return;
        }
        CoordinateAxis axis = this.ds.findCoordinateAxis(AxisType.Time);
        if (axis != null) {
            double val = axis.getMinValue();
            this.startDate = this.dateUnits.makeDate(val);
            return;
        }
        this.parseInfo.append("*** start_datetime not Found\n");
    }

    @Override
    protected void setEndDate() {
        String end_datetime = this.ds.findAttValueIgnoreCase(null, "time_coverage_end", null);
        if (end_datetime != null) {
            this.endDate = DateUnit.getStandardOrISO(end_datetime);
        } else {
            CoordinateAxis axis = this.ds.findCoordinateAxis(AxisType.Time);
            if (axis != null) {
                double val = axis.getMaxValue();
                this.endDate = this.dateUnits.makeDate(val);
                return;
            }
        }
        this.parseInfo.append("*** end_datetime not Found\n");
    }

    @Override
    protected void addRadialVariable(NetcdfDataset nds, Variable var) {
        Nids2Variable rsvar = null;
        String vName = var.getShortName();
        int rnk = var.getRank();
        if (!var.getShortName().endsWith("RAW") && rnk == 2) {
            RadialDatasetSweepAdapter.MyRadialVariableAdapter v = new RadialDatasetSweepAdapter.MyRadialVariableAdapter(vName, var.getAttributes());
            rsvar = new Nids2Variable(nds, v, var);
        }
        if (rsvar != null) {
            this.dataVariables.add(rsvar);
        }
    }

    @Override
    public void clearDatasetMemory() {
        List<VariableSimpleIF> rvars = this.getDataVariables();
        for (RadialDatasetSweep.RadialVariable radialVariable : rvars) {
            radialVariable.clearVariableMemory();
        }
    }

    @Override
    protected RadialDatasetSweep.RadialVariable makeRadialVariable(NetcdfDataset nds, VariableSimpleIF v, Variable v0) {
        return null;
    }

    public String getInfo() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Nids2Dataset\n");
        sbuff.append(super.getDetailInfo());
        sbuff.append("\n\n");
        sbuff.append(this.parseInfo.toString());
        return sbuff.toString();
    }

    private static void testRadialVariable(RadialDatasetSweep.RadialVariable rv) throws IOException {
        int nsweep = rv.getNumSweeps();
        System.out.println("*** radar Sweep number is: \n" + nsweep);
        RadialDatasetSweep.Sweep sw = rv.getSweep(0);
        float gsize = sw.getGateSize();
        System.out.println("*** radar Sweep gate is: \n" + gsize);
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        String fileIn1 = "/home/yuanho/Desktop/TBWI/TBWI.78ohp.20080829_1619";
        String fileIn = "/home/yuanho/Desktop/TBWI/TBWI.181r0.20080829_1620";
        RadialDatasetSweep rds = (RadialDatasetSweep)TypedDatasetFactory.open(FeatureType.RADIAL, fileIn, null, new StringBuilder());
        RadialDatasetSweep rds1 = (RadialDatasetSweep)TypedDatasetFactory.open(FeatureType.RADIAL, fileIn1, null, new StringBuilder());
        RadialDatasetSweep.RadialVariable rf = (RadialDatasetSweep.RadialVariable)rds.getDataVariable("BaseReflectivity");
        Nids2Dataset.testRadialVariable(rf);
        RadialDatasetSweep.RadialVariable rf1 = (RadialDatasetSweep.RadialVariable)rds1.getDataVariable("Precip1hr");
        Nids2Dataset.testRadialVariable(rf1);
    }

    private class Nids2Variable
    extends RadialDatasetSweepAdapter.MyRadialVariableAdapter
    implements RadialDatasetSweep.RadialVariable {
        ArrayList sweeps;
        String name;

        private Nids2Variable(NetcdfDataset nds, VariableSimpleIF v, Variable v0) {
            super(v.getShortName(), v0.getAttributes());
            this.sweeps = new ArrayList();
            this.name = v.getShortName();
            int[] shape = v0.getShape();
            int count = v0.getRank() - 1;
            int ngates = shape[count];
            int nrays = shape[--count];
            --count;
            this.sweeps.add(new Nids2Sweep(nds, v0, 0, nrays, ngates));
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public float[] readAllData() throws IOException {
            Array allData;
            RadialDatasetSweep.Sweep spn = (RadialDatasetSweep.Sweep)this.sweeps.get(0);
            Variable v = spn.getsweepVar();
            try {
                allData = v.read();
            }
            catch (IOException e) {
                throw new IOException(e.getMessage());
            }
            return (float[])allData.get1DJavaArray(Float.TYPE);
        }

        @Override
        public int getNumSweeps() {
            return 1;
        }

        @Override
        public RadialDatasetSweep.Sweep getSweep(int sn) {
            if (sn != 0) {
                return null;
            }
            return (RadialDatasetSweep.Sweep)this.sweeps.get(sn);
        }

        @Override
        public void clearVariableMemory() {
        }

        private class Nids2Sweep
        implements RadialDatasetSweep.Sweep {
            double meanElevation = Double.NaN;
            double meanAzimuth = Double.NaN;
            double gateSize = Double.NaN;
            int nrays;
            int ngates;
            Variable sweepVar;
            NetcdfDataset ds;

            Nids2Sweep(NetcdfDataset nds, Variable v, int sweepno, int rays, int gates) {
                this.sweepVar = v;
                this.nrays = rays;
                this.ngates = gates;
                this.ds = nds;
            }

            @Override
            public Variable getsweepVar() {
                return this.sweepVar;
            }

            private void setMeanElevation() {
                if (Double.isNaN(this.meanElevation)) {
                    try {
                        Variable sp = this.ds.findVariable("elevation");
                        Array spData = sp.read();
                        sp.setCachedData(spData, false);
                        this.meanElevation = MAMath.sumDouble(spData) / (double)spData.getSize();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.meanElevation = 0.0;
                    }
                }
            }

            @Override
            public float getMeanElevation() {
                if (Double.isNaN(this.meanElevation)) {
                    this.setMeanElevation();
                }
                return (float)this.meanElevation;
            }

            private void setMeanAzimuth() {
                if (this.getType() != null) {
                    Array spData = null;
                    try {
                        Variable sp = this.ds.findVariable("azimuth");
                        spData = sp.read();
                        sp.setCachedData(spData, false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.meanAzimuth = 0.0;
                    }
                    this.meanAzimuth = MAMath.sumDouble(spData) / (double)spData.getSize();
                } else {
                    this.meanAzimuth = 0.0;
                }
            }

            @Override
            public float getMeanAzimuth() {
                if (Double.isNaN(this.meanAzimuth)) {
                    this.setMeanAzimuth();
                }
                return (float)this.meanAzimuth;
            }

            public int getNumRadials() {
                return this.nrays;
            }

            public int getNumGates() {
                return this.ngates;
            }

            @Override
            public float[] readData() throws IOException {
                Array allData = null;
                int[] shape = this.sweepVar.getShape();
                int[] origind = new int[this.sweepVar.getRank()];
                try {
                    allData = this.sweepVar.read(origind, shape);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e.getMessage());
                }
                return (float[])allData.get1DJavaArray(Float.TYPE);
            }

            @Override
            public float[] readData(int ray) throws IOException {
                Array rayData;
                int[] shape = this.sweepVar.getShape();
                int[] origind = new int[this.sweepVar.getRank()];
                shape[0] = 1;
                origind[0] = ray;
                try {
                    rayData = this.sweepVar.read(origind, shape);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e.getMessage());
                }
                return (float[])rayData.get1DJavaArray(Float.TYPE);
            }

            @Override
            public RadialDatasetSweep.Type getType() {
                return null;
            }

            public boolean isConic() {
                return true;
            }

            @Override
            public float getElevation(int ray) throws IOException {
                return (float)this.meanElevation;
            }

            @Override
            public float[] getElevation() throws IOException {
                float[] spArray = null;
                try {
                    Variable sp = this.ds.findVariable("elevation");
                    Array spData = sp.read();
                    sp.setCachedData(spData, false);
                    spArray = (float[])spData.get1DJavaArray(Float.TYPE);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return spArray;
            }

            @Override
            public float getAzimuth(int ray) throws IOException {
                Variable sp = this.ds.findVariable("azimuth");
                Array spData = sp.read();
                sp.setCachedData(spData, false);
                Index index = spData.getIndex();
                return spData.getFloat(index.set(ray));
            }

            @Override
            public float[] getAzimuth() throws IOException {
                Variable sp = this.ds.findVariable("azimuth");
                Array spData = sp.read();
                sp.setCachedData(spData, false);
                return (float[])spData.get1DJavaArray(Float.TYPE);
            }

            public float getRadialDistance(int gate) throws IOException {
                Variable sp = this.ds.findVariable("gate");
                Array spData = sp.read();
                sp.setCachedData(spData, false);
                Index index = spData.getIndex();
                return spData.getFloat(index.set(gate));
            }

            @Override
            public float getTime(int ray) throws IOException {
                Variable sp = this.ds.findVariable("rays_time");
                Array timeData = sp.read();
                sp.setCachedData(timeData, false);
                Index index = timeData.getIndex();
                return timeData.getFloat(index.set(ray));
            }

            @Override
            public float getBeamWidth() {
                return 0.95f;
            }

            @Override
            public float getNyquistFrequency() {
                return 0.0f;
            }

            @Override
            public float getRangeToFirstGate() {
                return 0.0f;
            }

            @Override
            public float getGateSize() {
                try {
                    if (Double.isNaN(this.gateSize)) {
                        this.gateSize = this.getRadialDistance(1) - this.getRadialDistance(0);
                    }
                    return (float)this.gateSize;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }

            @Override
            public Date getStartingTime() {
                return Nids2Dataset.this.startDate;
            }

            @Override
            public Date getEndingTime() {
                return Nids2Dataset.this.endDate;
            }

            public boolean isGateSizeConstant() {
                return true;
            }

            @Override
            public int getGateNumber() {
                return this.ngates;
            }

            @Override
            public int getRadialNumber() {
                return this.nrays;
            }

            @Override
            public EarthLocation getOrigin(int ray) {
                return Nids2Dataset.this.origin;
            }

            @Override
            public int getSweepIndex() {
                return 0;
            }

            @Override
            public void clearSweepMemory() {
            }
        }
    }
}

