/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset.s3;

import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.crawlabledataset.s3.S3URI;
import thredds.crawlabledataset.s3.ThreddsS3Client;

public class CachingThreddsS3Client
implements ThreddsS3Client {
    private static final Logger logger = LoggerFactory.getLogger(CachingThreddsS3Client.class);
    private static final long ENTRY_EXPIRATION_TIME = 600L;
    private static final long MAX_METADATA_ENTRIES = 10000L;
    private static final long MAX_FILE_ENTRIES = 100L;
    private final ThreddsS3Client threddsS3Client;
    private final Cache<S3URI, Optional<ObjectMetadata>> objectMetadataCache;
    private final Cache<S3URI, Optional<ObjectListing>> objectListingCache;
    private final Cache<S3URI, Optional<File>> objectFileCache;

    public CachingThreddsS3Client(ThreddsS3Client threddsS3Client) {
        this(threddsS3Client, new ObjectFileCacheRemovalListener());
    }

    public CachingThreddsS3Client(ThreddsS3Client threddsS3Client, RemovalListener<S3URI, Optional<File>> removalListener) {
        this.threddsS3Client = threddsS3Client;
        this.objectMetadataCache = CacheBuilder.newBuilder().expireAfterAccess(600L, TimeUnit.SECONDS).maximumSize(10000L).build();
        this.objectListingCache = CacheBuilder.newBuilder().expireAfterAccess(600L, TimeUnit.SECONDS).maximumSize(10000L).build();
        this.objectFileCache = CacheBuilder.newBuilder().expireAfterAccess(600L, TimeUnit.SECONDS).maximumSize(100L).removalListener(removalListener).build();
    }

    @Override
    public ObjectMetadata getObjectMetadata(S3URI s3uri) {
        Optional metadata = (Optional)this.objectMetadataCache.getIfPresent((Object)s3uri);
        if (metadata == null) {
            logger.debug(String.format("ObjectMetadata cache MISS: '%s'", s3uri));
            metadata = Optional.fromNullable((Object)this.threddsS3Client.getObjectMetadata(s3uri));
            this.objectMetadataCache.put((Object)s3uri, (Object)metadata);
        } else {
            logger.debug(String.format("ObjectMetadata cache hit: '%s'", s3uri));
        }
        return (ObjectMetadata)metadata.orNull();
    }

    @Override
    public ObjectListing listObjects(S3URI s3uri) {
        Optional objectListing = (Optional)this.objectListingCache.getIfPresent((Object)s3uri);
        if (objectListing == null) {
            logger.debug(String.format("ObjectListing cache MISS: '%s'", s3uri));
            objectListing = Optional.fromNullable((Object)this.threddsS3Client.listObjects(s3uri));
            this.objectListingCache.put((Object)s3uri, (Object)objectListing);
        } else {
            logger.debug(String.format("ObjectListing cache hit: '%s'", s3uri));
        }
        return (ObjectListing)objectListing.orNull();
    }

    @Override
    public File saveObjectToFile(S3URI s3uri, File file) throws IOException {
        Optional cachedFile = (Optional)this.objectFileCache.getIfPresent((Object)s3uri);
        if (cachedFile == null) {
            logger.debug("Object cache MISS: '%s'", (Object)s3uri);
        } else {
            logger.debug("Object cache hit: '%s'", (Object)s3uri);
            if (!cachedFile.isPresent()) {
                return null;
            }
            if (!((File)cachedFile.get()).exists()) {
                logger.info(String.format("Found cache entry {'%s'-->'%s'}, but local file doesn't exist. Was it deleted? Re-downloading.", s3uri, cachedFile.get()));
                this.objectFileCache.invalidate((Object)s3uri);
            } else {
                if (!((File)cachedFile.get()).equals(file)) {
                    Files.copy((File)((File)cachedFile.get()), (File)file);
                    this.objectFileCache.put((Object)s3uri, (Object)Optional.of((Object)file));
                    return file;
                }
                return file;
            }
        }
        cachedFile = Optional.fromNullable((Object)this.threddsS3Client.saveObjectToFile(s3uri, file));
        this.objectFileCache.put((Object)s3uri, (Object)cachedFile);
        return (File)cachedFile.orNull();
    }

    public void clear() {
        this.objectMetadataCache.invalidateAll();
        this.objectListingCache.invalidateAll();
        this.objectFileCache.invalidateAll();
    }

    private static class ObjectFileCacheRemovalListener
    implements RemovalListener<S3URI, Optional<File>> {
        private ObjectFileCacheRemovalListener() {
        }

        public void onRemoval(RemovalNotification<S3URI, Optional<File>> notification) {
            Optional file = (Optional)notification.getValue();
            assert (file != null) : "Silence a silly IntelliJ warning. Of course the Optional isn't null.";
            if (file.isPresent()) {
                ((File)file.get()).delete();
            }
        }
    }
}

