/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset.s3;

import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFile;
import thredds.crawlabledataset.s3.CachingThreddsS3Client;
import thredds.crawlabledataset.s3.S3URI;
import thredds.crawlabledataset.s3.ThreddsS3Client;
import thredds.crawlabledataset.s3.ThreddsS3ClientImpl;

public class CrawlableDatasetAmazonS3
extends CrawlableDatasetFile {
    private static final Logger logger = LoggerFactory.getLogger(CrawlableDatasetAmazonS3.class);
    private static ThreddsS3Client defaultThreddsS3Client;
    private final S3URI s3uri;
    private final ThreddsS3Client threddsS3Client;

    public CrawlableDatasetAmazonS3(String path, Object configObject) {
        this(new S3URI(path), configObject);
    }

    public CrawlableDatasetAmazonS3(S3URI s3uri, Object configObject) {
        this(s3uri, configObject, CrawlableDatasetAmazonS3.getDefaultThreddsS3Client());
    }

    public CrawlableDatasetAmazonS3(S3URI s3uri, Object configObject, ThreddsS3Client threddsS3Client) {
        super(s3uri.toString(), configObject);
        this.s3uri = s3uri;
        this.threddsS3Client = threddsS3Client;
    }

    public static ThreddsS3Client getDefaultThreddsS3Client() {
        if (defaultThreddsS3Client == null) {
            defaultThreddsS3Client = new CachingThreddsS3Client(new ThreddsS3ClientImpl());
        }
        return defaultThreddsS3Client;
    }

    public static void setDefaultThreddsS3Client(ThreddsS3Client threddsS3Client) {
        defaultThreddsS3Client = threddsS3Client;
    }

    public S3URI getS3URI() {
        return this.s3uri;
    }

    @Override
    public File getFile() {
        try {
            return this.threddsS3Client.saveObjectToFile(this.s3uri, this.s3uri.createTempFile());
        }
        catch (IOException e) {
            logger.error(String.format("Could not save S3 object '%s' to file.", this.s3uri), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getPath() {
        return this.s3uri.toString();
    }

    @Override
    public String getName() {
        return this.s3uri.getBaseName();
    }

    @Override
    public CrawlableDataset getParentDataset() {
        return new CrawlableDatasetAmazonS3(this.s3uri.getParent(), this.getConfigObject());
    }

    @Override
    public boolean exists() {
        return this.threddsS3Client.getObjectMetadata(this.s3uri) != null || this.isCollection();
    }

    @Override
    public boolean isCollection() {
        return this.threddsS3Client.listObjects(this.s3uri) != null;
    }

    @Override
    public CrawlableDataset getDescendant(String relativePath) {
        return new CrawlableDatasetAmazonS3(this.s3uri.getChild(relativePath), this.getConfigObject());
    }

    @Override
    public List<CrawlableDataset> listDatasets() throws IOException {
        CrawlableDatasetAmazonS3 crawlableDset;
        S3URI childS3uri;
        if (!this.isCollection()) {
            String tmpMsg = String.format("'%s' is not a collection dataset.", this.s3uri);
            logger.error("listDatasets(): " + tmpMsg);
            throw new IllegalStateException(tmpMsg);
        }
        ObjectListing objectListing = this.threddsS3Client.listObjects(this.s3uri);
        assert (objectListing != null) : "We checked this in the isCollection() call above.";
        ArrayList<CrawlableDataset> list = new ArrayList<CrawlableDataset>();
        for (S3ObjectSummary objectSummary : objectListing.getObjectSummaries()) {
            childS3uri = new S3URI(objectSummary.getBucketName(), objectSummary.getKey());
            crawlableDset = new CrawlableDatasetAmazonS3(childS3uri, this.getConfigObject());
            list.add(crawlableDset);
        }
        for (String commonPrefix : objectListing.getCommonPrefixes()) {
            childS3uri = new S3URI(this.s3uri.getBucket(), commonPrefix);
            crawlableDset = new CrawlableDatasetAmazonS3(childS3uri, this.getConfigObject());
            list.add(crawlableDset);
        }
        assert (!list.isEmpty()) : "This is a collection and collections shouldn't be empty.";
        return list;
    }

    @Override
    public long length() {
        ObjectMetadata metadata = this.threddsS3Client.getObjectMetadata(this.s3uri);
        if (metadata != null) {
            return metadata.getContentLength();
        }
        return 0L;
    }

    @Override
    public Date lastModified() {
        ObjectMetadata metadata = this.threddsS3Client.getObjectMetadata(this.s3uri);
        if (metadata != null) {
            return metadata.getLastModified();
        }
        return null;
    }
}

