/*
 * Copyright 1998-2015 John Caron and University Corporation for Atmospheric Research/Unidata
 *
 *  Portions of this software were developed by the Unidata Program at the
 *  University Corporation for Atmospheric Research.
 *
 *  Access and use of this software shall impose the following obligations
 *  and understandings on the user. The user is granted the right, without
 *  any fee or cost, to use, copy, modify, alter, enhance and distribute
 *  this software, and any derivative works thereof, and its supporting
 *  documentation for any purpose whatsoever, provided that this entire
 *  notice appears in all copies of the software, derivative works and
 *  supporting documentation.  Further, UCAR requests that the user credit
 *  UCAR/Unidata in any publications that result from the use of this
 *  software or in any product that includes this software. The names UCAR
 *  and/or Unidata, however, may not be used in any advertising or publicity
 *  to endorse or promote any products or commercial entity unless specific
 *  written permission is obtained from UCAR/Unidata. The user also
 *  understands that UCAR/Unidata is not obligated to provide the user with
 *  any support, consulting, training or assistance of any kind with regard
 *  to the use, operation and performance of this software nor to provide
 *  the user with any updates, revisions, new versions or "bug fixes."
 *
 *  THIS SOFTWARE IS PROVIDED BY UCAR/UNIDATA "AS IS" AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL UCAR/UNIDATA BE LIABLE FOR ANY SPECIAL,
 *  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *  FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *  NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *  WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE.
 */
package ucar.nc2.ft;

import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.adapter.DtCoverageAdapter;
import ucar.nc2.ft2.coverage.adapter.DtCoverageCSBuilder;
import ucar.nc2.ft2.coverage.adapter.DtCoverageDataset;
import ucar.nc2.util.CancelTask;

import java.io.IOException;
import java.util.Formatter;

/**
 * FeatureDatasetFactory for Grids, using standard coord sys analysis and ucar.nc2.ft2.coverage.adapter.DtCoverageCSBuilder
 * @author caron
 * @since Dec 30, 2008
 */
public class GridDatasetStandardFactory implements FeatureDatasetFactory {

  public Object isMine(FeatureType wantFeatureType, NetcdfDataset ncd, Formatter errlog) throws IOException {
    DtCoverageCSBuilder dtCoverage = DtCoverageCSBuilder.classify(ncd, errlog);
    if (dtCoverage == null || dtCoverage.getCoverageType() == null) return null;
    if (!match(wantFeatureType, dtCoverage.getCoverageType())) return null;
    return dtCoverage;
  }

  private boolean match(FeatureType wantFeatureType, FeatureType covType) {
    if (wantFeatureType == null || wantFeatureType == FeatureType.ANY) return true;
    // LOOK ever have to return false?
    return true;
  }

  public FeatureDataset open(FeatureType ftype, NetcdfDataset ncd, Object analysis, CancelTask task, Formatter errlog) throws IOException {
    // already been opened by isMine
    // DtCoverageCSBuilder dtCoverage =  (DtCoverageCSBuilder) analysis;

    // look - use GridDataset 2/24/2016
    //DtCoverageDataset dt = DtCoverageDataset.open(ncd);
    //return DtCoverageAdapter.factory(dt, errlog);

    return new ucar.nc2.dt.grid.GridDataset( ncd);
  }

  public FeatureType[] getFeatureTypes() {
    return new FeatureType[] {FeatureType.GRID, FeatureType.FMRC, FeatureType.SWATH};
  }
}
