/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.writer;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.HorizCoordSys;
import ucar.nc2.ft2.coverage.HorizCoordSys2D;
import ucar.nc2.ft2.coverage.LatLonAxis2D;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;

public class CoverageBoundariesExtractor {
    private CoverageCollection gridDataset;
    private double minLon = 0.0;
    private double maxLon = 0.0;
    private double maxDiffLon = 0.0;
    private boolean crossesDateLine = false;

    public static String getDatasetBoundariesWKT(CoverageCollection cc) {
        CoverageBoundariesExtractor extract = new CoverageBoundariesExtractor(cc);
        return extract.getBoundaryAsWKT();
    }

    public CoverageBoundariesExtractor(CoverageCollection gridDataset) {
        this.gridDataset = gridDataset;
    }

    public List<LatLonPoint> getBoundaryPoints() {
        HorizCoordSys hcs = this.gridDataset.getHorizCoordSys();
        List<LatLonPoint> latlons = hcs.getIsProjection() ? this.getLatLonsFromProjection(hcs) : (hcs.isLatLon2D() ? this.getLatLons2D((HorizCoordSys2D)hcs) : this.getLatLons1D(hcs));
        return latlons;
    }

    public String getBoundaryAsWKT() {
        List<LatLonPoint> latlons = this.getBoundaryPoints();
        if (this.maxLon > 0.0 && this.minLon < 0.0 && this.maxDiffLon > 270.0) {
            this.crossesDateLine = true;
        }
        Formatter result = new Formatter();
        result.format("POLYGON((", new Object[0]);
        int nPoints = latlons.size();
        for (int i = 0; i < nPoints; ++i) {
            double lon = latlons.get(i).getLongitude();
            if (this.crossesDateLine && lon < 0.0) {
                lon += 360.0;
            }
            if (i > 0) {
                result.format(",", new Object[0]);
            }
            result.format("%f %f", lon, latlons.get(i).getLatitude());
        }
        result.format("))", new Object[0]);
        return result.toString();
    }

    private List<LatLonPoint> getLatLonsFromProjection(HorizCoordSys hcs) {
        ArrayList<LatLonPoint> latLonPoints = new ArrayList<LatLonPoint>();
        ProjectionImpl fromProj = hcs.getTransform().getProjection();
        CoverageCoordAxis1D xAxis = hcs.getXAxis();
        CoverageCoordAxis1D yAxis = hcs.getYAxis();
        int nx = xAxis.getNcoords();
        int ny = yAxis.getNcoords();
        int stridex = Math.max(1, nx / 100);
        int stridey = Math.max(1, ny / 100);
        double y0 = yAxis.getCoordEdge1(0);
        LatLonPoint prev = fromProj.projToLatLon(xAxis.getCoordEdge1(0), y0);
        latLonPoints.add(prev);
        for (int i = 0; i < nx; i += stridex) {
            LatLonPoint point = fromProj.projToLatLon(xAxis.getCoordEdge2(i), y0);
            this.check(prev, point);
            latLonPoints.add(point);
            prev = point;
        }
        double xlast = xAxis.getCoordEdgeLast();
        for (int j = 0; j < ny; j += stridey) {
            LatLonPoint point = fromProj.projToLatLon(xlast, yAxis.getCoordEdge2(j));
            this.check(prev, point);
            latLonPoints.add(point);
            prev = point;
        }
        double ylast = yAxis.getCoordEdgeLast();
        for (int i = nx - 1; i >= 0; i -= stridex) {
            LatLonPoint point = fromProj.projToLatLon(xAxis.getCoordEdge1(i), ylast);
            this.check(prev, point);
            latLonPoints.add(point);
            prev = point;
        }
        double x0 = xAxis.getCoordEdge1(0);
        for (int j = ny - 1; j >= 0; j -= stridey) {
            LatLonPoint point = fromProj.projToLatLon(x0, yAxis.getCoordEdge1(j));
            this.check(prev, point);
            latLonPoints.add(point);
            prev = point;
        }
        return latLonPoints;
    }

    private void check(LatLonPoint prev, LatLonPoint point) {
        if (point.getLongitude() < this.minLon) {
            this.minLon = point.getLongitude();
        }
        if (point.getLongitude() > this.maxLon) {
            this.maxLon = point.getLongitude();
        }
        if (Math.abs(prev.getLongitude() - point.getLongitude()) > this.maxDiffLon) {
            this.maxDiffLon = Math.abs(prev.getLongitude() - point.getLongitude());
        }
    }

    private List<LatLonPoint> getLatLons1D(HorizCoordSys hcs) {
        ArrayList<LatLonPoint> latLonPoints = new ArrayList<LatLonPoint>();
        CoverageCoordAxis1D latAxis = hcs.getYAxis();
        CoverageCoordAxis1D lonAxis = hcs.getXAxis();
        latLonPoints.add(new LatLonPointImpl(latAxis.getCoordEdge1(0), lonAxis.getCoordEdge1(0)));
        latLonPoints.add(new LatLonPointImpl(latAxis.getCoordEdge1(0), lonAxis.getCoordEdgeLast()));
        latLonPoints.add(new LatLonPointImpl(latAxis.getCoordEdgeLast(), lonAxis.getCoordEdgeLast()));
        latLonPoints.add(new LatLonPointImpl(latAxis.getCoordEdgeLast(), lonAxis.getCoordEdge1(0)));
        return latLonPoints;
    }

    private List<LatLonPoint> getLatLons2D(HorizCoordSys2D hcs) {
        int j;
        LatLonPointImpl point;
        double x;
        double y;
        int i;
        ArrayList<LatLonPoint> latLonPoints = new ArrayList<LatLonPoint>();
        LatLonAxis2D latAxis = hcs.getLatAxis2D();
        LatLonAxis2D lonAxis = hcs.getLonAxis2D();
        int[] shape = latAxis.getShape();
        int ny = shape[0];
        int nx = shape[1];
        int stridex = Math.max(1, nx / 100);
        int stridey = Math.max(1, ny / 100);
        double y0 = latAxis.getCoord(0, 0);
        double x0 = lonAxis.getCoord(0, 0);
        LatLonPointImpl prev = new LatLonPointImpl(y0, x0);
        latLonPoints.add(prev);
        for (i = 0; i < nx; i += stridex) {
            y = latAxis.getCoord(0, i);
            x = lonAxis.getCoord(0, i);
            point = new LatLonPointImpl(y, x);
            this.check(prev, point);
            latLonPoints.add(point);
            prev = point;
        }
        for (j = 0; j < ny; j += stridey) {
            y = latAxis.getCoord(j, nx - 1);
            x = lonAxis.getCoord(j, nx - 1);
            point = new LatLonPointImpl(y, x);
            this.check(prev, point);
            latLonPoints.add(point);
            prev = point;
        }
        for (i = nx - 1; i >= 0; i -= stridex) {
            y = latAxis.getCoord(ny - 1, i);
            x = lonAxis.getCoord(ny - 1, i);
            point = new LatLonPointImpl(y, x);
            this.check(prev, point);
            latLonPoints.add(point);
            prev = point;
        }
        for (j = ny - 1; j >= 0; j -= stridey) {
            y = latAxis.getCoord(j, 0);
            x = lonAxis.getCoord(j, 0);
            point = new LatLonPointImpl(y, x);
            this.check(prev, point);
            latLonPoints.add(point);
            prev = point;
        }
        return latLonPoints;
    }
}

