/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;

public class CoordinateSystem {
    private static Logger log = LoggerFactory.getLogger(CoordinateSystem.class);
    protected NetcdfDataset ds;
    protected List<CoordinateAxis> coordAxes = new ArrayList<CoordinateAxis>();
    protected List<CoordinateTransform> coordTrans = new ArrayList<CoordinateTransform>();
    protected Set<Dimension> domain = new HashSet<Dimension>();
    protected String name;
    protected CoordinateAxis xAxis;
    protected CoordinateAxis yAxis;
    protected CoordinateAxis zAxis;
    protected CoordinateAxis tAxis;
    protected CoordinateAxis latAxis;
    protected CoordinateAxis lonAxis;
    protected CoordinateAxis hAxis;
    protected CoordinateAxis pAxis;
    protected CoordinateAxis ensAxis;
    protected CoordinateAxis aziAxis;
    protected CoordinateAxis elevAxis;
    protected CoordinateAxis radialAxis;
    protected boolean isImplicit;
    protected String dataType;
    private ProjectionImpl projection = null;
    private volatile int hashCode = 0;

    public static String makeName(List<CoordinateAxis> axes) {
        ArrayList<CoordinateAxis> axesSorted = new ArrayList<CoordinateAxis>(axes);
        Collections.sort(axesSorted, new CoordinateAxis.AxisComparator());
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < axesSorted.size(); ++i) {
            CoordinateAxis axis = (CoordinateAxis)axesSorted.get(i);
            if (i > 0) {
                buff.append(" ");
            }
            buff.append(axis.getFullNameEscaped());
        }
        return buff.toString();
    }

    protected CoordinateSystem() {
    }

    public CoordinateSystem(NetcdfDataset ds, Collection<CoordinateAxis> axes, Collection<CoordinateTransform> coordTrans) {
        this.ds = ds;
        this.coordAxes = new ArrayList<CoordinateAxis>(axes);
        this.name = CoordinateSystem.makeName(this.coordAxes);
        if (coordTrans != null) {
            this.coordTrans = new ArrayList<CoordinateTransform>(coordTrans);
        }
        for (CoordinateAxis axis : this.coordAxes) {
            AxisType axisType = axis.getAxisType();
            if (axisType != null) {
                if (axisType == AxisType.GeoX) {
                    this.xAxis = this.lesserRank(this.xAxis, axis);
                }
                if (axisType == AxisType.GeoY) {
                    this.yAxis = this.lesserRank(this.yAxis, axis);
                }
                if (axisType == AxisType.GeoZ) {
                    this.zAxis = this.lesserRank(this.zAxis, axis);
                }
                if (axisType == AxisType.Time) {
                    this.tAxis = this.lesserRank(this.tAxis, axis);
                }
                if (axisType == AxisType.Lat) {
                    this.latAxis = this.lesserRank(this.latAxis, axis);
                }
                if (axisType == AxisType.Lon) {
                    this.lonAxis = this.lesserRank(this.lonAxis, axis);
                }
                if (axisType == AxisType.Height) {
                    this.hAxis = this.lesserRank(this.hAxis, axis);
                }
                if (axisType == AxisType.Pressure) {
                    this.pAxis = this.lesserRank(this.pAxis, axis);
                }
                if (axisType == AxisType.Ensemble) {
                    this.ensAxis = this.lesserRank(this.ensAxis, axis);
                }
                if (axisType == AxisType.RadialAzimuth) {
                    this.aziAxis = this.lesserRank(this.aziAxis, axis);
                }
                if (axisType == AxisType.RadialDistance) {
                    this.radialAxis = this.lesserRank(this.radialAxis, axis);
                }
                if (axisType == AxisType.RadialElevation) {
                    this.elevAxis = this.lesserRank(this.elevAxis, axis);
                }
            }
            List<Dimension> dims = axis.getDimensionsAll();
            for (Dimension dim : dims) {
                if (this.domain.contains(dim)) continue;
                this.domain.add(dim);
            }
        }
    }

    private CoordinateAxis lesserRank(CoordinateAxis a1, CoordinateAxis a2) {
        if (a1 == null) {
            return a2;
        }
        return a1.getRank() <= a2.getRank() ? a1 : a2;
    }

    public void addCoordinateTransform(CoordinateTransform ct) {
        this.coordTrans.add(ct);
        this.ds.addCoordinateTransform(ct);
    }

    public void addCoordinateTransforms(Collection<CoordinateTransform> ct) {
        if (ct != null) {
            this.coordTrans.addAll(ct);
        }
    }

    public List<CoordinateAxis> getCoordinateAxes() {
        return this.coordAxes;
    }

    public List<CoordinateTransform> getCoordinateTransforms() {
        return this.coordTrans;
    }

    public String getName() {
        return this.name;
    }

    public NetcdfDataset getNetcdfDataset() {
        return this.ds;
    }

    public Collection<Dimension> getDomain() {
        return this.domain;
    }

    public int getRankDomain() {
        return this.domain.size();
    }

    public int getRankRange() {
        return this.coordAxes.size();
    }

    public CoordinateAxis findAxis(AxisType type) {
        CoordinateAxis result = null;
        for (CoordinateAxis axis : this.coordAxes) {
            AxisType axisType = axis.getAxisType();
            if (axisType == null || axisType != type) continue;
            result = this.lesserRank(result, axis);
        }
        return result;
    }

    public CoordinateAxis getXaxis() {
        return this.xAxis;
    }

    public CoordinateAxis getYaxis() {
        return this.yAxis;
    }

    public CoordinateAxis getZaxis() {
        return this.zAxis;
    }

    public CoordinateAxis getTaxis() {
        return this.tAxis;
    }

    public CoordinateAxis getLatAxis() {
        return this.latAxis;
    }

    public CoordinateAxis getLonAxis() {
        return this.lonAxis;
    }

    public CoordinateAxis getHeightAxis() {
        return this.hAxis;
    }

    public CoordinateAxis getPressureAxis() {
        return this.pAxis;
    }

    public CoordinateAxis getEnsembleAxis() {
        return this.ensAxis;
    }

    public CoordinateAxis getAzimuthAxis() {
        return this.aziAxis;
    }

    public CoordinateAxis getRadialAxis() {
        return this.radialAxis;
    }

    public CoordinateAxis getElevationAxis() {
        return this.elevAxis;
    }

    public ProjectionCT getProjectionCT() {
        for (CoordinateTransform ct : this.coordTrans) {
            if (!(ct instanceof ProjectionCT)) continue;
            return (ProjectionCT)ct;
        }
        return null;
    }

    public ProjectionImpl getProjection() {
        if (this.projection == null) {
            ProjectionCT projCT;
            if (this.isLatLon()) {
                this.projection = new LatLonProjection();
            }
            if (null != (projCT = this.getProjectionCT())) {
                this.projection = projCT.getProjection();
            }
        }
        return this.projection;
    }

    public boolean isGeoXY() {
        if (this.xAxis == null || this.yAxis == null) {
            return false;
        }
        return null != this.getProjection() && !(this.projection instanceof LatLonProjection);
    }

    public boolean isLatLon() {
        return this.latAxis != null && this.lonAxis != null;
    }

    public boolean isRadial() {
        return this.radialAxis != null && this.aziAxis != null;
    }

    public boolean isGeoReferencing() {
        return this.isGeoXY() || this.isLatLon();
    }

    public boolean isProductSet() {
        for (CoordinateAxis axis : this.coordAxes) {
            if (axis instanceof CoordinateAxis1D) continue;
            return false;
        }
        return true;
    }

    public boolean isRegular() {
        for (CoordinateAxis axis : this.coordAxes) {
            if (!(axis instanceof CoordinateAxis1D)) {
                return false;
            }
            if (((CoordinateAxis1D)axis).isRegular()) continue;
            return false;
        }
        return true;
    }

    public boolean isComplete(VariableIF v) {
        return CoordinateSystem.isSubset(v.getDimensionsAll(), this.domain);
    }

    public boolean isCoordinateSystemFor(VariableIF v) {
        return CoordinateSystem.isSubset(this.domain, v.getDimensionsAll());
    }

    public static boolean isSubset(Collection<Dimension> subset, Collection<Dimension> set) {
        for (Dimension d : subset) {
            if (set.contains(d)) continue;
            return false;
        }
        return true;
    }

    public static Set<Dimension> makeDomain(Iterable<? extends Variable> axes) {
        HashSet<Dimension> domain = new HashSet<Dimension>();
        for (Variable variable : axes) {
            for (Dimension dim : variable.getDimensions()) {
                domain.add(dim);
            }
        }
        return domain;
    }

    public static int countDomain(Variable[] axes) {
        HashSet<Dimension> domain = new HashSet<Dimension>();
        for (Variable axis : axes) {
            for (Dimension dim : axis.getDimensions()) {
                domain.add(dim);
            }
        }
        return domain.size();
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    protected void setImplicit(boolean isImplicit) {
        this.isImplicit = isImplicit;
    }

    public boolean hasVerticalAxis() {
        return this.hAxis != null || this.pAxis != null || this.zAxis != null;
    }

    public boolean hasTimeAxis() {
        return this.tAxis != null;
    }

    public boolean containsAxes(List<CoordinateAxis> wantAxes) {
        for (CoordinateAxis ca : wantAxes) {
            if (this.containsAxis(ca.getFullName())) continue;
            return false;
        }
        return true;
    }

    public boolean containsAxis(String axisName) {
        for (CoordinateAxis ca : this.coordAxes) {
            if (!ca.getFullName().equals(axisName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsDomain(List<Dimension> wantDimensions) {
        for (Dimension d : wantDimensions) {
            if (this.domain.contains(d)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAxisTypes(List<AxisType> wantAxes) {
        for (AxisType wantAxisType : wantAxes) {
            if (this.containsAxisType(wantAxisType)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAxisType(AxisType wantAxisType) {
        for (CoordinateAxis ca : this.coordAxes) {
            if (ca.getAxisType() != wantAxisType) continue;
            return true;
        }
        return false;
    }

    void makeTimeAxis() {
        if (this.tAxis != null && this.tAxis instanceof CoordinateAxis1D && !(this.tAxis instanceof CoordinateAxis1DTime)) {
            Formatter err = new Formatter();
            try {
                CoordinateAxis1DTime timeAxis = CoordinateAxis1DTime.factory(this.ds, this.tAxis, err);
                this.coordAxes.remove(this.tAxis);
                this.coordAxes.add(timeAxis);
                this.tAxis = timeAxis;
                this.ds.addCoordinateAxis(timeAxis);
            }
            catch (Exception e) {
                log.error(this.tAxis.getDatasetLocation() + ": Error reading time coord= " + err, (Throwable)e);
            }
        }
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof CoordinateSystem)) {
            return false;
        }
        CoordinateSystem o = (CoordinateSystem)oo;
        if (!this.getName().equals(o.getName())) {
            return false;
        }
        List<CoordinateAxis> oaxes = o.getCoordinateAxes();
        for (CoordinateAxis axis : this.getCoordinateAxes()) {
            if (oaxes.contains(axis)) continue;
            return false;
        }
        List<CoordinateTransform> otrans = o.getCoordinateTransforms();
        for (CoordinateTransform tran : this.getCoordinateTransforms()) {
            if (otrans.contains(tran)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getName().hashCode();
            result = 37 * result + this.getCoordinateAxes().hashCode();
            this.hashCode = result = 37 * result + this.getCoordinateTransforms().hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.name;
    }
}

