/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import thredds.inventory.CollectionManager;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.MFileCollectionManager;
import ucar.nc2.util.AliasTranslator;
import ucar.nc2.util.URLnaming;
import ucar.unidata.util.StringUtil2;

public class NcmlCollectionReader {
    private static final boolean debugURL = false;
    private static final boolean debugXML = false;
    private static final boolean showParsedXML = false;
    private static final Namespace ncNSHttp = Catalog.ncmlNS;
    private static final Namespace ncNSHttps = Catalog.ncmlNSHttps;
    private static Logger log = LoggerFactory.getLogger(NcmlCollectionReader.class);
    private Namespace ncmlNS;
    private MFileCollectionManager datasetManager;
    private boolean hasInner;
    private boolean hasOuter;
    private Element netcdfElem;
    private Element aggElem;

    public static NcmlCollectionReader readNcML(String ncmlString, Formatter errlog) throws IOException {
        Document doc;
        StringReader reader = new StringReader(ncmlString);
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((Reader)new StringReader(ncmlString));
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        return NcmlCollectionReader.readXML(doc, errlog, null);
    }

    public static NcmlCollectionReader open(String ncmlLocation, Formatter errlog) throws IOException {
        Document doc;
        if (!ncmlLocation.startsWith("http:") && !ncmlLocation.startsWith("file:")) {
            ncmlLocation = "file:" + ncmlLocation;
        }
        URL url = new URL(ncmlLocation);
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(url);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        return NcmlCollectionReader.readXML(doc, errlog, ncmlLocation);
    }

    private static NcmlCollectionReader readXML(Document doc, Formatter errlog, String ncmlLocation) {
        Element netcdfElem = doc.getRootElement();
        Namespace myNS = netcdfElem.getNamespace();
        if (!myNS.equals((Object)Catalog.ncmlNS) && !myNS.equals((Object)Catalog.ncmlNSHttps)) {
            errlog.format("Incorrect namespace specified in NcML= %s must be %s%n or %s%n", myNS.getURI(), Catalog.ncmlNS.getURI(), Catalog.ncmlNSHttps.getURI());
            return null;
        }
        Element aggElem = netcdfElem.getChild("aggregation", myNS);
        if (aggElem == null) {
            errlog.format("NcML must have aggregation element", new Object[0]);
            return null;
        }
        String type = aggElem.getAttributeValue("type");
        if (!(type.equals("forecastModelRunCollection") || type.equals("forecastModelRunSingleCollection") || type.equals("fmrc"))) {
            errlog.format("NcML aggregation must be of type fmrc", new Object[0]);
            return null;
        }
        return new NcmlCollectionReader(ncmlLocation, netcdfElem);
    }

    NcmlCollectionReader(String ncmlLocation, Element netcdfElem) {
        this.ncmlNS = netcdfElem.equals((Object)Catalog.ncmlNSHttps) ? Catalog.ncmlNSHttps : Catalog.ncmlNS;
        Element aggElem = netcdfElem.getChild("aggregation", this.ncmlNS);
        String recheck = aggElem.getAttributeValue("recheckEvery");
        Element scanElem = aggElem.getChild("scan", this.ncmlNS);
        if (scanElem == null) {
            scanElem = aggElem.getChild("scanFmrc", this.ncmlNS);
        }
        if (scanElem == null) {
            HashMap<String, String> realLocationRunTimeMap = new HashMap<String, String>();
            ArrayList realLocationList = new ArrayList();
            List ncList = aggElem.getChildren("netcdf", this.ncmlNS);
            for (Element netcdfElemNested : ncList) {
                String runTime;
                String location = netcdfElemNested.getAttributeValue("location");
                if (location == null) {
                    location = netcdfElemNested.getAttributeValue("url");
                }
                if (location != null) {
                    location = AliasTranslator.translateAlias(location);
                }
                if ((runTime = netcdfElemNested.getAttributeValue("coordValue")) == null) {
                    Formatter f = new Formatter();
                    f.format("runtime must be explicitly defined for each netcdf element using the attribute coordValue", new Object[0]);
                    log.error(f.toString());
                }
                String realLocation = URLnaming.resolveFile(ncmlLocation, location);
                realLocation = StringUtil2.replace(realLocation, '\\', "/");
                realLocationRunTimeMap.put(realLocation, runTime);
            }
            this.datasetManager = MFileCollectionManager.openWithRecheck(ncmlLocation, recheck);
            this.datasetManager.setFilesAndRunDate(realLocationRunTimeMap);
        } else {
            String dirLocation = scanElem.getAttributeValue("location");
            dirLocation = URLnaming.resolve(ncmlLocation, dirLocation);
            String regexpPatternString = scanElem.getAttributeValue("regExp");
            String suffix = scanElem.getAttributeValue("suffix");
            String subdirs = scanElem.getAttributeValue("subdirs");
            String olderThan = scanElem.getAttributeValue("olderThan");
            this.datasetManager = MFileCollectionManager.openWithRecheck(ncmlLocation, recheck);
            this.datasetManager.addDirectoryScan(dirLocation, suffix, regexpPatternString, subdirs, olderThan, null);
            String dateFormatMark = scanElem.getAttributeValue("dateFormatMark");
            DateExtractorFromName dateExtractor = null;
            if (dateFormatMark != null) {
                dateExtractor = new DateExtractorFromName(dateFormatMark, true);
            } else {
                String runDateMatcher = scanElem.getAttributeValue("runDateMatcher");
                if (runDateMatcher != null) {
                    dateExtractor = new DateExtractorFromName(runDateMatcher, false);
                }
            }
            this.datasetManager.setDateExtractor(dateExtractor);
        }
        this.hasOuter = this.hasMods(netcdfElem);
        this.hasInner = this.hasMods(aggElem);
        if (this.hasOuter) {
            this.netcdfElem = netcdfElem;
        }
        if (this.hasInner) {
            this.aggElem = aggElem;
        }
    }

    private boolean hasMods(Element elem) {
        if (elem.getChildren("attribute", this.ncmlNS).size() > 0) {
            return true;
        }
        if (elem.getChildren("variable", this.ncmlNS).size() > 0) {
            return true;
        }
        if (elem.getChildren("dimension", this.ncmlNS).size() > 0) {
            return true;
        }
        if (elem.getChildren("group", this.ncmlNS).size() > 0) {
            return true;
        }
        return elem.getChildren("remove", this.ncmlNS).size() > 0;
    }

    public Element getNcmlOuter() {
        return this.netcdfElem;
    }

    public Element getNcmlInner() {
        return this.aggElem;
    }

    public CollectionManager getCollectionManager() {
        return this.datasetManager;
    }
}

