/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import thredds.filesystem.MFileOS;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.MFile;
import thredds.inventory.MFileIterator;
import ucar.nc2.util.CloseableIterator;

public class CollectionList
extends CollectionAbstract {
    protected List<MFile> mfiles = new ArrayList<MFile>();

    public CollectionList(String collectionName, String list, Logger logger) {
        super(collectionName, logger);
        String[] files;
        if (list.startsWith("list:")) {
            list = list.substring("list:".length());
        }
        long lastModified = 0L;
        for (String s : files = list.split(";")) {
            Path p;
            String filename = s.trim();
            if (filename.isEmpty() || !Files.exists(p = Paths.get(filename, new String[0]), new LinkOption[0])) continue;
            MFileOS mfile = new MFileOS(filename);
            this.mfiles.add(new MFileOS(filename));
            lastModified = Math.max(lastModified, mfile.getLastModified());
        }
        Collections.sort(this.mfiles);
        this.lastModified = lastModified;
        this.root = System.getProperty("user.dir");
    }

    public CollectionList(String collectionName, String root, List<MFile> mfiles, Logger logger) {
        super(collectionName, logger);
        this.setRoot(root);
        this.mfiles = mfiles;
    }

    protected CollectionList(String collectionName, Logger logger) {
        super(collectionName, logger);
    }

    @Override
    public Iterable<MFile> getFilesSorted() {
        return this.mfiles;
    }

    @Override
    public CloseableIterator<MFile> getFileIterator() {
        return new MFileIterator(this.mfiles.iterator(), null);
    }

    @Override
    public void close() {
    }
}

