/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.DataType;
import ucar.nc2.CDMNode;
import ucar.nc2.NetcdfFile;
import ucar.nc2.util.Indent;

@Immutable
public class EnumTypedef
extends CDMNode {
    public static final int UBYTE_MAX = 255;
    public static final int USHORT_MAX = 65535;
    private final Map<Integer, String> map;
    private final ArrayList<String> enumStrings;
    private final DataType basetype;

    public EnumTypedef(String name, Map<Integer, String> map) {
        this(name, map, DataType.ENUM4);
    }

    public EnumTypedef(String name, Map<Integer, String> map, DataType basetype) {
        super(name);
        assert (this.validateMap(map, basetype));
        this.map = map;
        this.enumStrings = new ArrayList<String>(map.values());
        Collections.sort(this.enumStrings);
        assert (basetype == DataType.ENUM1 || basetype == DataType.ENUM2 || basetype == DataType.ENUM4);
        this.basetype = basetype;
    }

    public List<String> getEnumStrings() {
        return this.enumStrings;
    }

    public Map<Integer, String> getMap() {
        return this.map;
    }

    public DataType getBaseType() {
        return this.basetype;
    }

    public boolean validateMap(Map<Integer, String> map, DataType basetype) {
        if (map == null || basetype == null) {
            return false;
        }
        block5: for (Integer i : map.keySet()) {
            switch (basetype) {
                case ENUM1: {
                    if (i >= -128 && i <= 255) continue block5;
                    return false;
                }
                case ENUM2: {
                    if (i >= Short.MIN_VALUE && i <= 65535) continue block5;
                    return false;
                }
                case ENUM4: {
                    continue block5;
                }
            }
            return false;
        }
        return true;
    }

    public String lookupEnumString(int e) {
        String result = this.map.get(e);
        return result == null ? "Unknown enum value=" + e : result;
    }

    public Integer lookupEnumInt(String name) {
        for (Map.Entry<Integer, String> entry : this.map.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String writeCDL(boolean strict) {
        Formatter out = new Formatter();
        this.writeCDL(out, new Indent(2), strict);
        return out.toString();
    }

    protected void writeCDL(Formatter out, Indent indent, boolean strict) {
        String name = strict ? NetcdfFile.makeValidCDLName(this.getShortName()) : this.getShortName();
        String basetype = "";
        switch (this.basetype) {
            case ENUM1: {
                basetype = "byte ";
                break;
            }
            case ENUM2: {
                basetype = "short ";
                break;
            }
            case ENUM4: {
                basetype = "";
                break;
            }
            default: {
                assert (false) : "Internal error";
                break;
            }
        }
        out.format("%s%senum %s { ", indent, basetype, name);
        int count = 0;
        ArrayList<Integer> keysetList = new ArrayList<Integer>(this.map.keySet());
        Collections.sort(keysetList);
        for (Integer key : keysetList) {
            String s = this.map.get(key);
            if (0 < count++) {
                out.format(", ", new Object[0]);
            }
            if (strict) {
                out.format("%s = %s", NetcdfFile.makeValidCDLName(s), key);
                continue;
            }
            out.format("'%s' = %s", s, key);
        }
        out.format("};", new Object[0]);
    }

    public boolean equals(Object o) {
        String thatname;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumTypedef that = (EnumTypedef)o;
        if (this.map == that.map) {
            return true;
        }
        if (this.map == null) {
            return false;
        }
        if (!this.map.equals(that.map)) {
            return false;
        }
        String name = this.getShortName();
        return Objects.equals(name, thatname = that.getShortName());
    }

    public int hashCode() {
        String name = this.getShortName();
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (this.map != null ? this.map.hashCode() : 0);
        return result;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("EnumTypedef %s: ", this.getShortName());
        for (int key : this.map.keySet()) {
            f.format("%d=%s,", key, this.map.get(key));
        }
        return f.toString();
    }
}

