/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.filter;

import java.util.ArrayList;
import java.util.List;
import thredds.inventory.MFile;
import thredds.inventory.MFileFilter;

public class CompositeMFileFilter
implements MFileFilter {
    private List<MFileFilter> includeFilters;
    private List<MFileFilter> excludeFilters;
    private List<MFileFilter> andFilters;

    public void addFilter(MFileFilter filter, boolean include) {
        if (include) {
            this.addIncludeFilter(filter);
        } else {
            this.addExcludeFilter(filter);
        }
    }

    public void addIncludeFilter(MFileFilter filter) {
        if (this.includeFilters == null) {
            this.includeFilters = new ArrayList<MFileFilter>();
        }
        this.includeFilters.add(filter);
    }

    public void addExcludeFilter(MFileFilter filter) {
        if (this.excludeFilters == null) {
            this.excludeFilters = new ArrayList<MFileFilter>();
        }
        this.excludeFilters.add(filter);
    }

    public void addAndFilter(MFileFilter filter) {
        if (this.andFilters == null) {
            this.andFilters = new ArrayList<MFileFilter>();
        }
        this.andFilters.add(filter);
    }

    @Override
    public boolean accept(MFile mfile) {
        return this.include(mfile) && !this.exclude(mfile) && this.andFilter(mfile);
    }

    private boolean include(MFile mfile) {
        if (this.includeFilters == null) {
            return true;
        }
        for (MFileFilter filter : this.includeFilters) {
            if (!filter.accept(mfile)) continue;
            return true;
        }
        return false;
    }

    private boolean exclude(MFile mfile) {
        if (this.excludeFilters == null) {
            return false;
        }
        for (MFileFilter filter : this.excludeFilters) {
            if (!filter.accept(mfile)) continue;
            return true;
        }
        return false;
    }

    private boolean andFilter(MFile mfile) {
        if (this.andFilters == null) {
            return true;
        }
        for (MFileFilter filter : this.andFilters) {
            if (filter.accept(mfile)) continue;
            return false;
        }
        return true;
    }
}

