/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.restrict;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.ServletUtil;
import thredds.servlet.UsageLog;
import thredds.servlet.restrict.Authorizer;
import thredds.servlet.restrict.RoleSource;

public class TomcatAuthorizer
implements Authorizer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean useSSL = false;
    private String sslPort = "8443";
    private boolean debugResourceControl = false;

    @Override
    public boolean authorize(HttpServletRequest req, HttpServletResponse res, String role) throws IOException {
        String urlr;
        if (req.isUserInRole(role)) {
            return true;
        }
        HttpSession session = req.getSession();
        session.setAttribute("origRequest", (Object)ServletUtil.getRequest(req));
        session.setAttribute("role", (Object)role);
        String string = urlr = this.useSSL ? "https://" + req.getServerName() + ":" + this.sslPort + ServletUtil.getContextPath() + "/restrictedAccess/" + role : "http://" + req.getServerName() + ":" + req.getServerPort() + ServletUtil.getContextPath() + "/restrictedAccess/" + role;
        if (this.debugResourceControl) {
            System.out.println("redirect to = " + urlr);
        }
        res.setStatus(307);
        res.addHeader("Location", urlr);
        res.setHeader("Last-Modified", "");
        return false;
    }

    @Override
    public void init(HttpServlet servlet) throws ServletException {
        String s = servlet.getInitParameter("useSSL");
        if (null != s) {
            this.useSSL = Boolean.valueOf(s);
        }
        if (null != (s = servlet.getInitParameter("portSSL"))) {
            this.sslPort = s;
        }
    }

    @Override
    public void setRoleSource(RoleSource db) {
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.log.info(UsageLog.setupRequestContext(req));
        HttpSession session = req.getSession();
        if (session != null) {
            String origURI = (String)session.getAttribute("origRequest");
            String role = (String)session.getAttribute("role");
            if (req.isUserInRole(role)) {
                if (origURI != null) {
                    res.setStatus(307);
                    String frag = origURI.indexOf("?") > 0 ? "&auth" : "?auth";
                    res.addHeader("Location", origURI);
                    if (this.debugResourceControl) {
                        System.out.println("redirect to origRequest = " + origURI);
                    }
                    this.log.info(UsageLog.closingMessageForRequestContext(307, -1L));
                    return;
                }
                res.setStatus(200);
                this.log.info(UsageLog.closingMessageForRequestContext(200, -1L));
                return;
            }
        }
        res.sendError(401, "Not authorized to access this dataset.");
        this.log.info(UsageLog.closingMessageForRequestContext(401, -1L));
    }
}

