/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.controller;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.mvc.LastModified;
import thredds.server.ncSubset.controller.SupportedFormat;
import thredds.server.ncSubset.controller.SupportedOperation;
import thredds.server.ncSubset.exception.OutOfBoundariesException;
import thredds.server.ncSubset.exception.TimeOutOfWindowException;
import thredds.server.ncSubset.exception.UnsupportedResponseFormatException;
import thredds.server.ncSubset.params.RequestParamsBean;
import thredds.server.ncSubset.util.NcssRequestUtils;
import thredds.servlet.DataRootHandler;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;

public abstract class AbstractNcssController
implements LastModified {
    private static final Logger log = LoggerFactory.getLogger(AbstractNcssController.class);
    protected static final String NETCDF_FORMAT_NAME = "NETCDF";
    protected static final String servletPath = "/ncss/grid";
    protected static final String servletCachePath = "/cache/ncss";
    protected String requestPathInfo = null;
    protected GridDataset gridDataset = null;

    void setRequestPathInfo(String requestPathInfo) {
        this.requestPathInfo = requestPathInfo;
    }

    public String getRequestPathInfo() {
        return this.requestPathInfo;
    }

    void setGridDataset(GridDataset gds) {
        this.gridDataset = gds;
    }

    public GridDataset getGridDataset() {
        return this.gridDataset;
    }

    protected List<CalendarDate> getRequestedDates(GridDataset gds, RequestParamsBean params) throws OutOfBoundariesException, ParseException, TimeOutOfWindowException {
        GridAsPointDataset gap = NcssRequestUtils.buildGridAsPointDataset(gds, params.getVar());
        long time_window = 0L;
        if (params.getTime_window() != null) {
            TimeDuration dTW = new TimeDuration(params.getTime_window());
            time_window = (long)dTW.getValueInSeconds() * 1000L;
        }
        if (params.getTemporal() != null && params.getTemporal().equals("all")) {
            return gap.getDates();
        }
        if (params.getTime() == null && params.getTime_start() == null && params.getTime_end() == null && params.getTime_duration() == null) {
            ArrayList<CalendarDate> closestToPresent = new ArrayList<CalendarDate>();
            CalendarDate now = CalendarDate.of((Date)new Date());
            CalendarDate start = (CalendarDate)gap.getDates().get(0);
            CalendarDate end = (CalendarDate)gap.getDates().get(gap.getDates().size() - 1);
            if (now.isBefore(start)) {
                if (time_window <= 0L || Math.abs(now.getDifferenceInMsecs(start)) < time_window) {
                    closestToPresent.add(start);
                    return closestToPresent;
                }
                throw new TimeOutOfWindowException("There is not time within the provided time window");
            }
            if (now.isAfter(end)) {
                if (time_window <= 0L || Math.abs(now.getDifferenceInMsecs(end)) < time_window) {
                    closestToPresent.add(end);
                    return closestToPresent;
                }
                throw new TimeOutOfWindowException("There is not time within the provided time window");
            }
            return NcssRequestUtils.wantedDates(gap, CalendarDateRange.of((CalendarDate)now, (CalendarDate)now), time_window);
        }
        if (params.getTime_window() != null && params.getTime() != null) {
            DateRange dr = new DateRange(new DateType(params.getTime(), null, null), null, new TimeDuration(params.getTime_window()), null);
            time_window = CalendarDateRange.of((DateRange)dr).getDurationInSecs() * 1000L;
        }
        CalendarDateRange dates = this.getRequestedDateRange(params);
        return NcssRequestUtils.wantedDates(gap, dates, time_window);
    }

    CalendarDateRange getRequestedDateRange(RequestParamsBean params) throws ParseException {
        if (params.getTime() != null) {
            CalendarDate date = null;
            date = params.getTime().equalsIgnoreCase("present") ? CalendarDate.of((Date)new Date()) : CalendarDate.of((Date)CalendarDateFormatter.isoStringToDate((String)params.getTime()));
            return CalendarDateRange.of((CalendarDate)date, (CalendarDate)date);
        }
        CalendarDateRange dates = null;
        DateRange dr = new DateRange(new DateType(params.getTime_start(), null, null), new DateType(params.getTime_end(), null, null), new TimeDuration(params.getTime_duration()), null);
        dates = CalendarDateRange.of((DateRange)dr);
        return dates;
    }

    protected void handleValidationErrorsResponse(HttpServletResponse response, int status, BindingResult validationResult) {
        List errors = validationResult.getAllErrors();
        StringBuffer responseStr = new StringBuffer();
        responseStr.append("Validation errors: ");
        for (ObjectError err : errors) {
            responseStr.append(err.getDefaultMessage());
            responseStr.append("  -- ");
        }
        try {
            PrintWriter pw = response.getWriter();
            pw.write(responseStr.toString());
            pw.flush();
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage());
        }
    }

    protected void setResponseHeaders(HttpServletResponse response, HttpHeaders httpHeaders) {
        Set keySet = httpHeaders.keySet();
        for (String key : keySet) {
            if (!httpHeaders.containsKey((Object)key)) continue;
            response.setHeader(key, (String)httpHeaders.get((Object)key).get(0));
        }
    }

    protected SupportedFormat getSupportedFormat(RequestParamsBean params, SupportedOperation operation) throws UnsupportedResponseFormatException {
        SupportedFormat sf;
        if (params.getAccept() == null) {
            sf = operation.getDefaultFormat();
            params.setAccept(sf.getFormatName());
        } else {
            sf = SupportedOperation.isSupportedFormat(params.getAccept(), operation);
            if (sf == null) {
                throw new UnsupportedResponseFormatException("Requested format: " + params.getAccept() + " is not supported for " + operation.getOperation().toLowerCase());
            }
        }
        return sf;
    }

    public static final String getServletPath() {
        return servletPath;
    }

    public static final String getServletCachePath() {
        return servletCachePath;
    }

    public static final String buildCacheUrl(String fileName) {
        return NcssRequestUtils.getTdsContext().getContextPath() + AbstractNcssController.getServletCachePath() + "/" + fileName;
    }

    public long getLastModified(HttpServletRequest req) {
        File file = DataRootHandler.getInstance().getCrawlableDatasetAsFile(req.getPathInfo());
        if (file != null && file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }
}

